/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemMirrorPrint
extends Item
implements IPatternItem {
    SimpleInstanceCache<ItemStack, List<String>> toolTipCache = new SimpleInstanceCache(null, new ArrayList());

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List tooltip, boolean advanced) {
        super.func_77624_a(stack, playerIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpMirrorPrint, tooltip, new String[0]);
        if (this.isWritten(stack)) {
            if (ClientSide.instance.holdingShift()) {
                if (this.toolTipCache.needsUpdate(stack)) {
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    this.toolTipCache.updateCachedValue(blob.listContents(new ArrayList<String>()));
                }
                tooltip.addAll((Collection)this.toolTipCache.getCached());
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.isWritten(stack)) {
            return super.func_77667_c(stack) + "_written";
        }
        return super.func_77667_c(stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.SUCCESS;
        }
        if (!this.isWritten(stack)) {
            NBTTagCompound comp = this.getCompoundFromBlock(world, pos, player, side);
            if (comp != null) {
                stack.func_77982_d(comp);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    protected NBTTagCompound getCompoundFromBlock(World world, BlockPos pos, EntityPlayer player, EnumFacing face) {
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, false);
        if (te != null) {
            NBTTagCompound comp = new NBTTagCompound();
            te.writeChisleData(comp);
            TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
            tmp.readChisleData(comp);
            VoxelBlob bestBlob = tmp.getBlob();
            tmp.setBlob(bestBlob.mirror(face.func_176740_k()));
            tmp.writeChisleData(comp);
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((EntityLivingBase)player).ordinal());
            return comp;
        }
        return null;
    }

    @Override
    public ItemStack getPatternedItem(ItemStack stack) {
        if (!this.isWritten(stack)) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        NBTBlobConverter conv = new NBTBlobConverter();
        conv.readChisleData(tag);
        VoxelBlob.BlobStats common = conv.getBlob().getVoxelStats();
        if (common.isFullBlock) {
            IBlockState state = Block.func_176220_d((int)common.mostCommonState);
            return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        }
        IBlockState blk = conv.getPrimaryBlockState();
        ItemStack itemstack = new ItemStack((Block)ChiselsAndBits.getBlocks().getConversionWithDefault(blk), 1);
        itemstack.func_77983_a("BlockEntityTag", (NBTBase)tag);
        return itemstack;
    }

    @Override
    public boolean isWritten(ItemStack stack) {
        return stack != null && stack.func_77942_o();
    }
}

