/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thut.api.ThutBlocks;
import thut.api.maths.Matrix3;
import thut.api.maths.Vector3;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.handlers.ConfigHandler;
import thut.tech.common.items.ItemLinker;

public class EntityLift
extends EntityLivingBase
implements IEntityAdditionalSpawnData {
    static final DataParameter<Integer> DESTINATIONFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Integer> DESTINATIONYDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Integer> CURRENTFLOORDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187192_b);
    static final DataParameter<Optional<ItemStack>> CAMOBLOCKDW = EntityDataManager.func_187226_a(EntityLift.class, (DataSerializer)DataSerializers.field_187196_f);
    public static int ACCELERATIONTICKS = 20;
    public static boolean ENERGYUSE = false;
    public static int ENERGYCOST = 100;
    private static HashMap<UUID, EntityLift> lifts = new HashMap();
    private static HashMap<UUID, EntityLift> lifts2 = new HashMap();
    public Vector3 boundMin = Vector3.getNewVector();
    public Vector3 boundMax = Vector3.getNewVector();
    int energy = 0;
    private LiftWorld world;
    public double speedUp = ConfigHandler.LiftSpeedUp;
    public double speedDown = -ConfigHandler.LiftSpeedDown;
    public double acceleration = 0.05;
    public boolean up = true;
    public boolean toMoveY = false;
    public boolean moved = false;
    public boolean axis = true;
    public boolean hasPassenger = false;
    int n = 0;
    int passengertime = 10;
    boolean first = true;
    Random r = new Random();
    public UUID id = UUID.randomUUID();
    public UUID owner;
    public double prevFloorY = 0.0;
    public double prevFloor = 0.0;
    public boolean called = false;
    TileEntityLiftAccess current;
    Matrix3 mainBox = new Matrix3();
    Matrix3 tempBox = new Matrix3();
    public List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    public int[] floors = new int[64];
    Matrix3 base = new Matrix3();
    Matrix3 top = new Matrix3();
    Matrix3 wall1 = new Matrix3();
    public ItemStack[][][] blocks = null;

    public static void clear() {
        lifts2.clear();
        lifts.clear();
    }

    public static EntityLift getLiftFromUUID(UUID uuid, boolean client) {
        if (client) {
            return lifts2.get(uuid);
        }
        return lifts.get(uuid);
    }

    public static void removeBlocks(World worldObj, TileEntityLiftAccess te, BlockPos pos) {
        int xMin = te.boundMin.intX();
        int zMin = te.boundMin.intZ();
        int xMax = te.boundMax.intX();
        int zMax = te.boundMax.intZ();
        int yMin = te.boundMin.intY();
        int yMax = te.boundMax.intY();
        Vector3 loc = Vector3.getNewVector();
        for (int i = xMin; i <= xMax; ++i) {
            for (int j = zMin; j <= zMax; ++j) {
                for (int k = yMin; k <= yMax; ++k) {
                    worldObj.func_175698_g(loc.set((Object)pos).add((double)i, (double)k, (double)j).getPos());
                }
            }
        }
    }

    public static ItemStack[][][] checkBlocks(World worldObj, TileEntityLiftAccess te, BlockPos pos) {
        int xMin = te.boundMin.intX();
        int zMin = te.boundMin.intZ();
        int xMax = te.boundMax.intX();
        int zMax = te.boundMax.intZ();
        int yMin = te.boundMin.intY();
        int yMax = te.boundMax.intY();
        ItemStack[][][] ret = new ItemStack[xMax - xMin + 1][yMax - yMin + 1][zMax - zMin + 1];
        Vector3 loc = Vector3.getNewVector().set((Object)pos);
        for (int i = xMin; i <= xMax; ++i) {
            for (int k = yMin; k <= yMax; ++k) {
                for (int j = zMin; j <= zMax; ++j) {
                    if (i != 0 || j != 0 || k != 0) {
                        IBlockState state = loc.set((Object)pos).addTo((double)i, (double)k, (double)j).getBlockState((IBlockAccess)worldObj);
                        Block b = state.func_177230_c();
                        if (!(b instanceof ITileEntityProvider)) {
                            ret[i - xMin][k - yMin][j - zMin] = new ItemStack(b, 1, b.func_176201_c(state));
                            continue;
                        }
                        if (k != 0 && state.func_177230_c().isAir(state, (IBlockAccess)worldObj, pos)) continue;
                        return null;
                    }
                    ret[i - xMin][k - yMin][j - zMin] = new ItemStack(ThutBlocks.lift);
                }
            }
        }
        return ret;
    }

    public EntityLift(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.field_70178_ae = true;
        for (int i = 0; i < 64; ++i) {
            this.floors[i] = -1;
        }
    }

    public LiftWorld getLiftWorld() {
        if (this.world == null) {
            this.world = new LiftWorld(this);
        }
        return this.world;
    }

    public EntityLift(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.r.setSeed(100L);
        lifts.put(this.id, this);
    }

    public void accelerate() {
        if (this.func_70613_aW() && !this.consumePower()) {
            this.toMoveY = false;
        }
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70181_x = !this.toMoveY ? (this.field_70181_x *= 0.5) : (this.up ? Math.min(this.speedUp, this.field_70181_x + this.acceleration * this.speedUp) : Math.max(this.speedDown, this.field_70181_x + this.acceleration * this.speedDown));
    }

    public void func_70108_f(Entity entity) {
        AxisAlignedBB box;
        AxisAlignedBB blockBox;
        Vector3 v = Vector3.getNewVector();
        Vector3 v1 = Vector3.getNewVector();
        this.blockBoxes.clear();
        int sizeX = this.blocks.length;
        int sizeY = this.blocks[0].length;
        int sizeZ = this.blocks[0][0].length;
        HashSet topY = Sets.newHashSet();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int xMin = this.boundMin.intX();
        int zMin = this.boundMin.intZ();
        int yMin = this.boundMin.intY();
        for (int i = 0; i < sizeX; ++i) {
            for (int k = 0; k < sizeY; ++k) {
                for (int j = 0; j < sizeZ; ++j) {
                    ItemStack stack = this.blocks[i][k][j];
                    if (stack == null || stack.func_77973_b() == null) continue;
                    pos.func_181079_c(i + xMin, j + yMin, k + zMin);
                    Block block = Block.func_149634_a((Item)stack.func_77973_b());
                    IBlockState state = block.func_176203_a(stack.func_77952_i());
                    blockBox = null;
                    try {
                        blockBox = block.func_185496_a(state, (IBlockAccess)this.field_70170_p, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (blockBox == null) continue;
                    box = Matrix3.getAABB((double)(this.field_70165_t + blockBox.field_72340_a - 0.5 + this.boundMin.x + (double)i), (double)(this.field_70163_u + blockBox.field_72338_b + (double)k), (double)(this.field_70161_v + blockBox.field_72339_c - 0.5 + this.boundMin.z + (double)j), (double)(this.field_70165_t + blockBox.field_72336_d - 0.5 + this.boundMin.x + (double)i), (double)(this.field_70163_u + blockBox.field_72337_e + (double)k), (double)(this.field_70161_v + blockBox.field_72334_f - 0.5 + this.boundMin.z + (double)j));
                    this.blockBoxes.add(box);
                    topY.add(box.field_72337_e);
                }
            }
        }
        pos.func_189533_g((Vec3i)this.func_180425_c());
        int mx = sizeX / 2;
        int mz = sizeZ / 2;
        if (sizeY > 1 && this.field_70181_x == 0.0 && entity.field_70163_u < this.field_70163_u) {
            for (int i = -1 - mx; i <= 1 + mx; ++i) {
                for (int j = -1 - mz; j <= 1 + mz; ++j) {
                    pos.func_189533_g((Vec3i)this.func_180425_c().func_177977_b());
                    pos.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p() + j);
                    IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                    Block block = state.func_177230_c();
                    blockBox = block.func_185496_a(state, (IBlockAccess)this.field_70170_p, (BlockPos)pos);
                    if (blockBox == null) continue;
                    box = blockBox.func_186670_a((BlockPos)pos);
                    this.blockBoxes.add(box);
                }
            }
        }
        v.setToVelocity(entity).subtractFrom(v1.setToVelocity((Entity)this));
        v1.clear();
        Matrix3.doCollision(this.blockBoxes, (AxisAlignedBB)entity.func_174813_aQ(), (Entity)entity, (double)this.field_70181_x, (Vector3)v, (Vector3)v1);
        for (Double d : topY) {
            if (!(entity.field_70163_u >= d) || !(entity.field_70163_u + entity.field_70181_x <= d) || !(this.field_70181_x <= 0.0)) continue;
            double diff = entity.field_70163_u + entity.field_70181_x - (d + this.field_70181_x);
            double check = Math.max(0.5, Math.abs(entity.field_70181_x + this.field_70181_x));
            if (!(diff > 0.0) && !(diff < -0.5) && !(Math.abs(diff) > check)) continue;
            entity.field_70181_x = 0.0;
        }
        boolean collidedY = false;
        if (!v1.isEmpty()) {
            if (v1.y >= 0.0) {
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
                entity.func_180430_e(entity.field_70143_R, 0.0f);
            } else if (v1.y < 0.0) {
                boolean below;
                boolean bl = below = entity.field_70163_u + (double)entity.field_70131_O - (entity.field_70181_x + this.field_70181_x) < this.field_70163_u;
                if (below) {
                    v1.y = 0.0;
                }
            }
            if (v1.x != 0.0) {
                entity.field_70159_w = 0.0;
            }
            if (v1.y != 0.0) {
                entity.field_70181_x = this.field_70181_x;
            }
            if (v1.z != 0.0) {
                entity.field_70179_y = 0.0;
            }
            if (v1.y != 0.0) {
                collidedY = true;
            }
            v1.addTo(v.set((Object)entity));
            v1.moveEntity(entity);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_70170_p.field_72995_K && ConfigHandler.jitterfix) {
                Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
            }
            if (Math.abs(player.field_70181_x) < 0.1 && !player.field_71075_bZ.field_75100_b) {
                entity.field_70122_E = true;
                entity.field_70143_R = 0.0f;
            }
            if (!player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)player;
                if (collidedY) {
                    entityplayer.field_71135_a.field_147365_f = 0;
                }
            }
        }
    }

    public boolean attackEntityFrom(DamageSource source, int damage) {
        return false;
    }

    public void call(int floor) {
        if (floor == 0 || floor > 64) {
            return;
        }
        if (this.floors[floor - 1] > 0) {
            this.callYValue(this.floors[floor - 1]);
            this.setDestinationFloor(floor);
        }
    }

    public void callYValue(int yValue) {
        this.setDestY(yValue);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean checkBlocks(double dir) {
        boolean ret = true;
        Vector3 thisloc = Vector3.getNewVector().set((Object)this).addTo(0.0, dir, 0.0);
        if (this.called) {
            if (dir > 0.0 && thisloc.y > (double)this.getDestY()) {
                return false;
            }
            if (dir < 0.0 && thisloc.y < (double)this.getDestY()) {
                return false;
            }
        }
        int xMin = this.boundMin.intX();
        int zMin = this.boundMin.intZ();
        int xMax = this.boundMax.intX();
        int zMax = this.boundMax.intZ();
        Vector3 v = Vector3.getNewVector();
        for (int i = xMin; i <= xMax; ++i) {
            for (int j = zMin; j <= zMax; ++j) {
                ret = ret && v.set(thisloc).addTo((double)i, 0.0, (double)j).clearOfBlocks((IBlockAccess)this.field_70170_p);
            }
        }
        return ret;
    }

    public void checkCollision() {
        int zMax;
        int xMax;
        int zMin;
        int xMin = this.boundMin.intX();
        List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t + (double)(xMin - 1), this.field_70163_u, this.field_70161_v + (double)((zMin = this.boundMin.intZ()) - 1), this.field_70165_t + (double)(xMax = this.boundMax.intX()) + 1.0, this.field_70163_u + 64.0, this.field_70161_v + (double)(zMax = this.boundMax.intZ()) + 1.0));
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1 && this.func_184182_bu() != null && !this.func_184182_bu().isEmpty()) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
            }
        }
    }

    public void clearLiquids() {
    }

    private boolean consumePower() {
        if (!ENERGYUSE || !this.toMoveY) {
            return true;
        }
        boolean power = false;
        Vector3 bounds = this.boundMax.subtract(this.boundMin);
        double volume = bounds.x * bounds.y * bounds.z;
        double energyCost = Math.abs((double)this.getDestY() - this.field_70163_u) * (double)ENERGYCOST * volume * 0.01;
        if ((energyCost = Math.max(energyCost, 1.0)) <= 0.0) {
            return true;
        }
        this.energy = (int)((double)this.energy - energyCost);
        boolean bl = power = this.energy > 0;
        if (this.energy < 0) {
            this.energy = 0;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventLiftConsumePower(this, (long)energyCost));
        if (!power) {
            this.setDestinationFloor(-1);
            this.setDestY(0);
            this.toMoveY = false;
        }
        return power;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void doMotion() {
        if (this.up) {
            if (this.checkBlocks(this.field_70181_x * (double)(ACCELERATIONTICKS + 1))) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            while (this.field_70181_x >= 0.0 && !this.checkBlocks((this.field_70181_x - this.acceleration * this.speedUp / 10.0) * (double)(ACCELERATIONTICKS + 1))) {
                this.field_70181_x -= this.acceleration * this.speedUp / 10.0;
            }
            if (this.checkBlocks(this.field_70181_x)) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            this.func_70107_b(this.field_70165_t, Math.abs(this.field_70163_u - (double)this.getDestY()) < 0.5 ? (double)this.getDestY() : Math.floor(this.field_70163_u), this.field_70161_v);
            this.called = false;
            this.prevFloor = this.getDestinationFloor();
            this.prevFloorY = this.getDestY();
            this.setDestY(-1);
            this.setDestinationFloor(0);
            this.current = null;
            this.field_70181_x = 0.0;
            this.toMoveY = false;
            this.moved = false;
        } else {
            if (this.checkBlocks(this.field_70181_x * (double)(ACCELERATIONTICKS + 1))) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            while (this.field_70181_x <= 0.0 && !this.checkBlocks((this.field_70181_x - this.acceleration * this.speedDown / 10.0) * (double)(ACCELERATIONTICKS + 1))) {
                this.field_70181_x -= this.acceleration * this.speedDown / 10.0;
            }
            if (this.checkBlocks(this.field_70181_x)) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u + this.field_70181_x, this.field_70161_v);
                this.moved = true;
                return;
            }
            this.func_70107_b(this.field_70165_t, Math.abs(this.field_70163_u - (double)this.getDestY()) < 0.5 ? (double)this.getDestY() : Math.floor(this.field_70163_u), this.field_70161_v);
            this.called = false;
            this.prevFloor = this.getDestinationFloor();
            this.prevFloorY = this.getDestY();
            this.setDestY(-1);
            this.setDestinationFloor(0);
            this.current = null;
            this.field_70181_x = 0.0;
            this.toMoveY = false;
            this.moved = false;
        }
        this.toMoveY = false;
        this.moved = false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESTINATIONFLOORDW, (Object)0);
        this.field_70180_af.func_187214_a(DESTINATIONYDW, (Object)0);
        this.field_70180_af.func_187214_a(CURRENTFLOORDW, (Object)-1);
        this.field_70180_af.func_187214_a(CAMOBLOCKDW, (Object)Optional.absent());
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    public int getCurrentFloor() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENTFLOORDW);
    }

    public int getDestinationFloor() {
        return (Integer)this.field_70180_af.func_187225_a(DESTINATIONFLOORDW);
    }

    public int getDestY() {
        return (Integer)this.field_70180_af.func_187225_a(DESTINATIONYDW);
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, @Nullable ItemStack stack, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public boolean func_184230_a(EntityPlayer player, @Nullable ItemStack stack, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (player.func_70093_af() && item != null && item.func_77973_b() instanceof ItemLinker && (this.owner != null && player.func_110124_au().equals(this.owner) || player.field_71075_bZ.field_75098_d)) {
            if (item.func_77978_p() == null) {
                item.func_77982_d(new NBTTagCompound());
            }
            item.func_77978_p().func_74778_a("lift", this.id.toString());
            String message = "msg.liftSet.name";
            if (this.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
            }
            return true;
        }
        if (item != null && item.func_77973_b() instanceof ItemLinker && (this.owner != null && player.func_110124_au().equals(this.owner) || player.field_71075_bZ.field_75098_d)) {
            if (!this.field_70170_p.field_72995_K && this.owner != null) {
                EntityPlayer ownerentity = this.field_70170_p.func_152378_a(this.owner);
                String message = "msg.lift.owner";
                player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{ownerentity.func_70005_c_()}));
            }
            return true;
        }
        if (player.func_70093_af() && item != null && (player.func_184586_b(hand).func_77973_b().func_77658_a().toLowerCase().contains("wrench") || player.func_184586_b(hand).func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || player.func_184586_b(hand).func_77973_b().func_77658_a().equals(Items.field_151055_y.func_77658_a())) && (this.owner != null && player.func_110124_au().equals(this.owner) || player.field_71075_bZ.field_75098_d)) {
            if (!this.field_70170_p.field_72995_K) {
                String message = "msg.lift.killed";
                player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
                this.func_70606_j(0.0f);
                this.func_70106_y();
            }
            return true;
        }
        if (player.func_70093_af() && item != null && Block.func_149634_a((Item)item.func_77973_b()) != null && (this.owner == null || this.owner.equals(player.func_110124_au()))) {
            System.out.println("Test");
            Block block = Block.func_149634_a((Item)item.func_77973_b());
            if (!(block instanceof ITileEntityProvider)) {
                ItemStack item2 = item.func_77979_a(1);
                if (this.func_184586_b(null) != null && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(this.func_184586_b(null), 1.0f);
                }
                if (!this.field_70170_p.field_72995_K) {
                    String message = "msg.lift.camo";
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{item.func_82833_r()}));
                    this.func_184611_a(null, item2);
                }
            }
            return true;
        }
        if (player.func_70093_af() && item == null && (this.owner == null || this.owner.equals(player.func_110124_au()))) {
            if (this.func_184586_b(null) != null && !this.field_70170_p.field_72995_K) {
                this.func_70099_a(this.func_184586_b(null), 1.0f);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184611_a(null, null);
            }
            return true;
        }
        return false;
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    public void func_70071_h_() {
        if (ForgeHooks.onLivingUpdate((EntityLivingBase)this)) {
            return;
        }
        this.field_70167_r = this.field_70163_u;
        this.clearLiquids();
        if (this.field_70181_x == 0.0) {
            this.func_70107_b(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
        }
        if (!this.checkBlocks(0.0)) {
            this.toMoveY = false;
        }
        this.called = this.getDestY() > 0;
        this.toMoveY = this.called;
        this.up = (double)this.getDestY() > this.field_70163_u;
        this.accelerate();
        if (this.toMoveY) {
            this.doMotion();
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, Math.round(this.field_70163_u), this.field_70161_v);
        }
        this.checkCollision();
        this.passengertime = this.hasPassenger ? 20 : this.passengertime - 1;
        ++this.n;
    }

    public void passengerCheck() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        this.hasPassenger = list.size() > 0;
    }

    public void readBlocks(NBTTagCompound nbt) {
        block17: {
            NBTTagCompound blockTag;
            block16: {
                if (!nbt.func_74764_b("BlocksLength") && !nbt.func_74764_b("BlocksLengthX")) break block16;
                int sizeX = nbt.func_74762_e("BlocksLengthX");
                int sizeZ = nbt.func_74762_e("BlocksLengthZ");
                int sizeY = nbt.func_74762_e("BlocksLengthY");
                if (sizeX == 0 || sizeZ == 0) {
                    sizeX = sizeZ = nbt.func_74762_e("BlocksLength");
                }
                if (sizeY == 0) {
                    sizeY = 1;
                }
                this.blocks = new ItemStack[sizeX][sizeY][sizeZ];
                for (int i = 0; i < sizeX; ++i) {
                    for (int k = 0; k < sizeY; ++k) {
                        for (int j = 0; j < sizeZ; ++j) {
                            ItemStack b;
                            int n = -1;
                            if (nbt.func_74764_b("block" + i + "," + j)) {
                                n = nbt.func_74762_e("block" + i + "," + j);
                            } else if (nbt.func_74764_b("block" + i + "," + k + "," + j)) {
                                n = nbt.func_74762_e("block" + i + "," + k + "," + j);
                            }
                            if (n == -1) continue;
                            this.blocks[i][k][j] = b = new ItemStack(Item.func_150899_d((int)n), 1, nbt.func_74762_e("meta" + i + "," + k + "," + j));
                        }
                    }
                }
                break block17;
            }
            if (!nbt.func_74764_b("Blocks") || !(blockTag = nbt.func_74775_l("Blocks")).func_74764_b("BlocksLength") && !blockTag.func_74764_b("BlocksLengthX")) break block17;
            int sizeX = blockTag.func_74762_e("BlocksLengthX");
            int sizeZ = blockTag.func_74762_e("BlocksLengthZ");
            int sizeY = blockTag.func_74762_e("BlocksLengthY");
            if (sizeX == 0 || sizeZ == 0) {
                sizeX = sizeZ = nbt.func_74762_e("BlocksLength");
            }
            if (sizeY == 0) {
                sizeY = 1;
            }
            this.blocks = new ItemStack[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        ItemStack b;
                        int n = -1;
                        if (blockTag.func_74764_b("I" + i + "," + j)) {
                            n = blockTag.func_74762_e("I" + i + "," + j);
                        } else if (blockTag.func_74764_b("I" + i + "," + k + "," + j)) {
                            n = blockTag.func_74762_e("I" + i + "," + k + "," + j);
                        }
                        if (n == -1) continue;
                        this.blocks[i][k][j] = b = new ItemStack(Item.func_150899_d((int)n), 1, blockTag.func_74762_e("M" + i + "," + k + "," + j));
                    }
                }
            }
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.axis = nbt.func_74767_n("axis");
        this.energy = nbt.func_74762_e("energy");
        if (nbt.func_74764_b("size")) {
            double size = nbt.func_74769_h("size");
            int xMin = (int)(-size / 2.0);
            int zMin = (int)(-size / 2.0);
            int xMax = (int)(size / 2.0);
            int zMax = (int)(size / 2.0);
            this.boundMin.x = xMin;
            this.boundMin.z = zMin;
            this.boundMax.x = xMax;
            this.boundMax.z = zMax;
        } else if (nbt.func_74764_b("corners")) {
            int[] read = nbt.func_74759_k("corners");
            int xMin = read[0];
            int zMin = read[1];
            int xMax = read[2];
            int zMax = read[3];
            this.boundMin.x = xMin;
            this.boundMin.z = zMin;
            this.boundMax.x = xMax;
            this.boundMax.z = zMax;
        }
        if (nbt.func_74764_b("bounds")) {
            NBTTagCompound bounds = nbt.func_74775_l("bounds");
            this.boundMin = Vector3.readFromNBT((NBTTagCompound)bounds, (String)"min");
            this.boundMax = Vector3.readFromNBT((NBTTagCompound)bounds, (String)"max");
        }
        this.id = new UUID(nbt.func_74763_f("higher"), nbt.func_74763_f("lower"));
        if (nbt.func_74764_b("ownerhigher")) {
            this.owner = new UUID(nbt.func_74763_f("ownerhigher"), nbt.func_74763_f("ownerlower"));
        }
        if (nbt.func_74764_b("replacement")) {
            NBTTagCompound held = nbt.func_74775_l("replacement");
            this.func_184611_a(null, ItemStack.func_77949_a((NBTTagCompound)held));
        }
        this.readList(nbt);
        this.readBlocks(nbt);
    }

    public void readList(NBTTagCompound nbt) {
        if (nbt.func_74764_b("floors 0")) {
            for (int i = 0; i < 64; ++i) {
                this.floors[i] = nbt.func_74762_e("floors " + i);
                if (this.floors[i] != 0) continue;
                this.floors[i] = -1;
            }
        } else {
            NBTTagCompound floorTag = nbt.func_74775_l("floors");
            for (int i = 0; i < 64; ++i) {
                this.floors[i] = floorTag.func_74762_e("" + i);
                if (this.floors[i] != 0) continue;
                this.floors[i] = -1;
            }
        }
    }

    public void readSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        try {
            tag = buff.func_150793_b();
            this.func_70037_a(tag);
            lifts2.put(this.id, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentFloor(int currentFloor) {
        this.field_70180_af.func_187227_b(CURRENTFLOORDW, (Object)currentFloor);
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.func_110143_aJ() == 0.0f && this.blocks != null) {
            ItemStack[][][] itemStackArray = this.blocks;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[][] barrarr;
                ItemStack[][] itemStackArray2 = barrarr = itemStackArray[i];
                int n2 = itemStackArray2.length;
                for (int j = 0; j < n2; ++j) {
                    ItemStack[] barr;
                    for (ItemStack b : barr = itemStackArray2[j]) {
                        if (b == null) continue;
                        this.func_70099_a(b, 0.5f);
                    }
                }
            }
            if (this.func_184586_b(null) != null) {
                this.func_70099_a(this.func_184586_b(null), 1.0f);
            }
        }
        super.func_70106_y();
    }

    public void setDestinationFloor(int destinationFloor) {
        this.field_70180_af.func_187227_b(DESTINATIONFLOORDW, (Object)destinationFloor);
    }

    public void setDestY(int dest) {
        this.field_70180_af.func_187227_b(DESTINATIONYDW, (Object)dest);
    }

    public void setFoor(TileEntityLiftAccess te, int floor) {
        if (te.floor == 0) {
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
        } else if (te.floor != 0) {
            this.floors[te.floor - 1] = -1;
            this.floors[floor - 1] = te.func_174877_v().func_177956_o() - 2;
        }
    }

    public void writeBlocks(NBTTagCompound nbt) {
        if (this.blocks != null) {
            NBTTagCompound blocksTag = new NBTTagCompound();
            blocksTag.func_74768_a("BlocksLengthX", this.blocks.length);
            blocksTag.func_74768_a("BlocksLengthY", this.blocks[0].length);
            blocksTag.func_74768_a("BlocksLengthZ", this.blocks[0][0].length);
            int sizeX = this.blocks.length;
            int sizeY = this.blocks[0].length;
            int sizeZ = this.blocks[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        ItemStack b = this.blocks[i][k][j];
                        if (b == null || b.func_77973_b() == null) continue;
                        blocksTag.func_74768_a("I" + i + "," + k + "," + j, Item.func_150891_b((Item)b.func_77973_b()));
                        blocksTag.func_74768_a("M" + i + "," + k + "," + j, b.func_77952_i());
                    }
                }
            }
            nbt.func_74782_a("Blocks", (NBTBase)blocksTag);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("axis", this.axis);
        NBTTagCompound vector = new NBTTagCompound();
        this.boundMin.writeToNBT(vector, "min");
        this.boundMax.writeToNBT(vector, "max");
        nbt.func_74782_a("bounds", (NBTBase)vector);
        nbt.func_74768_a("energy", this.energy);
        nbt.func_74772_a("lower", this.id.getLeastSignificantBits());
        nbt.func_74772_a("higher", this.id.getMostSignificantBits());
        if (this.owner != null) {
            nbt.func_74772_a("ownerlower", this.owner.getLeastSignificantBits());
            nbt.func_74772_a("ownerhigher", this.owner.getMostSignificantBits());
        }
        if (this.func_184586_b(null) != null) {
            NBTTagCompound held = new NBTTagCompound();
            this.func_184586_b(null).func_77955_b(held);
            nbt.func_74782_a("replacement", (NBTBase)held);
        }
        this.writeList(nbt);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeList(NBTTagCompound nbt) {
        NBTTagCompound floorTag = new NBTTagCompound();
        for (int i = 0; i < 64; ++i) {
            floorTag.func_74768_a("" + i, this.floors[i]);
        }
        nbt.func_74782_a("floors", (NBTBase)floorTag);
    }

    public void writeSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        buff.func_150786_a(tag);
        if (lifts.get(this.id) != this) {
            lifts.put(this.id, this);
        }
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Lists.newArrayList();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return null;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public ItemStack func_184586_b(EnumHand hand) {
        return (ItemStack)((Optional)this.field_70180_af.func_187225_a(CAMOBLOCKDW)).orNull();
    }

    public void func_184611_a(EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null) {
            this.field_70180_af.func_187227_b(CAMOBLOCKDW, (Object)Optional.of((Object)stack));
        } else {
            this.field_70180_af.func_187227_b(CAMOBLOCKDW, (Object)Optional.absent());
        }
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }

    public static class LiftWorld
    implements IBlockAccess {
        final EntityLift lift;

        public LiftWorld(EntityLift lift) {
            this.lift = lift;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            int xMin = this.lift.boundMin.intX();
            int zMin = this.lift.boundMin.intZ();
            int yMin = this.lift.boundMin.intY();
            int i = pos.func_177958_n() - xMin;
            int j = pos.func_177956_o() - yMin;
            int k = pos.func_177952_p() - zMin;
            Block b = Blocks.field_150350_a;
            int meta = 0;
            if (i >= this.lift.blocks.length || j >= this.lift.blocks[0].length || k >= this.lift.blocks[0][0].length || i < 0 || j < 0 || k < 0) {
                return b.func_176223_P();
            }
            ItemStack stack = this.lift.blocks[i][j][k];
            if (stack == null) {
                return Blocks.field_150350_a.func_176223_P();
            }
            b = Block.func_149634_a((Item)stack.func_77973_b());
            meta = stack.func_77952_i();
            if (i + xMin == 0 && k + zMin == 0 && j + yMin == 0 && this.lift.func_184586_b(null) != null) {
                b = Block.func_149634_a((Item)this.lift.func_184586_b(null).func_77973_b());
                meta = this.lift.func_184586_b(null).func_77952_i();
            }
            IBlockState iblockstate = b.func_176203_a(meta);
            return iblockstate;
        }

        public boolean func_175623_d(BlockPos pos) {
            IBlockState state = this.func_180495_p(pos);
            return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
        }

        public Biome func_180494_b(BlockPos pos) {
            return this.lift.func_130014_f_().func_180494_b(pos);
        }

        public boolean func_72806_N() {
            return false;
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return this.lift.func_130014_f_().func_175627_a(pos, direction);
        }

        public WorldType func_175624_G() {
            return this.lift.func_130014_f_().func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
        }
    }
}

