/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dynmap.jetty.http.PathMap;
import org.dynmap.jetty.server.Handler;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.handler.AbstractHandler;

public class HandlerRouter
extends AbstractHandler {
    PathMap pathMap = new PathMap();

    public void addHandler(String path, Handler handler) {
        this.pathMap.put(path, handler);
    }

    public void addServlet(String path, Servlet servlet) {
        this.pathMap.put(path, servlet);
    }

    public void clear() {
        this.pathMap.clear();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String pathInfo = request.getPathInfo();
        PathMap.Entry e = this.pathMap.getMatch(pathInfo);
        String mappedPath = e.getMapped();
        String childPathInfo = pathInfo;
        if (mappedPath != null) {
            int i;
            for (i = 0; i < mappedPath.length() && mappedPath.charAt(i) == pathInfo.charAt(i); ++i) {
            }
            childPathInfo = childPathInfo.substring(i);
        }
        Request r = (Request)request;
        r.setPathInfo(childPathInfo);
        Object o = e.getValue();
        if (o instanceof Handler) {
            Handler h = (Handler)o;
            h.handle(target, baseRequest, request, response);
        } else if (o instanceof Servlet) {
            Servlet s = (Servlet)o;
            s.service(request, response);
        }
        r.setPathInfo(pathInfo);
    }
}

