/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiPartOutputStream
extends FilterOutputStream {
    private static final byte[] __CRLF = new byte[]{13, 10};
    private static final byte[] __DASHDASH = new byte[]{45, 45};
    public static String MULTIPART_MIXED = "multipart/mixed";
    public static String MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
    private String boundary = "jetty" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
    private byte[] boundaryBytes = this.boundary.getBytes("ISO-8859-1");
    private boolean inPart = false;

    public MultiPartOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    @Override
    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
        super.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        if (contentType != null) {
            this.out.write(("Content-Type: " + contentType).getBytes("ISO-8859-1"));
        }
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        if (contentType != null) {
            this.out.write(("Content-Type: " + contentType).getBytes("ISO-8859-1"));
        }
        this.out.write(__CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i].getBytes("ISO-8859-1"));
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }
}

