/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.dynmap.jetty.server.handler.ContextHandler;
import org.dynmap.jetty.server.session.AbstractSession;
import org.dynmap.jetty.server.session.AbstractSessionManager;
import org.dynmap.jetty.server.session.JDBCSessionIdManager;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public class JDBCSessionManager
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger(JDBCSessionManager.class);
    private ConcurrentHashMap<String, AbstractSession> _sessions;
    protected JDBCSessionIdManager _jdbcSessionIdMgr = null;
    protected long _saveIntervalSec = 60L;

    public void setSaveInterval(long sec) {
        this._saveIntervalSec = sec;
    }

    public long getSaveInterval() {
        return this._saveIntervalSec;
    }

    public void cacheInvalidate(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession(String idInCluster) {
        Session session = null;
        Session memSession = (Session)this._sessions.get(idInCluster);
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            long now = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                if (memSession == null) {
                    LOG.debug("getSession(" + idInCluster + "): not in session map," + " now=" + now + " lastSaved=" + (memSession == null ? 0L : memSession._lastSaved) + " interval=" + this._saveIntervalSec * 1000L, new Object[0]);
                } else {
                    LOG.debug("getSession(" + idInCluster + "): in session map, " + " now=" + now + " lastSaved=" + (memSession == null ? 0L : memSession._lastSaved) + " interval=" + this._saveIntervalSec * 1000L + " lastNode=" + memSession._lastNode + " thisNode=" + this.getSessionIdManager().getWorkerName() + " difference=" + (now - memSession._lastSaved), new Object[0]);
                }
            }
            try {
                if (memSession == null) {
                    LOG.debug("getSession(" + idInCluster + "): no session in session map. Reloading session data from db.", new Object[0]);
                    session = this.loadSession(idInCluster, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context));
                } else if (now - memSession._lastSaved >= this._saveIntervalSec * 1000L) {
                    LOG.debug("getSession(" + idInCluster + "): stale session. Reloading session data from db.", new Object[0]);
                    session = this.loadSession(idInCluster, JDBCSessionManager.canonicalize(this._context.getContextPath()), JDBCSessionManager.getVirtualHost(this._context));
                } else {
                    LOG.debug("getSession(" + idInCluster + "): session in session map", new Object[0]);
                    session = memSession;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to load session " + idInCluster, e);
                return null;
            }
            if (session != null) {
                if (!session.getLastNode().equals(this.getSessionIdManager().getWorkerName()) || memSession == null) {
                    if (session._expiryTime <= 0L || session._expiryTime > now) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("getSession(" + idInCluster + "): lastNode=" + session.getLastNode() + " thisNode=" + this.getSessionIdManager().getWorkerName(), new Object[0]);
                        }
                        session.setLastNode(this.getSessionIdManager().getWorkerName());
                        this._sessions.put(idInCluster, session);
                        try {
                            this.updateSessionNode(session);
                            session.didActivate();
                        }
                        catch (Exception e) {
                            LOG.warn("Unable to update freshly loaded session " + idInCluster, e);
                            return null;
                        }
                    } else {
                        LOG.debug("getSession ({}): Session has expired", idInCluster);
                        session = null;
                    }
                } else {
                    session = memSession;
                    LOG.debug("getSession({}): Session not stale {}", idInCluster, session);
                }
            } else {
                LOG.debug("getSession({}): No session in database matching id={}", idInCluster, idInCluster);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSessions() {
        int size = 0;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            size = this._sessions.size();
        }
        return size;
    }

    @Override
    public void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No session id manager defined");
        }
        this._jdbcSessionIdMgr = (JDBCSessionIdManager)this._sessionIdManager;
        this._sessions = new ConcurrentHashMap();
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        this._sessions.clear();
        this._sessions = null;
        super.doStop();
    }

    @Override
    protected void invalidateSessions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateSession(String idInCluster) {
        Session session = null;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            session = (Session)this._sessions.get(idInCluster);
        }
        if (session != null) {
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeSession(String idInCluster) {
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            Session session = (Session)this._sessions.remove(idInCluster);
            try {
                if (session != null) {
                    this.deleteSession(session);
                }
            }
            catch (Exception e) {
                LOG.warn("Problem deleting session id=" + idInCluster, e);
            }
            return session != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addSession(AbstractSession session) {
        if (session == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            this._sessions.put(session.getClusterId(), session);
        }
        try {
            object = session;
            synchronized (object) {
                session.willPassivate();
                this.storeSession((Session)session);
                session.didActivate();
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to store new session id=" + session.getId(), e);
        }
    }

    @Override
    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(AbstractSession session, boolean invalidate) {
        boolean removed = false;
        JDBCSessionManager jDBCSessionManager = this;
        synchronized (jDBCSessionManager) {
            if (this.getSession(session.getClusterId()) != null) {
                removed = true;
                this.removeSession(session.getClusterId());
            }
        }
        if (removed) {
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && !this._sessionListeners.isEmpty()) {
                HttpSessionEvent event = new HttpSessionEvent(session);
                for (HttpSessionListener l : this._sessionListeners) {
                    l.sessionDestroyed(event);
                }
            }
            if (!invalidate) {
                session.willPassivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expire(List<?> sessionIds) {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        ListIterator<?> itor = sessionIds.listIterator();
        try {
            while (itor.hasNext()) {
                Session session;
                String sessionId = (String)itor.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Expiring session id " + sessionId, new Object[0]);
                }
                if ((session = (Session)this._sessions.get(sessionId)) != null) {
                    session.timeout();
                    itor.remove();
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unrecognized session id=" + sessionId, new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.warn("Problem expiring sessions", t);
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected Session loadSession(final String id, final String canonicalContextPath, final String vhost) throws Exception {
        final AtomicReference _reference = new AtomicReference();
        final AtomicReference _exception = new AtomicReference();
        Runnable load = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Session session = null;
                Connection connection = null;
                Statement statement = null;
                try {
                    connection = JDBCSessionManager.this.getConnection();
                    statement = JDBCSessionManager.this._jdbcSessionIdMgr._dbAdaptor.getLoadStatement(connection, id, canonicalContextPath, vhost);
                    ResultSet result = statement.executeQuery();
                    if (result.next()) {
                        session = new Session(id, result.getString(JDBCSessionManager.this._jdbcSessionIdMgr._sessionTableRowId), result.getLong("createTime"), result.getLong("accessTime"));
                        session.setCookieSet(result.getLong("cookieTime"));
                        session.setLastAccessedTime(result.getLong("lastAccessTime"));
                        session.setLastNode(result.getString("lastNode"));
                        session.setLastSaved(result.getLong("lastSavedTime"));
                        session.setExpiryTime(result.getLong("expiryTime"));
                        session.setCanonicalContext(result.getString("contextPath"));
                        session.setVirtualHost(result.getString("virtualHost"));
                        InputStream is = ((JDBCSessionIdManager)JDBCSessionManager.this.getSessionIdManager())._dbAdaptor.getBlobInputStream(result, "map");
                        ClassLoadingObjectInputStream ois = new ClassLoadingObjectInputStream(is);
                        Object o = ois.readObject();
                        session.addAttributes((Map)o);
                        ois.close();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("LOADED session " + session, new Object[0]);
                        }
                    }
                    _reference.set(session);
                }
                catch (Exception e) {
                    _exception.set(e);
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception e) {
                            LOG.warn(e);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            LOG.warn(e);
                        }
                    }
                }
            }
        };
        if (this._context == null) {
            load.run();
        } else {
            this._context.getContextHandler().handle(load);
        }
        if (_exception.get() != null) {
            this._jdbcSessionIdMgr.removeSession(id);
            throw (Exception)_exception.get();
        }
        return (Session)_reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeSession(Session session) throws Exception {
        if (session == null) {
            return;
        }
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            String rowId = this.calculateRowId(session);
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._insertSession);
            statement.setString(1, rowId);
            statement.setString(2, session.getId());
            statement.setString(3, session.getCanonicalContext());
            statement.setString(4, session.getVirtualHost());
            statement.setString(5, this.getSessionIdManager().getWorkerName());
            statement.setLong(6, session.getAccessed());
            statement.setLong(7, session.getLastAccessedTime());
            statement.setLong(8, session.getCreationTime());
            statement.setLong(9, session.getCookieSet());
            statement.setLong(10, now);
            statement.setLong(11, session.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(session.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(12, bais, bytes.length);
            statement.executeUpdate();
            session.setRowId(rowId);
            session.setLastSaved(now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stored session " + session, new Object[0]);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSession(Session data) throws Exception {
        if (data == null) {
            return;
        }
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSession);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessedTime());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(data.getAttributeMap());
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            statement.setBinaryStream(6, bais, bytes.length);
            statement.setString(7, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated session " + data, new Object[0]);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSessionNode(Session data) throws Exception {
        String nodeId = this.getSessionIdManager().getWorkerName();
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionNode);
            statement.setString(1, nodeId);
            statement.setString(2, data.getRowId());
            statement.executeUpdate();
            statement.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated last node for session id=" + data.getId() + ", lastNode = " + nodeId, new Object[0]);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSessionAccessTime(Session data) throws Exception {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            long now = System.currentTimeMillis();
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._updateSessionAccessTime);
            statement.setString(1, this.getSessionIdManager().getWorkerName());
            statement.setLong(2, data.getAccessed());
            statement.setLong(3, data.getLastAccessedTime());
            statement.setLong(4, now);
            statement.setLong(5, data.getExpiryTime());
            statement.setString(6, data.getRowId());
            statement.executeUpdate();
            data.setLastSaved(now);
            statement.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated access time session id=" + data.getId(), new Object[0]);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteSession(Session data) throws Exception {
        Connection connection = this.getConnection();
        Statement statement = null;
        try {
            connection.setAutoCommit(true);
            statement = connection.prepareStatement(this._jdbcSessionIdMgr._deleteSession);
            statement.setString(1, data.getRowId());
            statement.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleted Session " + data, new Object[0]);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    LOG.warn(e);
                }
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private Connection getConnection() throws SQLException {
        return ((JDBCSessionIdManager)this.getSessionIdManager()).getConnection();
    }

    private String calculateRowId(Session data) {
        String rowId = JDBCSessionManager.canonicalize(this._context.getContextPath());
        rowId = rowId + "_" + JDBCSessionManager.getVirtualHost(this._context);
        rowId = rowId + "_" + data.getId();
        return rowId;
    }

    private static String getVirtualHost(ContextHandler.Context context) {
        String vhost = "0.0.0.0";
        if (context == null) {
            return vhost;
        }
        String[] vhosts = context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    private static String canonicalize(String path) {
        if (path == null) {
            return "";
        }
        return path.replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    protected class ClassLoadingObjectInputStream
    extends ObjectInputStream {
        public ClassLoadingObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        public ClassLoadingObjectInputStream() throws IOException {
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass cl) throws IOException, ClassNotFoundException {
            try {
                return Class.forName(cl.getName(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                return super.resolveClass(cl);
            }
        }
    }

    public class Session
    extends AbstractSession {
        private static final long serialVersionUID = 5208464051134226143L;
        private boolean _dirty;
        private long _cookieSet;
        private long _expiryTime;
        private long _lastSaved;
        private String _lastNode;
        private String _virtualHost;
        private String _rowId;
        private String _canonicalContext;

        protected Session(HttpServletRequest request) {
            super(JDBCSessionManager.this, request);
            this._dirty = false;
            int maxInterval = this.getMaxInactiveInterval();
            this._expiryTime = maxInterval <= 0 ? 0L : System.currentTimeMillis() + (long)maxInterval * 1000L;
            this._virtualHost = JDBCSessionManager.getVirtualHost(JDBCSessionManager.this._context);
            this._canonicalContext = JDBCSessionManager.canonicalize(JDBCSessionManager.this._context.getContextPath());
            this._lastNode = JDBCSessionManager.this.getSessionIdManager().getWorkerName();
        }

        protected Session(String sessionId, String rowId, long created, long accessed) {
            super(JDBCSessionManager.this, created, accessed, sessionId);
            this._dirty = false;
            this._rowId = rowId;
        }

        protected synchronized String getRowId() {
            return this._rowId;
        }

        protected synchronized void setRowId(String rowId) {
            this._rowId = rowId;
        }

        public synchronized void setVirtualHost(String vhost) {
            this._virtualHost = vhost;
        }

        public synchronized String getVirtualHost() {
            return this._virtualHost;
        }

        public synchronized long getLastSaved() {
            return this._lastSaved;
        }

        public synchronized void setLastSaved(long time) {
            this._lastSaved = time;
        }

        public synchronized void setExpiryTime(long time) {
            this._expiryTime = time;
        }

        public synchronized long getExpiryTime() {
            return this._expiryTime;
        }

        public synchronized void setCanonicalContext(String str) {
            this._canonicalContext = str;
        }

        public synchronized String getCanonicalContext() {
            return this._canonicalContext;
        }

        public void setCookieSet(long ms) {
            this._cookieSet = ms;
        }

        public synchronized long getCookieSet() {
            return this._cookieSet;
        }

        public synchronized void setLastNode(String node) {
            this._lastNode = node;
        }

        public synchronized String getLastNode() {
            return this._lastNode;
        }

        @Override
        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            this._dirty = true;
        }

        @Override
        public void removeAttribute(String name) {
            super.removeAttribute(name);
            this._dirty = true;
        }

        @Override
        protected void cookieSet() {
            this._cookieSet = this.getAccessed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean access(long time) {
            Session session = this;
            synchronized (session) {
                if (super.access(time)) {
                    int maxInterval = this.getMaxInactiveInterval();
                    this._expiryTime = maxInterval <= 0 ? 0L : time + (long)maxInterval * 1000L;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void complete() {
            Session session = this;
            synchronized (session) {
                super.complete();
                try {
                    if (this.isValid()) {
                        if (this._dirty) {
                            this.willPassivate();
                            JDBCSessionManager.this.updateSession(this);
                            this.didActivate();
                        } else if (this.getAccessed() - this._lastSaved >= JDBCSessionManager.this.getSaveInterval() * 1000L) {
                            JDBCSessionManager.this.updateSessionAccessTime(this);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Problem persisting changed session data id=" + this.getId(), e);
                }
                finally {
                    this._dirty = false;
                }
            }
        }

        @Override
        protected void timeout() throws IllegalStateException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timing out session id=" + this.getClusterId(), new Object[0]);
            }
            super.timeout();
        }

        @Override
        public String toString() {
            return "Session rowId=" + this._rowId + ",id=" + this.getId() + ",lastNode=" + this._lastNode + ",created=" + this.getCreationTime() + ",accessed=" + this.getAccessed() + ",lastAccessed=" + this.getLastAccessedTime() + ",cookieSet=" + this._cookieSet + ",lastSaved=" + this._lastSaved + ",expiry=" + this._expiryTime;
        }
    }
}

