/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.dynmap.jetty.http.AbstractGenerator;
import org.dynmap.jetty.server.HttpOutput;
import org.dynmap.jetty.util.ByteArrayOutputStream2;

public class HttpWriter
extends Writer {
    public static final int MAX_OUTPUT_CHARS = 512;
    private static final int WRITE_CONV = 0;
    private static final int WRITE_ISO1 = 1;
    private static final int WRITE_UTF8 = 2;
    final HttpOutput _out;
    final AbstractGenerator _generator;
    int _writeMode;
    int _surrogate;

    public HttpWriter(HttpOutput out) {
        this._out = out;
        this._generator = this._out._generator;
        this._surrogate = 0;
    }

    public void setCharacterEncoding(String encoding) {
        if (encoding == null || "ISO-8859-1".equalsIgnoreCase(encoding)) {
            this._writeMode = 1;
        } else if ("UTF-8".equalsIgnoreCase(encoding)) {
            this._writeMode = 2;
        } else {
            this._writeMode = 0;
            if (this._out._characterEncoding == null || !this._out._characterEncoding.equalsIgnoreCase(encoding)) {
                this._out._converter = null;
            }
        }
        this._out._characterEncoding = encoding;
        if (this._out._bytes == null) {
            this._out._bytes = new ByteArrayOutputStream2(512);
        }
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public void write(String s, int offset, int length) throws IOException {
        while (length > 512) {
            this.write(s, offset, 512);
            offset += 512;
            length -= 512;
        }
        if (this._out._chars == null) {
            this._out._chars = new char[512];
        }
        char[] chars = this._out._chars;
        s.getChars(offset, offset + length, chars, 0);
        this.write(chars, 0, length);
    }

    @Override
    public void write(char[] s, int offset, int length) throws IOException {
        HttpOutput out = this._out;
        while (length > 0) {
            out._bytes.reset();
            int chars = length > 512 ? 512 : length;
            switch (this._writeMode) {
                case 0: {
                    Writer converter = this.getConverter();
                    converter.write(s, offset, chars);
                    converter.flush();
                    break;
                }
                case 1: {
                    int i;
                    byte[] buffer = out._bytes.getBuf();
                    int bytes = out._bytes.getCount();
                    if (chars > buffer.length - bytes) {
                        chars = buffer.length - bytes;
                    }
                    for (i = 0; i < chars; ++i) {
                        int c = s[offset + i];
                        buffer[bytes++] = (byte)(c < 256 ? c : 63);
                    }
                    if (bytes < 0) break;
                    out._bytes.setCount(bytes);
                    break;
                }
                case 2: {
                    int i;
                    byte[] buffer = out._bytes.getBuf();
                    int bytes = out._bytes.getCount();
                    if (bytes + chars > buffer.length) {
                        chars = buffer.length - bytes;
                    }
                    for (i = 0; i < chars; ++i) {
                        int code = s[offset + i];
                        if (this._surrogate == 0) {
                            if (Character.isHighSurrogate((char)code)) {
                                this._surrogate = code;
                                continue;
                            }
                        } else if (Character.isLowSurrogate((char)code)) {
                            code = Character.toCodePoint((char)this._surrogate, (char)code);
                        } else {
                            code = this._surrogate;
                            this._surrogate = 0;
                            --i;
                        }
                        if ((code & 0xFFFFFF80) == 0) {
                            if (bytes >= buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)code;
                            continue;
                        }
                        if ((code & 0xFFFFF800) == 0) {
                            if (bytes + 2 > buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)(0xC0 | code >> 6);
                            buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                        } else if ((code & 0xFFFF0000) == 0) {
                            if (bytes + 3 > buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)(0xE0 | code >> 12);
                            buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                        } else if ((code & 0xFF200000) == 0) {
                            if (bytes + 4 > buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)(0xF0 | code >> 18);
                            buffer[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                        } else if ((code & 0xF4000000) == 0) {
                            if (bytes + 5 > buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)(0xF8 | code >> 24);
                            buffer[bytes++] = (byte)(0x80 | code >> 18 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                        } else if ((code & Integer.MIN_VALUE) == 0) {
                            if (bytes + 6 > buffer.length) {
                                chars = i;
                                break;
                            }
                            buffer[bytes++] = (byte)(0xFC | code >> 30);
                            buffer[bytes++] = (byte)(0x80 | code >> 24 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code >> 18 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code >> 12 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code >> 6 & 0x3F);
                            buffer[bytes++] = (byte)(0x80 | code & 0x3F);
                        } else {
                            buffer[bytes++] = 63;
                        }
                        this._surrogate = 0;
                        if (bytes != buffer.length) continue;
                        chars = i + 1;
                        break;
                    }
                    out._bytes.setCount(bytes);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            out._bytes.writeTo(out);
            length -= chars;
            offset += chars;
        }
    }

    private Writer getConverter() throws IOException {
        if (this._out._converter == null) {
            this._out._converter = new OutputStreamWriter((OutputStream)this._out._bytes, this._out._characterEncoding);
        }
        return this._out._converter;
    }
}

