/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server;

import java.io.IOException;
import org.dynmap.jetty.http.Generator;
import org.dynmap.jetty.http.HttpException;
import org.dynmap.jetty.http.Parser;
import org.dynmap.jetty.io.Connection;
import org.dynmap.jetty.io.EndPoint;
import org.dynmap.jetty.server.AbstractHttpConnection;
import org.dynmap.jetty.server.Connector;
import org.dynmap.jetty.server.Request;
import org.dynmap.jetty.server.Server;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public class BlockingHttpConnection
extends AbstractHttpConnection {
    private static final Logger LOG = Log.getLogger(BlockingHttpConnection.class);

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(connector, endpoint, server);
    }

    public BlockingHttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        super(connector, endpoint, server, parser, generator, request);
    }

    @Override
    protected void handleRequest() throws IOException {
        super.handleRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection handle() throws IOException {
        Connection connection = this;
        try {
            BlockingHttpConnection.setCurrentConnection(this);
            while (this._endp.isOpen() && connection == this) {
                try {
                    if (!this._parser.isComplete() && !this._endp.isInputShutdown()) {
                        this._parser.parseAvailable();
                    }
                    if (this._generator.isCommitted() && !this._generator.isComplete() && !this._endp.isOutputShutdown()) {
                        this._generator.flushBuffer();
                    }
                    this._endp.flush();
                }
                catch (HttpException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("uri=" + this._uri, new Object[0]);
                        LOG.debug("fields=" + this._requestFields, new Object[0]);
                        LOG.debug(e);
                    }
                    this._generator.sendError(e.getStatus(), e.getReason(), null, true);
                    this._parser.reset();
                    this._endp.shutdownOutput();
                }
                finally {
                    if (this._parser.isComplete() && this._generator.isComplete()) {
                        Connection switched;
                        this.reset();
                        if (this._response.getStatus() == 101 && (switched = (Connection)this._request.getAttribute("org.dynmap.jetty.io.Connection")) != null) {
                            connection = switched;
                        }
                        if (!this._generator.isPersistent() && !this._endp.isOutputShutdown()) {
                            LOG.warn("Safety net oshut!!! Please open a bugzilla", new Object[0]);
                            this._endp.shutdownOutput();
                        }
                    }
                    if (!this._endp.isInputShutdown() || !this._generator.isIdle() || this._request.getAsyncContinuation().isSuspended()) continue;
                    this._endp.close();
                }
            }
            BlockingHttpConnection blockingHttpConnection = connection;
            return blockingHttpConnection;
        }
        finally {
            BlockingHttpConnection.setCurrentConnection(null);
            this._parser.returnBuffers();
            this._generator.returnBuffers();
        }
    }
}

