/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.Map;
import org.dynmap.Log;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class RailCraftTrackRenderer
extends CustomRenderer {
    private String[] tileEntityAttribs = new String[]{"trackId"};
    private RenderPatch[][] basepatches;
    private int maxTrackId;

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        String cnt = custparm.get("maxTrackId");
        this.maxTrackId = cnt != null ? Integer.parseInt(cnt) : 35;
        String patchid = custparm.get("patch");
        if (patchid == null) {
            Log.severe("Missing patch ID");
            return false;
        }
        this.basepatches = new RenderPatch[this.maxTrackId + 1][];
        this.basepatches[0] = new RenderPatch[]{rpf.getNamedPatch(patchid, 0)};
        if (this.basepatches[0][0] == null) {
            Log.severe("Error getting patch : " + patchid);
            return false;
        }
        for (int i = 1; i <= this.maxTrackId; ++i) {
            this.basepatches[i] = new RenderPatch[]{rpf.getRotatedPatch(this.basepatches[0][0], 0, 0, 0, i)};
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return this.maxTrackId + 1;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return this.tileEntityAttribs;
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int trackId = 0;
        Object idxv = ctx.getBlockTileEntityField("trackId");
        if (idxv instanceof Number) {
            trackId = ((Number)idxv).intValue();
        }
        if (trackId > this.maxTrackId) {
            trackId = 0;
        }
        return this.basepatches[trackId];
    }
}

