/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.chunk.NibbleArray;
import org.dynmap.Log;

public class ChunkSnapshot {
    private final int x;
    private final int z;
    private final short[][] blockids;
    private final byte[][] blockdata;
    private final byte[][] skylight;
    private final byte[][] emitlight;
    private final boolean[] empty;
    private final int[] hmap;
    private final byte[] biome;
    private final long captureFulltime;
    private final int sectionCnt;
    private final long inhabitedTicks;
    private static final int BLOCKS_PER_SECTION = 4096;
    private static final int COLUMNS_PER_CHUNK = 256;
    private static final short[] emptyIDs = new short[4096];
    private static final byte[] emptyData = new byte[2048];
    private static final byte[] fullData = new byte[2048];
    private static Method getvalarray = null;

    public ChunkSnapshot(int worldheight, int x, int z, long captime, long inhabitedTime) {
        this.x = x;
        this.z = z;
        this.captureFulltime = captime;
        this.biome = new byte[256];
        this.sectionCnt = worldheight / 16;
        this.blockids = new short[this.sectionCnt][];
        this.blockdata = new byte[this.sectionCnt][];
        this.skylight = new byte[this.sectionCnt][];
        this.emitlight = new byte[this.sectionCnt][];
        this.empty = new boolean[this.sectionCnt];
        for (int i = 0; i < this.sectionCnt; ++i) {
            this.empty[i] = true;
            this.blockids[i] = emptyIDs;
            this.blockdata[i] = emptyData;
            this.emitlight[i] = emptyData;
            this.skylight[i] = fullData;
        }
        this.hmap = new int[256];
        this.inhabitedTicks = inhabitedTime;
    }

    public ChunkSnapshot(NBTTagCompound nbt, int worldheight) {
        this.x = nbt.func_74762_e("xPos");
        this.z = nbt.func_74762_e("zPos");
        this.captureFulltime = 0L;
        this.hmap = nbt.func_74759_k("HeightMap");
        this.sectionCnt = worldheight / 16;
        this.inhabitedTicks = nbt.func_74764_b("InhabitedTime") ? nbt.func_74763_f("InhabitedTime") : 0L;
        this.blockids = new short[this.sectionCnt][];
        this.blockdata = new byte[this.sectionCnt][];
        this.skylight = new byte[this.sectionCnt][];
        this.emitlight = new byte[this.sectionCnt][];
        this.empty = new boolean[this.sectionCnt];
        for (int i = 0; i < this.sectionCnt; ++i) {
            this.empty[i] = true;
            this.blockids[i] = emptyIDs;
            this.blockdata[i] = emptyData;
            this.emitlight[i] = emptyData;
            this.skylight[i] = fullData;
        }
        NBTTagList sect = nbt.func_150295_c("Sections", 10);
        for (int i = 0; i < sect.func_74745_c(); ++i) {
            NBTTagCompound sec = sect.func_150305_b(i);
            byte secnum = sec.func_74771_c("Y");
            if (secnum >= this.sectionCnt) {
                Log.info("Section " + secnum + " above world height " + worldheight);
                continue;
            }
            byte[] lsb_bytes = sec.func_74770_j("Blocks");
            short[] blkids = new short[4096];
            this.blockids[secnum] = blkids;
            int len = 4096;
            if (len > lsb_bytes.length) {
                len = lsb_bytes.length;
            }
            for (int j = 0; j < len; ++j) {
                blkids[j] = (short)(0xFF & lsb_bytes[j]);
            }
            if (sec.func_74764_b("Add")) {
                len = 2048;
                byte[] msb = sec.func_74770_j("Add");
                if (len > msb.length) {
                    len = msb.length;
                }
                for (int j = 0; j < len; ++j) {
                    short b = (short)(msb[j] & 0xFF);
                    if (b == 0) continue;
                    int n = j << 1;
                    blkids[n] = (short)(blkids[n] | (b & 0xF) << 8);
                    int n2 = (j << 1) + 1;
                    blkids[n2] = (short)(blkids[n2] | (b & 0xF0) << 4);
                }
            }
            this.blockdata[secnum] = sec.func_74770_j("Data");
            this.emitlight[secnum] = sec.func_74770_j("BlockLight");
            if (sec.func_74764_b("SkyLight")) {
                this.skylight[secnum] = sec.func_74770_j("SkyLight");
            }
            this.empty[secnum] = false;
        }
        this.biome = nbt.func_74764_b("Biomes") ? nbt.func_74770_j("Biomes") : new byte[256];
    }

    private static byte[] getValueArray(NibbleArray na) {
        if (getvalarray != null) {
            try {
                return (byte[])getvalarray.invoke((Object)na, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return na.func_177481_a();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getBlockTypeId(int x, int y, int z) {
        return this.blockids[y >> 4][(y & 0xF) << 8 | z << 4 | x];
    }

    public int getBlockData(int x, int y, int z) {
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.blockdata[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBlockSkyLight(int x, int y, int z) {
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.skylight[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        int off = (y & 0xF) << 7 | z << 3 | x >> 1;
        return this.emitlight[y >> 4][off] >> ((x & 1) << 2) & 0xF;
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.hmap[z << 4 | x];
    }

    public int getBiome(int x, int z) {
        return 0xFF & this.biome[z << 4 | x];
    }

    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    public boolean isSectionEmpty(int sy) {
        return this.empty[sy];
    }

    public long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    static {
        for (int i = 0; i < fullData.length; ++i) {
            ChunkSnapshot.fullData[i] = -1;
        }
        try {
            Method[] m;
            for (Method mm : m = NibbleArray.class.getDeclaredMethods()) {
                if (!mm.getName().equals("getValueArray")) continue;
                getvalarray = mm;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

