/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.utils.TileFlags;

public class MapTypeState {
    public static final long DEF_INV_PERIOD = 30L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public MapType type;
    private Object invTileLock = new Object();
    private TileFlags pendingInvTiles = new TileFlags();
    private TileFlags pendingInvTilesAlt = new TileFlags();
    private TileFlags invTiles = new TileFlags();
    private TileFlags.Iterator invTilesIter = this.invTiles.getIterator();
    private long nextInvTS;
    private long invTSPeriod;
    private ArrayList<TileFlags> zoomOutInvAccum = new ArrayList();
    private ArrayList<TileFlags> zoomOutInv = new ArrayList();
    private TileFlags.Iterator zoomOutInvIter = null;
    private int zoomOutInvIterLevel = -1;
    private final int zoomOutLevels;

    public MapTypeState(DynmapWorld world, MapType mt) {
        this.type = mt;
        this.invTSPeriod = 30000000000L;
        this.nextInvTS = System.nanoTime() + this.invTSPeriod;
        this.zoomOutLevels = world.getExtraZoomOutLevels() + mt.getMapZoomOutLevels();
        for (int i = 0; i < this.zoomOutLevels; ++i) {
            this.zoomOutInv.add(null);
            this.zoomOutInvAccum.add(null);
        }
    }

    public void setInvalidatePeriod(long inv_per_in_secs) {
        this.invTSPeriod = inv_per_in_secs * 1000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateTile(int tx, int ty) {
        boolean done;
        Object object = this.invTileLock;
        synchronized (object) {
            done = !this.pendingInvTiles.setFlag(tx, ty, true);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invalidateTiles(List<TileFlags.TileCoord> coords) {
        int cnt = 0;
        Object object = this.invTileLock;
        synchronized (object) {
            for (TileFlags.TileCoord c : coords) {
                if (this.pendingInvTiles.setFlag(c.x, c.y, true)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickMapTypeState(long now_nano) {
        if (this.nextInvTS < now_nano) {
            Object object = this.invTileLock;
            synchronized (object) {
                TileFlags tmp = this.pendingInvTilesAlt;
                this.pendingInvTilesAlt = this.pendingInvTiles;
                this.pendingInvTiles = tmp;
                this.invTiles.union(tmp);
                tmp.clear();
                this.nextInvTS = now_nano + this.invTSPeriod;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNextInvalidTileCoord(TileFlags.TileCoord coord) {
        boolean match;
        Object object = this.invTileLock;
        synchronized (object) {
            match = this.invTilesIter.next(coord);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateTile(int tx, int ty) {
        Object object = this.invTileLock;
        synchronized (object) {
            this.invTiles.setFlag(tx, ty, false);
            this.pendingInvTiles.setFlag(tx, ty, false);
            this.pendingInvTilesAlt.setFlag(tx, ty, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvalidTile(int tx, int ty) {
        Object object = this.invTileLock;
        synchronized (object) {
            return this.invTiles.getFlag(tx, ty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> save() {
        Object object = this.invTileLock;
        synchronized (object) {
            this.invTiles.union(this.pendingInvTiles);
            this.invTiles.union(this.pendingInvTilesAlt);
            this.pendingInvTiles.clear();
            this.pendingInvTilesAlt.clear();
            return this.invTiles.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(List<String> saved) {
        Object object = this.invTileLock;
        synchronized (object) {
            TileFlags tf = new TileFlags();
            tf.load(saved);
            this.invTiles.union(tf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> saveZoomOut() {
        ArrayList<List<String>> rslt = new ArrayList<List<String>>();
        Object object = this.invTileLock;
        synchronized (object) {
            List<Object> val;
            boolean empty = true;
            for (TileFlags tf : this.zoomOutInv) {
                if (tf == null) {
                    val = Collections.emptyList();
                } else {
                    val = tf.save();
                    if (val == null) {
                        val = Collections.emptyList();
                    } else {
                        empty = false;
                    }
                }
                rslt.add(val);
            }
            for (TileFlags tf : this.zoomOutInvAccum) {
                if (tf == null) {
                    val = Collections.emptyList();
                } else {
                    val = tf.save();
                    if (val == null) {
                        val = Collections.emptyList();
                    } else {
                        empty = false;
                    }
                }
                rslt.add(val);
            }
            if (empty) {
                rslt = null;
            }
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreZoomOut(List<List<String>> dat) {
        Object object = this.invTileLock;
        synchronized (object) {
            TileFlags tf;
            List<String> lst;
            int i;
            int cnt = dat.size();
            int cntaccum = 0;
            if (cnt > this.zoomOutInv.size()) {
                if (cnt == 2 * this.zoomOutInv.size()) {
                    cntaccum = cnt / 2;
                }
                cnt = this.zoomOutInv.size();
            }
            for (i = 0; i < cnt; ++i) {
                lst = dat.get(i);
                tf = null;
                if (lst != null && lst.size() > 0) {
                    tf = new TileFlags();
                    tf.load(lst);
                }
                this.zoomOutInv.set(i, tf);
            }
            for (i = 0; i < cntaccum; ++i) {
                lst = dat.get(i + cnt);
                tf = null;
                if (lst != null && lst.size() > 0) {
                    tf = new TileFlags();
                    tf.load(lst);
                }
                this.zoomOutInvAccum.set(i, tf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInvCount() {
        Object object = this.invTileLock;
        synchronized (object) {
            return this.invTiles.countFlags();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.invTileLock;
        synchronized (object) {
            this.invTiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomOutInv(int x, int y, int zoomlevel) {
        if (zoomlevel >= this.zoomOutLevels) {
            return;
        }
        Object object = this.invTileLock;
        synchronized (object) {
            TileFlags tf = this.zoomOutInvAccum.get(zoomlevel);
            if (tf == null) {
                tf = new TileFlags();
                this.zoomOutInvAccum.set(zoomlevel, tf);
            }
            if (x >> zoomlevel << zoomlevel != x || y >> zoomlevel << zoomlevel != y) {
                Log.info("setZoomOutInv(" + x + "," + y + "," + zoomlevel + ")");
            }
            tf.setFlag(x >> zoomlevel, y >> zoomlevel, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearZoomOutInv(int x, int y, int zoomlevel) {
        if (zoomlevel >= this.zoomOutLevels) {
            return false;
        }
        Object object = this.invTileLock;
        synchronized (object) {
            TileFlags tf = this.zoomOutInv.get(zoomlevel);
            if (tf == null) {
                return false;
            }
            return tf.setFlag(x >> zoomlevel, y >> zoomlevel, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startZoomOutIter() {
        Object object = this.invTileLock;
        synchronized (object) {
            ArrayList<TileFlags> tmplist = this.zoomOutInv;
            this.zoomOutInv = this.zoomOutInvAccum;
            for (int i = 0; i < tmplist.size(); ++i) {
                tmplist.set(i, null);
            }
            this.zoomOutInvAccum = tmplist;
            this.zoomOutInvIter = null;
            this.zoomOutInvIterLevel = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextZoomOutInv(ZoomOutCoord coord) {
        Object object = this.invTileLock;
        synchronized (object) {
            if (this.zoomOutInvIter != null) {
                if (this.zoomOutInvIter.hasNext()) {
                    this.zoomOutInvIter.next(coord);
                    coord.zoomlevel = this.zoomOutInvIterLevel;
                    coord.x <<= this.zoomOutInvIterLevel;
                    coord.y <<= this.zoomOutInvIterLevel;
                    return true;
                }
                this.zoomOutInvIter = null;
            }
            while (this.zoomOutInvIterLevel < this.zoomOutInv.size()) {
                TileFlags tf = this.zoomOutInv.get(this.zoomOutInvIterLevel);
                if (tf != null) {
                    this.zoomOutInvIter = tf.getIterator();
                    if (this.zoomOutInvIter.hasNext()) {
                        this.zoomOutInvIter.next(coord);
                        coord.zoomlevel = this.zoomOutInvIterLevel;
                        coord.x <<= this.zoomOutInvIterLevel;
                        coord.y <<= this.zoomOutInvIterLevel;
                        return true;
                    }
                    this.zoomOutInvIter = null;
                }
                ++this.zoomOutInvIterLevel;
            }
        }
        return false;
    }

    public static class ZoomOutCoord
    extends TileFlags.TileCoord {
        public int zoomlevel;
    }
}

