/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class DimensionSyncPacket {
    private ByteBuf data = Unpooled.buffer();
    private int[] dimensions;

    public void addDimension(int id) {
        this.data.writeInt(id);
    }

    public void consumePacket(ByteBuf data) {
        int cnt = data.readableBytes() / 4;
        this.dimensions = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.dimensions[i] = data.readInt();
        }
    }

    public ByteBuf getData() {
        return this.data;
    }

    public void execute() {
        for (int id : this.dimensions) {
            Logging.log((String)("DimensionSyncPacket: Registering id: id = " + id));
            if (DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.registerDimension((int)id, (DimensionType)ModDimensions.rftoolsType);
        }
    }
}

