/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world;

import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.description.CelestialBodyDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.types.Patreons;
import mcjty.rftoolsdim.dimensions.types.SkyType;
import mcjty.rftoolsdim.dimensions.world.CloudRenderAccessHelper;
import mcjty.rftoolsdim.dimensions.world.GenericWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class SkyRenderer {
    private static final ResourceLocation locationEndSkyPng = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation locationPlasmaSkyPng = new ResourceLocation("rftoolsdim:textures/sky/plasmasky.png");
    private static final ResourceLocation locationStars1 = new ResourceLocation("rftoolsdim:textures/sky/stars1.png");
    private static final ResourceLocation locationStars1a = new ResourceLocation("rftoolsdim:textures/sky/stars1a.png");
    private static final ResourceLocation locationStars2 = new ResourceLocation("rftoolsdim:textures/sky/stars2.png");
    private static final ResourceLocation locationStars3 = new ResourceLocation("rftoolsdim:textures/sky/stars3.png");
    private static final ResourceLocation locationStars3a = new ResourceLocation("rftoolsdim:textures/sky/stars3a.png");
    private static final ResourceLocation locationMoonPhasesPng = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation locationSunPng = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation locationSickSunPng = new ResourceLocation("rftoolsdim:textures/sky/sicksun.png");
    private static final ResourceLocation locationSickMoonPng = new ResourceLocation("rftoolsdim:textures/sky/sickmoon.png");
    private static final ResourceLocation locationRabbitSunPng = new ResourceLocation("rftoolsdim:textures/sky/rabbitsun.png");
    private static final ResourceLocation locationRabbitMoonPng = new ResourceLocation("rftoolsdim:textures/sky/rabbitmoon.png");
    private static final ResourceLocation locationPlanetPng = new ResourceLocation("rftoolsdim:textures/sky/planet1.png");
    private static final ResourceLocation locationWolfMoonPng = new ResourceLocation("rftoolsdim:textures/sky/wolfred.png");
    private static final ResourceLocation locationCloudsPng = new ResourceLocation("textures/environment/clouds.png");
    private static boolean initialized = false;
    private static int starGLCallList;
    private static int glSkyList;
    private static int glSkyList2;
    private static final int SKYTYPE_DARKTOP = 0;
    private static final int SKYTYPE_ALLHORIZONTAL = 1;
    private static final int SKYTYPE_ALL = 2;
    private static final int SKYTYPE_ALTERNATING = 3;
    private static UV[] faceDown;
    private static UV[] faceUp;
    private static UV[] faceNorth;
    private static UV[] faceSouth;
    private static UV[] faceWest;
    private static UV[] faceEast;

    private static void initialize() {
        if (!initialized) {
            int k;
            int j;
            initialized = true;
            starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GL11.glNewList((int)starGLCallList, (int)4864);
            SkyRenderer.renderStars();
            GL11.glEndList();
            GlStateManager.func_179121_F();
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer renderer = tessellator.func_178180_c();
            glSkyList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glSkyList, (int)4864);
            int b2 = 64;
            int i = 256 / b2 + 2;
            float f = 16.0f;
            for (j = -b2 * i; j <= b2 * i; j += b2) {
                for (k = -b2 * i; k <= b2 * i; k += b2) {
                    renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    renderer.func_181662_b((double)(j + 0), (double)f, (double)(k + 0)).func_181675_d();
                    renderer.func_181662_b((double)(j + b2), (double)f, (double)(k + 0)).func_181675_d();
                    renderer.func_181662_b((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                    renderer.func_181662_b((double)(j + 0), (double)f, (double)(k + b2)).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
            GL11.glEndList();
            glSkyList2 = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)glSkyList2, (int)4864);
            f = -16.0f;
            renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            for (j = -b2 * i; j <= b2 * i; j += b2) {
                for (k = -b2 * i; k <= b2 * i; k += b2) {
                    renderer.func_181662_b((double)(j + b2), (double)f, (double)(k + 0)).func_181675_d();
                    renderer.func_181662_b((double)(j + 0), (double)f, (double)(k + 0)).func_181675_d();
                    renderer.func_181662_b((double)(j + 0), (double)f, (double)(k + b2)).func_181675_d();
                    renderer.func_181662_b((double)(j + b2), (double)f, (double)(k + b2)).func_181675_d();
                }
            }
            tessellator.func_78381_a();
            GL11.glEndList();
        }
    }

    public static void registerNoSky(GenericWorldProvider provider) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
    }

    public static void registerEnderSky(GenericWorldProvider provider) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                SkyRenderer.renderEnderSky();
            }
        });
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
    }

    public static void registerCloudRenderer(final GenericWorldProvider provider, final DimensionInformation information) {
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                SkyRenderer.renderClouds(provider, information, partialTicks);
            }
        });
    }

    public static void registerSkybox(GenericWorldProvider provider, final SkyType skyType) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                ResourceLocation sky;
                ResourceLocation sky2 = null;
                int type = 0;
                switch (skyType) {
                    case SKY_INFERNO: {
                        sky = locationPlasmaSkyPng;
                        type = 0;
                        break;
                    }
                    case SKY_STARS1: {
                        sky = locationStars1;
                        sky2 = locationStars1a;
                        type = 3;
                        break;
                    }
                    case SKY_STARS2: {
                        sky = locationStars2;
                        type = 2;
                        break;
                    }
                    case SKY_STARS3: {
                        sky = locationStars3;
                        sky2 = locationStars3a;
                        type = 1;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                SkyRenderer.renderSkyTexture(sky, sky2, type);
            }
        });
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
    }

    public static void registerSky(GenericWorldProvider provider, final DimensionInformation information) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                SkyRenderer.renderSky(partialTicks, information);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderSkyTexture(ResourceLocation sky, ResourceLocation sky2, int type) {
        TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.func_179094_E();
            UV[] uv = faceDown;
            boolean white = true;
            if (i == 0) {
                uv = faceDown;
                switch (type) {
                    case 2: {
                        renderEngine.func_110577_a(sky);
                        break;
                    }
                    case 1: 
                    case 3: {
                        renderEngine.func_110577_a(sky2);
                        break;
                    }
                    default: {
                        white = false;
                        break;
                    }
                }
            } else if (i == 1) {
                renderEngine.func_110577_a(sky);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                uv = faceNorth;
            } else if (i == 2) {
                renderEngine.func_110577_a(sky);
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                uv = faceSouth;
            } else if (i == 3) {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                uv = faceUp;
                switch (type) {
                    case 2: {
                        renderEngine.func_110577_a(sky);
                        break;
                    }
                    case 1: 
                    case 3: {
                        renderEngine.func_110577_a(sky2);
                        break;
                    }
                    default: {
                        white = false;
                        break;
                    }
                }
            } else if (i == 4) {
                if (type == 3 && sky2 != null) {
                    renderEngine.func_110577_a(sky2);
                } else {
                    renderEngine.func_110577_a(sky);
                }
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                uv = faceEast;
            } else if (i == 5) {
                if (type == 3 && sky2 != null) {
                    renderEngine.func_110577_a(sky2);
                } else {
                    renderEngine.func_110577_a(sky);
                }
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                uv = faceWest;
            }
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            int cc = white ? 255 : 0;
            renderer.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(uv[0].u, uv[0].v).func_181669_b(cc, cc, cc, 255).func_181675_d();
            renderer.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(uv[1].u, uv[1].v).func_181669_b(cc, cc, cc, 255).func_181675_d();
            renderer.func_181662_b(100.0, -100.0, 100.0).func_187315_a(uv[2].u, uv[2].v).func_181669_b(cc, cc, cc, 255).func_181675_d();
            renderer.func_181662_b(100.0, -100.0, -100.0).func_187315_a(uv[3].u, uv[3].v).func_181669_b(cc, cc, cc, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderEnderSky() {
        TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GlStateManager.func_179132_a((boolean)false);
        renderEngine.func_110577_a(locationEndSkyPng);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        for (int i = 0; i < 6; ++i) {
            GlStateManager.func_179094_E();
            if (i == 1) {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 2) {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 3) {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 4) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (i == 5) {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            int cc = 255;
            renderer.func_181662_b(-100.0, -100.0, -100.0).func_187315_a(0.0, 0.0).func_181669_b(cc, cc, cc, 255).func_181675_d();
            renderer.func_181662_b(-100.0, -100.0, 100.0).func_187315_a(0.0, 16.0).func_181669_b(cc, cc, cc, 255).func_181675_d();
            renderer.func_181662_b(100.0, -100.0, 100.0).func_187315_a(16.0, 16.0).func_181669_b(cc, cc, cc, 255).func_181675_d();
            renderer.func_181662_b(100.0, -100.0, -100.0).func_187315_a(16.0, 0.0).func_181669_b(cc, cc, cc, 255).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderSky(float partialTickTime, DimensionInformation information) {
        float f10;
        float f8;
        SkyRenderer.initialize();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179090_x();
        Vec3d vec3 = world.func_72833_a((Entity)player, partialTickTime);
        float skyRed = (float)vec3.field_72450_a;
        float skyGreen = (float)vec3.field_72448_b;
        float skyBlue = (float)vec3.field_72449_c;
        boolean anaglyph = Minecraft.func_71410_x().field_71474_y.field_74337_g;
        if (anaglyph) {
            float f4 = (skyRed * 30.0f + skyGreen * 59.0f + skyBlue * 11.0f) / 100.0f;
            float f5 = (skyRed * 30.0f + skyGreen * 70.0f) / 100.0f;
            float f6 = (skyRed * 30.0f + skyBlue * 70.0f) / 100.0f;
            skyRed = f4;
            skyGreen = f5;
            skyBlue = f6;
        }
        GlStateManager.func_179124_c((float)skyRed, (float)skyGreen, (float)skyBlue);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)skyRed, (float)skyGreen, (float)skyBlue);
        GlStateManager.func_179148_o((int)glSkyList);
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float[] sunsetColors = world.field_73011_w.func_76560_a(world.func_72826_c(partialTickTime), partialTickTime);
        if (sunsetColors != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTickTime)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f6 = sunsetColors[0];
            float f7 = sunsetColors[1];
            f8 = sunsetColors[2];
            if (anaglyph) {
                float f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            renderer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            renderer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, sunsetColors[3]).func_181675_d();
            for (int j = 0; j <= 16; ++j) {
                float f11 = (float)j * (float)Math.PI * 2.0f / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f11);
                float f13 = MathHelper.func_76134_b((float)f11);
                renderer.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * sunsetColors[3])).func_181666_a(sunsetColors[0], sunsetColors[1], sunsetColors[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        SkyRenderer.renderCelestialBodies(partialTickTime, information, world, renderEngine, tessellator);
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = (double)player.func_180425_c().func_177956_o() - world.func_72919_O();
        if (d0 < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            GlStateManager.func_179148_o((int)glSkyList2);
            GlStateManager.func_179121_F();
            f8 = 1.0f;
            float f9 = -((float)(d0 + 65.0));
            f10 = -f8;
            renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            renderer.func_181662_b((double)(-f8), (double)f9, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f9, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f10, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f10, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f10, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f10, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f9, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f9, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f10, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f10, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f9, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f9, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f9, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f9, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f10, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f10, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f10, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)(-f8), (double)f10, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f10, (double)f8).func_181669_b(0, 0, 0, 255).func_181675_d();
            renderer.func_181662_b((double)f8, (double)f10, (double)(-f8)).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GlStateManager.func_179124_c((float)(skyRed * 0.2f + 0.04f), (float)(skyGreen * 0.2f + 0.04f), (float)(skyBlue * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)skyRed, (float)skyGreen, (float)skyBlue);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)glSkyList2);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private static void renderCelestialBodies(float partialTickTime, DimensionInformation information, WorldClient world, TextureManager renderEngine, Tessellator tessellator) {
        List<CelestialBodyDescriptor> celestialBodies = information.getCelestialBodyDescriptors();
        GlStateManager.func_179098_w();
        GlStateManager.func_179120_a((int)770, (int)1, (int)1, (int)0);
        GlStateManager.func_179094_E();
        float f6 = 1.0f - world.func_72867_j(partialTickTime);
        ResourceLocation sun = SkyRenderer.getSun(information);
        ResourceLocation moon = SkyRenderer.getMoon(information);
        VertexBuffer renderer = tessellator.func_178180_c();
        if (celestialBodies.isEmpty()) {
            float f17;
            float f16;
            float f15;
            float f14;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(world.func_72826_c(partialTickTime) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float f10 = 30.0f;
            renderEngine.func_110577_a(sun);
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b((double)(-f10), 100.0, (double)(-f10)).func_187315_a(0.0, 0.0).func_181675_d();
            renderer.func_181662_b((double)f10, 100.0, (double)(-f10)).func_187315_a(1.0, 0.0).func_181675_d();
            renderer.func_181662_b((double)f10, 100.0, (double)f10).func_187315_a(1.0, 1.0).func_181675_d();
            renderer.func_181662_b((double)(-f10), 100.0, (double)f10).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_78381_a();
            f10 = 20.0f;
            renderEngine.func_110577_a(moon);
            if (!moon.equals((Object)locationMoonPhasesPng)) {
                f14 = 0.0f;
                f15 = 0.0f;
                f16 = 1.0f;
                f17 = 1.0f;
            } else {
                int k = world.func_72853_d();
                int l = k % 4;
                int i1 = k / 4 % 2;
                f14 = (float)(l + 0) / 4.0f;
                f15 = (float)(i1 + 0) / 2.0f;
                f16 = (float)(l + 1) / 4.0f;
                f17 = (float)(i1 + 1) / 2.0f;
            }
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            renderer.func_181662_b((double)(-f10), -100.0, (double)f10).func_187315_a((double)f16, (double)f17).func_181675_d();
            renderer.func_181662_b((double)f10, -100.0, (double)f10).func_187315_a((double)f14, (double)f17).func_181675_d();
            renderer.func_181662_b((double)f10, -100.0, (double)(-f10)).func_187315_a((double)f14, (double)f15).func_181675_d();
            renderer.func_181662_b((double)(-f10), -100.0, (double)(-f10)).func_187315_a((double)f16, (double)f15).func_181675_d();
            tessellator.func_78381_a();
        } else {
            Random random = new Random(world.func_72905_C());
            for (CelestialBodyDescriptor body : celestialBodies) {
                float offset = 0.0f;
                float factor = 1.0f;
                float yangle = -90.0f;
                if (!body.isMain()) {
                    offset = random.nextFloat() * 200.0f;
                    factor = random.nextFloat() * 3.0f;
                    yangle = random.nextFloat() * 180.0f;
                }
                switch (body.getType()) {
                    case BODY_NONE: {
                        break;
                    }
                    case BODY_SUN: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 30.0f, sun);
                        break;
                    }
                    case BODY_LARGESUN: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 80.0f, sun);
                        break;
                    }
                    case BODY_SMALLSUN: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 10.0f, sun);
                        break;
                    }
                    case BODY_REDSUN: {
                        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 30.0f, sun);
                        break;
                    }
                    case BODY_MOON: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 20.0f, moon);
                        break;
                    }
                    case BODY_LARGEMOON: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 60.0f, moon);
                        break;
                    }
                    case BODY_SMALLMOON: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 10.0f, moon);
                        break;
                    }
                    case BODY_REDMOON: {
                        GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 20.0f, moon);
                        break;
                    }
                    case BODY_PLANET: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderPlanet(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 10.0f);
                        break;
                    }
                    case BODY_LARGEPLANET: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderPlanet(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 30.0f);
                    }
                }
            }
        }
        GlStateManager.func_179090_x();
        float f18 = world.func_72880_h(partialTickTime) * f6;
        if (f18 > 0.0f) {
            GlStateManager.func_179131_c((float)f18, (float)f18, (float)f18, (float)f18);
            GlStateManager.func_179148_o((int)starGLCallList);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179127_m();
        GlStateManager.func_179121_F();
        GlStateManager.func_179090_x();
    }

    private static ResourceLocation getSun(DimensionInformation information) {
        ResourceLocation sun = information.isPatreonBitSet(Patreons.PATREON_SICKSUN) ? locationSickSunPng : (information.isPatreonBitSet(Patreons.PATREON_RABBITSUN) ? locationRabbitSunPng : locationSunPng);
        return sun;
    }

    private static ResourceLocation getMoon(DimensionInformation information) {
        ResourceLocation moon = information.isPatreonBitSet(Patreons.PATREON_SICKMOON) ? locationSickMoonPng : (information.isPatreonBitSet(Patreons.PATREON_RABBITMOON) ? locationRabbitMoonPng : (information.isPatreonBitSet(Patreons.PATREON_TOMWOLF) ? locationWolfMoonPng : locationMoonPhasesPng));
        return moon;
    }

    private static void renderMoon(float partialTickTime, WorldClient world, TextureManager renderEngine, Tessellator tessellator, float offset, float factor, float yangle, float size, ResourceLocation moon) {
        float f17;
        float f16;
        float f15;
        float f14;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = world.field_73011_w.func_76563_a(world.func_72912_H().func_76073_f(), partialTickTime);
        angle = angle * factor + offset;
        GlStateManager.func_179114_b((float)(angle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        renderEngine.func_110577_a(moon);
        if (!moon.equals((Object)locationMoonPhasesPng)) {
            f14 = 0.0f;
            f15 = 0.0f;
            f16 = 1.0f;
            f17 = 1.0f;
        } else {
            int k = world.func_72853_d();
            int l = k % 4;
            int i1 = k / 4 % 2;
            f14 = (float)(l + 0) / 4.0f;
            f15 = (float)(i1 + 0) / 2.0f;
            f16 = (float)(l + 1) / 4.0f;
            f17 = (float)(i1 + 1) / 2.0f;
        }
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(-size), -100.0, (double)size).func_187315_a((double)f16, (double)f17).func_181675_d();
        renderer.func_181662_b((double)size, -100.0, (double)size).func_187315_a((double)f14, (double)f17).func_181675_d();
        renderer.func_181662_b((double)size, -100.0, (double)(-size)).func_187315_a((double)f14, (double)f15).func_181675_d();
        renderer.func_181662_b((double)(-size), -100.0, (double)(-size)).func_187315_a((double)f16, (double)f15).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void renderSun(float partialTickTime, WorldClient world, TextureManager renderEngine, Tessellator tessellator, float offset, float factor, float yangle, float size, ResourceLocation sun) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = world.field_73011_w.func_76563_a(world.func_72912_H().func_76073_f(), partialTickTime);
        angle = angle * factor + offset;
        GlStateManager.func_179114_b((float)(angle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        renderEngine.func_110577_a(sun);
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(-size), 100.0, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)size, 100.0, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)size, 100.0, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-size), 100.0, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void renderPlanet(float partialTickTime, WorldClient world, TextureManager renderEngine, Tessellator tessellator, float offset, float factor, float yangle, float size) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = world.field_73011_w.func_76563_a(world.func_72912_H().func_76073_f(), partialTickTime);
        angle = angle * factor + offset;
        GlStateManager.func_179114_b((float)(angle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        renderEngine.func_110577_a(locationPlanetPng);
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        renderer.func_181662_b((double)(-size), 100.0, (double)(-size)).func_187315_a(0.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)size, 100.0, (double)(-size)).func_187315_a(1.0, 0.0).func_181675_d();
        renderer.func_181662_b((double)size, 100.0, (double)size).func_187315_a(1.0, 1.0).func_181675_d();
        renderer.func_181662_b((double)(-size), 100.0, (double)size).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void renderStars() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                renderer.func_181662_b(d5 + d24, d6 + d22, d7 + d25).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderClouds(GenericWorldProvider provider, DimensionInformation information, float partialTicks) {
        float f10;
        float f9;
        float f8;
        GlStateManager.func_179129_p();
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager renderEngine = mc.func_110434_K();
        float f1 = (float)(mc.func_175606_aa().field_70137_T + (mc.func_175606_aa().field_70163_u - mc.func_175606_aa().field_70137_T) * (double)partialTicks);
        Tessellator tessellator = Tessellator.func_178181_a();
        float f2 = 12.0f;
        float f3 = 4.0f;
        RenderGlobal renderGlobal = mc.field_71438_f;
        double d0 = (float)CloudRenderAccessHelper.getCloudTickCounter(renderGlobal) + partialTicks;
        double entityX = mc.func_175606_aa().field_70169_q + (mc.func_175606_aa().field_70165_t - mc.func_175606_aa().field_70169_q) * (double)partialTicks;
        double entityZ = mc.func_175606_aa().field_70166_s + (mc.func_175606_aa().field_70161_v - mc.func_175606_aa().field_70166_s) * (double)partialTicks;
        double d1 = (entityX + d0 * (double)0.03f) / (double)f2;
        double d2 = entityZ / (double)f2 + (double)0.33f;
        float y = provider.func_76571_f() - f1 + 0.33f;
        int i = MathHelper.func_76128_c((double)(d1 / 2048.0));
        int j = MathHelper.func_76128_c((double)(d2 / 2048.0));
        d1 -= (double)(i * 2048);
        d2 -= (double)(j * 2048);
        renderEngine.func_110577_a(locationCloudsPng);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Vec3d vec3 = provider.getWorld().func_72824_f(partialTicks);
        float red = (float)vec3.field_72450_a;
        float green = (float)vec3.field_72448_b;
        float blue = (float)vec3.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            f8 = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            f9 = (red * 30.0f + green * 70.0f) / 100.0f;
            f10 = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = f8;
            green = f9;
            blue = f10;
        }
        f10 = 0.00390625f;
        f8 = (float)MathHelper.func_76128_c((double)d1) * f10;
        f9 = (float)MathHelper.func_76128_c((double)d2) * f10;
        float f11 = (float)(d1 - (double)MathHelper.func_76128_c((double)d1));
        float f12 = (float)(d2 - (double)MathHelper.func_76128_c((double)d2));
        int b0 = 8;
        int b1 = 4;
        float f13 = 9.765625E-4f;
        GlStateManager.func_179152_a((float)f2, (float)1.0f, (float)f2);
        float cr = information.getSkyDescriptor().getCloudColorFactorR();
        float cg = information.getSkyDescriptor().getCloudColorFactorG();
        float cb = information.getSkyDescriptor().getCloudColorFactorB();
        boolean randomColors = information.isPatreonBitSet(Patreons.PATREON_KENNEY);
        VertexBuffer renderer = tessellator.func_178180_c();
        for (int k = 0; k < 2; ++k) {
            if (k == 0) {
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else if (mc.field_71474_y.field_74337_g) {
                if (EntityRenderer.field_78515_b == 0) {
                    GlStateManager.func_179135_a((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                } else {
                    GlStateManager.func_179135_a((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            } else {
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int l = -b1 + 1; l <= b1; ++l) {
                for (int i1 = -b1 + 1; i1 <= b1; ++i1) {
                    int j1;
                    renderer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                    float u = l * b0;
                    float v = i1 * b0;
                    float x = u - f11;
                    float z = v - f12;
                    if (randomColors) {
                        cr = x % 1.0f;
                        cg = (x + z) % 1.0f;
                        cb = z % 1.0f;
                    }
                    if (y > -f3 - 1.0f) {
                        renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)(z + (float)b0)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * 0.7f * cr, green * 0.7f * cg, blue * 0.7f * cb, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        renderer.func_181662_b((double)(x + (float)b0), (double)(y + 0.0f), (double)(z + (float)b0)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * 0.7f * cr, green * 0.7f * cg, blue * 0.7f * cb, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        renderer.func_181662_b((double)(x + (float)b0), (double)(y + 0.0f), (double)(z + 0.0f)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * 0.7f * cr, green * 0.7f * cg, blue * 0.7f * cb, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                        renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)(z + 0.0f)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * 0.7f * cr, green * 0.7f * cg, blue * 0.7f * cb, 0.8f).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    }
                    if (y <= f3 + 1.0f) {
                        renderer.func_181662_b((double)(x + 0.0f), (double)(y + f3 - f13), (double)(z + (float)b0)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * cr, green * cg, blue * cb, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        renderer.func_181662_b((double)(x + (float)b0), (double)(y + f3 - f13), (double)(z + (float)b0)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * cr, green * cg, blue * cb, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        renderer.func_181662_b((double)(x + (float)b0), (double)(y + f3 - f13), (double)(z + 0.0f)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * cr, green * cg, blue * cb, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        renderer.func_181662_b((double)(x + 0.0f), (double)(y + f3 - f13), (double)(z + 0.0f)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * cr, green * cg, blue * cb, 0.8f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    }
                    if (l > -1) {
                        for (j1 = 0; j1 < b0; ++j1) {
                            renderer.func_181662_b((double)(x + (float)j1 + 0.0f), (double)(y + 0.0f), (double)(z + (float)b0)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)j1 + 0.0f), (double)(y + f3), (double)(z + (float)b0)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)j1 + 0.0f), (double)(y + f3), (double)(z + 0.0f)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)j1 + 0.0f), (double)(y + 0.0f), (double)(z + 0.0f)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (l <= 1) {
                        for (j1 = 0; j1 < b0; ++j1) {
                            renderer.func_181662_b((double)(x + (float)j1 + 1.0f - f13), (double)(y + 0.0f), (double)(z + (float)b0)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)j1 + 1.0f - f13), (double)(y + f3), (double)(z + (float)b0)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + (float)b0) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)j1 + 1.0f - f13), (double)(y + f3), (double)(z + 0.0f)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)j1 + 1.0f - f13), (double)(y + 0.0f), (double)(z + 0.0f)).func_187315_a((double)((u + (float)j1 + 0.5f) * f10 + f8), (double)((v + 0.0f) * f10 + f9)).func_181666_a(red * 0.9f * cr, green * 0.9f * cg, blue * 0.9f * cb, 0.8f).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                        }
                    }
                    if (i1 > -1) {
                        for (j1 = 0; j1 < b0; ++j1) {
                            renderer.func_181662_b((double)(x + 0.0f), (double)(y + f3), (double)(z + (float)j1 + 0.0f)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)b0), (double)(y + f3), (double)(z + (float)j1 + 0.0f)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)b0), (double)(y + 0.0f), (double)(z + (float)j1 + 0.0f)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)(z + (float)j1 + 0.0f)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                        }
                    }
                    if (i1 <= 1) {
                        for (j1 = 0; j1 < b0; ++j1) {
                            renderer.func_181662_b((double)(x + 0.0f), (double)(y + f3), (double)(z + (float)j1 + 1.0f - f13)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)b0), (double)(y + f3), (double)(z + (float)j1 + 1.0f - f13)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + (float)b0), (double)(y + 0.0f), (double)(z + (float)j1 + 1.0f - f13)).func_187315_a((double)((u + (float)b0) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                            renderer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)(z + (float)j1 + 1.0f - f13)).func_187315_a((double)((u + 0.0f) * f10 + f8), (double)((v + (float)j1 + 0.5f) * f10 + f9)).func_181666_a(red * 0.8f * cr, green * 0.8f * cg, blue * 0.8f * cb, 0.8f).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                        }
                    }
                    tessellator.func_78381_a();
                }
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
    }

    static {
        faceDown = new UV[]{UV.uv(0.0, 1.0), UV.uv(0.0, 0.0), UV.uv(1.0, 0.0), UV.uv(1.0, 1.0)};
        faceUp = new UV[]{UV.uv(0.0, 1.0), UV.uv(0.0, 0.0), UV.uv(1.0, 0.0), UV.uv(1.0, 1.0)};
        faceNorth = new UV[]{UV.uv(0.0, 0.0), UV.uv(0.0, 1.0), UV.uv(1.0, 1.0), UV.uv(1.0, 0.0)};
        faceSouth = new UV[]{UV.uv(1.0, 1.0), UV.uv(1.0, 0.0), UV.uv(0.0, 0.0), UV.uv(0.0, 1.0)};
        faceWest = new UV[]{UV.uv(1.0, 0.0), UV.uv(0.0, 0.0), UV.uv(0.0, 1.0), UV.uv(1.0, 1.0)};
        faceEast = new UV[]{UV.uv(0.0, 1.0), UV.uv(1.0, 1.0), UV.uv(1.0, 0.0), UV.uv(0.0, 0.0)};
    }

    private static class UV {
        private final double u;
        private final double v;

        private UV(double u, double v) {
            this.u = u;
            this.v = v;
        }

        public static UV uv(double u, double v) {
            return new UV(u, v);
        }
    }
}

