/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world;

import java.util.Set;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.api.dimension.IRFToolsWorldProvider;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.DimensionStorage;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mcjty.rftoolsdim.dimensions.description.WeatherDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.types.Patreons;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import mcjty.rftoolsdim.dimensions.types.SkyType;
import mcjty.rftoolsdim.dimensions.world.GenericBiomeProvider;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.SkyRenderer;
import mcjty.rftoolsdim.network.PacketGetDimensionEnergy;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GenericWorldProvider
extends WorldProvider
implements IRFToolsWorldProvider {
    public static final String RFTOOLS_DIMENSION = "rftools_dimension";
    private DimensionInformation dimensionInformation;
    private DimensionStorage storage;
    private long seed;
    private Set<String> dimensionTypes = null;
    private static long lastFogTime = 0L;
    private static long lastTime = 0L;

    private long calculateSeed(long seed, int dim) {
        return (long)dim * 13L + seed;
    }

    public World getWorld() {
        return this.field_76579_a;
    }

    public DimensionType func_186058_p() {
        return ModDimensions.rftoolsType;
    }

    public long getSeed() {
        if (this.dimensionInformation == null || this.dimensionInformation.getWorldVersion() < 1) {
            return super.getSeed();
        }
        return this.seed;
    }

    private DimensionInformation getDimensionInformation() {
        if (this.dimensionInformation == null) {
            int dim = this.getDimension();
            this.dimensionInformation = RfToolsDimensionManager.getDimensionManager(this.field_76579_a).getDimensionInformation(dim);
            if (this.dimensionInformation == null) {
                Logging.log((String)("Dimension information for dimension " + dim + " is missing!"));
            } else {
                this.setSeed(dim);
            }
        }
        return this.dimensionInformation;
    }

    public String getSaveFolder() {
        return "RFTOOLS" + this.getDimension();
    }

    private void setSeed(int dim) {
        long forcedSeed;
        if (this.dimensionInformation == null) {
            if (this.field_76579_a == null) {
                return;
            }
            this.dimensionInformation = RfToolsDimensionManager.getDimensionManager(this.field_76579_a).getDimensionInformation(dim);
            if (this.dimensionInformation == null) {
                Logging.log((String)"Error: setSeed() called with null diminfo. Error ignored!");
                return;
            }
        }
        if ((forcedSeed = this.dimensionInformation.getForcedDimensionSeed()) != 0L) {
            Logging.log((String)("Forced seed for dimension " + dim + ": " + forcedSeed));
            this.seed = forcedSeed;
        } else {
            long baseSeed = this.dimensionInformation.getBaseSeed();
            this.seed = baseSeed != 0L ? this.calculateSeed(baseSeed, dim) : this.calculateSeed(this.field_76579_a.func_72905_C(), dim);
        }
    }

    private DimensionStorage getStorage() {
        if (this.storage == null) {
            this.storage = DimensionStorage.getDimensionStorage(this.field_76579_a);
        }
        return this.storage;
    }

    public BiomeProvider func_177499_m() {
        if (this.field_76578_c == null) {
            this.createBiomeProviderInternal();
        }
        return this.field_76578_c;
    }

    protected void func_76572_b() {
        if (this.field_76579_a instanceof WorldServer) {
            this.createBiomeProviderInternal();
            return;
        }
        this.field_76578_c = null;
    }

    private void createBiomeProviderInternal() {
        this.getDimensionInformation();
        if (this.dimensionInformation != null) {
            ControllerType type = this.dimensionInformation.getControllerType();
            if (type == ControllerType.CONTROLLER_SINGLE) {
                this.field_76578_c = new BiomeProviderSingle(this.dimensionInformation.getBiomes().get(0));
            } else if (type == ControllerType.CONTROLLER_DEFAULT) {
                WorldInfo worldInfo = this.field_76579_a.func_72912_H();
                System.out.println("worldInfo.getSeed() = " + worldInfo.func_76063_b());
                System.out.println("seed = " + this.seed);
                worldInfo = new WorldInfo(worldInfo){

                    public long func_76063_b() {
                        return GenericWorldProvider.this.seed;
                    }
                };
                this.field_76578_c = new BiomeProvider(worldInfo);
            } else {
                GenericBiomeProvider.hackyDimensionInformation = this.dimensionInformation;
                this.field_76578_c = new GenericBiomeProvider(this.seed, this.field_76579_a.func_72912_H(), this.dimensionInformation);
            }
        } else {
            this.field_76578_c = new BiomeProvider(this.field_76579_a.func_72912_H());
        }
        if (this.dimensionInformation != null) {
            boolean bl = this.field_76576_e = !this.dimensionInformation.getTerrainType().hasSky();
            if (this.field_76579_a.field_72995_K) {
                SkyType skyType = this.dimensionInformation.getSkyDescriptor().getSkyType();
                if (this.field_76576_e) {
                    SkyRenderer.registerNoSky(this);
                } else if (skyType == SkyType.SKY_ENDER) {
                    SkyRenderer.registerEnderSky(this);
                } else if (skyType == SkyType.SKY_INFERNO || skyType == SkyType.SKY_STARS1 || skyType == SkyType.SKY_STARS2 || skyType == SkyType.SKY_STARS3) {
                    SkyRenderer.registerSkybox(this, skyType);
                } else {
                    SkyRenderer.registerSky(this, this.dimensionInformation);
                }
                if (this.dimensionInformation.getSkyDescriptor().isCloudColorGiven() || this.dimensionInformation.isPatreonBitSet(Patreons.PATREON_KENNEY)) {
                    SkyRenderer.registerCloudRenderer(this, this.dimensionInformation);
                }
            }
        }
    }

    public double getHorizon() {
        this.getDimensionInformation();
        if (this.dimensionInformation != null && this.dimensionInformation.getTerrainType().hasNoHorizon()) {
            return 0.0;
        }
        return super.getHorizon();
    }

    public boolean func_76569_d() {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.func_76569_d();
        }
        return this.dimensionInformation.getTerrainType().hasSky();
    }

    public String getWelcomeMessage() {
        return "Entering the rftools dimension!";
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        this.getDimensionInformation();
        if (GeneralConfiguration.respawnSameDim || this.dimensionInformation != null && this.dimensionInformation.isRespawnHere()) {
            DimensionStorage dimensionStorage = this.getStorage();
            int power = dimensionStorage.getEnergyLevel(this.getDimension());
            if (power < 1000) {
                return GeneralConfiguration.spawnDimension;
            }
            return this.getDimension();
        }
        return GeneralConfiguration.spawnDimension;
    }

    public IChunkGenerator func_186060_c() {
        int dim = this.getDimension();
        this.setSeed(dim);
        return new GenericChunkGenerator(this.field_76579_a, this.seed);
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        return super.getBiomeForCoords(pos);
    }

    public int getActualHeight() {
        return 256;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float angle, float dt) {
        float r;
        float g;
        float b;
        int dim = this.getDimension();
        if (System.currentTimeMillis() - lastFogTime > 1000L) {
            lastFogTime = System.currentTimeMillis();
            RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(dim));
        }
        float factor = this.calculatePowerBlackout(dim);
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            r = this.dimensionInformation.getSkyDescriptor().getFogColorFactorR() * factor;
            g = this.dimensionInformation.getSkyDescriptor().getFogColorFactorG() * factor;
            b = this.dimensionInformation.getSkyDescriptor().getFogColorFactorB() * factor;
        }
        Vec3d color = super.func_76562_b(angle, dt);
        return new Vec3d(color.field_72450_a * (double)r, color.field_72448_b * (double)g, color.field_72449_c * (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        float r;
        float g;
        float b;
        int dim = this.getDimension();
        if (System.currentTimeMillis() - lastTime > 1000L) {
            lastTime = System.currentTimeMillis();
            RFToolsDimMessages.INSTANCE.sendToServer((IMessage)new PacketGetDimensionEnergy(dim));
        }
        float factor = this.calculatePowerBlackout(dim);
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        } else {
            r = this.dimensionInformation.getSkyDescriptor().getSkyColorFactorR() * factor;
            g = this.dimensionInformation.getSkyDescriptor().getSkyColorFactorG() * factor;
            b = this.dimensionInformation.getSkyDescriptor().getSkyColorFactorB() * factor;
        }
        Vec3d skyColor = super.getSkyColor(cameraEntity, partialTicks);
        return new Vec3d(skyColor.field_72450_a * (double)r, skyColor.field_72448_b * (double)g, skyColor.field_72449_c * (double)b);
    }

    private float calculatePowerBlackout(int dim) {
        float factor = 1.0f;
        int power = this.getStorage().getEnergyLevel(dim);
        if (power < PowerConfiguration.DIMPOWER_WARN3) {
            factor = (float)power / (float)PowerConfiguration.DIMPOWER_WARN3 * 0.2f;
        } else if (power < PowerConfiguration.DIMPOWER_WARN2) {
            factor = (float)(power - PowerConfiguration.DIMPOWER_WARN3) / (float)(PowerConfiguration.DIMPOWER_WARN2 - PowerConfiguration.DIMPOWER_WARN3) * 0.3f + 0.2f;
        } else if (power < PowerConfiguration.DIMPOWER_WARN1) {
            factor = (float)(power - PowerConfiguration.DIMPOWER_WARN2) / (float)(PowerConfiguration.DIMPOWER_WARN1 - PowerConfiguration.DIMPOWER_WARN2) * 0.3f + 0.5f;
        } else if (power < PowerConfiguration.DIMPOWER_WARN0) {
            factor = (float)(power - PowerConfiguration.DIMPOWER_WARN1) / (float)(PowerConfiguration.DIMPOWER_WARN0 - PowerConfiguration.DIMPOWER_WARN1) * 0.2f + 0.8f;
        }
        return factor;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.getSunBrightness(par1);
        }
        int dim = this.getDimension();
        float factor = this.calculatePowerBlackout(dim);
        return super.getSunBrightness(par1) * this.dimensionInformation.getSkyDescriptor().getSunBrightnessFactor() * factor;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.getStarBrightness(par1);
        }
        return super.getStarBrightness(par1) * this.dimensionInformation.getSkyDescriptor().getStarBrightnessFactor();
    }

    public void updateWeather() {
        super.updateWeather();
        if (!this.field_76579_a.field_72995_K) {
            this.getDimensionInformation();
            if (this.dimensionInformation != null) {
                float ts;
                WeatherDescriptor descriptor = this.dimensionInformation.getWeatherDescriptor();
                float rs = descriptor.getRainStrength();
                if (rs > -0.5f) {
                    this.field_76579_a.field_73004_o = rs;
                    if ((double)Math.abs(this.field_76579_a.field_73004_o) < 0.001) {
                        this.field_76579_a.field_73003_n = 0.0f;
                        this.field_76579_a.field_73004_o = 0.0f;
                        this.field_76579_a.func_72912_H().func_76084_b(false);
                    }
                }
                if ((ts = descriptor.getThunderStrength()) > -0.5f) {
                    this.field_76579_a.field_73017_q = ts;
                    if ((double)Math.abs(this.field_76579_a.field_73017_q) < 0.001) {
                        this.field_76579_a.field_73018_p = 0.0f;
                        this.field_76579_a.field_73017_q = 0.0f;
                        this.field_76579_a.func_72912_H().func_76069_a(false);
                    }
                }
            }
        }
    }

    public float func_76563_a(long time, float dt) {
        this.getDimensionInformation();
        if (this.dimensionInformation == null) {
            return super.func_76563_a(time, dt);
        }
        if (!this.dimensionInformation.getTerrainType().hasSky()) {
            return 0.5f;
        }
        if (this.dimensionInformation.getCelestialAngle() == null) {
            if (this.dimensionInformation.getTimeSpeed() == null) {
                return super.func_76563_a(time, dt);
            }
            return super.func_76563_a((long)((float)time * this.dimensionInformation.getTimeSpeed().floatValue()), dt);
        }
        return this.dimensionInformation.getCelestialAngle().floatValue();
    }

    @Override
    public int getCurrentRF() {
        return this.getStorage().getEnergyLevel(this.getDimension());
    }
}

