/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets.types;

import java.util.List;
import java.util.Random;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.description.MobDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.DimletObjectMapping;
import mcjty.rftoolsdim.dimensions.dimlets.DimletRandomizer;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletCraftingTools;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.dimlets.types.IDimletType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class MobDimletType
implements IDimletType {
    @Override
    public String getName() {
        return "Mob";
    }

    @Override
    public String getOpcode() {
        return "M";
    }

    @Override
    public String getTextureName() {
        return "mobsDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return false;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return true;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
        MobDescriptor mobDescriptor = DimletObjectMapping.getMob(key);
        if (mobDescriptor != null && mobDescriptor.getEntityClass() != null) {
            dimensionInformation.getExtraMobs().add(mobDescriptor);
        } else {
            dimensionInformation.getExtraMobs().clear();
        }
    }

    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        block3: {
            List<MobDescriptor> extraMobs;
            block2: {
                extraMobs = dimensionInformation.getExtraMobs();
                if (!(dimlets = DimensionInformation.extractType(DimletType.DIMLET_MOB, dimlets)).isEmpty()) break block2;
                while (random.nextFloat() < WorldgenConfiguration.randomExtraMobsChance) {
                    DimletKey key = DimletRandomizer.getRandomMob(random);
                    if (key == null) continue;
                    dimensionInformation.updateCostFactor(key);
                    extraMobs.add(DimletObjectMapping.getMob(key));
                }
                break block3;
            }
            DimletKey key = (DimletKey)dimlets.get(0).getLeft();
            MobDescriptor mobDescriptor = DimletObjectMapping.getMob(key);
            if (dimlets.size() == 1 && (mobDescriptor == null || mobDescriptor.getEntityClass() == null)) break block3;
            for (Pair<DimletKey, List<DimletKey>> dimletWithModifiers : dimlets) {
                DimletKey modifierKey = (DimletKey)dimletWithModifiers.getLeft();
                MobDescriptor descriptor = DimletObjectMapping.getMob(modifierKey);
                if (descriptor == null || descriptor.getEntityClass() == null) continue;
                extraMobs.add(descriptor);
            }
        }
    }

    @Override
    public String[] getInformation() {
        return new String[]{"Control what type of mobs can spawn", "in addition to normal mob spawning."};
    }

    private static boolean isValidMobEssence(ItemStack stackEssence, NBTTagCompound essenceCompound) {
        return true;
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        if (!MobDimletType.isValidMobEssence(stackEssence, stackEssence.func_77978_p())) {
            return null;
        }
        String mob = stackEssence.func_77978_p().func_74779_i("mobName");
        if (!DimletCraftingTools.matchDimletRecipe(new DimletKey(DimletType.DIMLET_MOB, mob), stackController, stackMemory, stackEnergy)) {
            return null;
        }
        DimletKey mobDimlet = new DimletKey(DimletType.DIMLET_MOB, mob);
        return mobDimlet;
    }
}

