/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mcjty.lib.varia.WeightedRandomSelector;
import mcjty.rftoolsdim.config.DimletConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;

public class DimletRandomizer {
    public static final int RARITY_0 = 0;
    public static final int RARITY_1 = 1;
    public static final int RARITY_2 = 2;
    public static final int RARITY_3 = 3;
    public static final int RARITY_4 = 4;
    public static final int RARITY_5 = 5;
    public static final int RARITY_6 = 6;
    private static WeightedRandomSelector<Integer, DimletKey> randomDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomMaterialDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomLiquidDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomMobDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomStructureDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomEffectDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomFeatureDimlets;
    private static WeightedRandomSelector<Integer, DimletKey> randomTerrainDimlets;
    private static WeightedRandomSelector<Integer, ItemStack> dimletPartDistribution;

    public static void init() {
        randomDimlets = null;
        randomMaterialDimlets = null;
        randomLiquidDimlets = null;
        randomMobDimlets = null;
        randomStructureDimlets = null;
        randomEffectDimlets = null;
        randomFeatureDimlets = null;
        randomTerrainDimlets = null;
    }

    private static void setupWeightedRandomList() {
        if (randomDimlets != null) {
            return;
        }
        Map<DimletKey, Settings> knownDimlets = KnownDimletConfiguration.getKnownDimlets();
        float rarity0 = DimletConfiguration.rarity0;
        float rarity1 = DimletConfiguration.rarity1;
        float rarity2 = DimletConfiguration.rarity2;
        float rarity3 = DimletConfiguration.rarity3;
        float rarity4 = DimletConfiguration.rarity4;
        float rarity5 = DimletConfiguration.rarity5;
        float rarity6 = DimletConfiguration.rarity6;
        randomDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomMaterialDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomMaterialDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomLiquidDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomLiquidDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomMobDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomMobDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomStructureDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomStructureDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomEffectDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomEffectDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomFeatureDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomFeatureDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        randomTerrainDimlets = new WeightedRandomSelector();
        DimletRandomizer.setupRarity(randomTerrainDimlets, rarity0, rarity1, rarity2, rarity3, rarity4, rarity5, rarity6);
        for (Map.Entry<DimletKey, Settings> entry : knownDimlets.entrySet()) {
            DimletKey key = entry.getKey();
            Settings settings = KnownDimletConfiguration.getSettings(key);
            if (settings == null || !settings.isWorldgen()) continue;
            randomDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
            if (key.getType() == DimletType.DIMLET_MATERIAL) {
                randomMaterialDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_LIQUID) {
                randomLiquidDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_MOB) {
                randomMobDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_EFFECT) {
                randomEffectDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_FEATURE) {
                randomFeatureDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
                continue;
            }
            if (key.getType() == DimletType.DIMLET_STRUCTURE) {
                randomStructureDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
                continue;
            }
            if (key.getType() != DimletType.DIMLET_TERRAIN) continue;
            randomTerrainDimlets.addItem((Object)entry.getValue().getRarity(), (Object)key);
        }
    }

    private static void setupRarity(WeightedRandomSelector<Integer, DimletKey> randomDimlets, float rarity0, float rarity1, float rarity2, float rarity3, float rarity4, float rarity5, float rarity6) {
        randomDimlets.addRarity((Object)0, rarity0);
        randomDimlets.addRarity((Object)1, rarity1);
        randomDimlets.addRarity((Object)2, rarity2);
        randomDimlets.addRarity((Object)3, rarity3);
        randomDimlets.addRarity((Object)4, rarity4);
        randomDimlets.addRarity((Object)5, rarity5);
        randomDimlets.addRarity((Object)6, rarity6);
    }

    public static DimletKey getRandomTerrain(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomTerrainDimlets.select(random);
    }

    public static DimletKey getRandomFeature(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomFeatureDimlets.select(random);
    }

    public static DimletKey getRandomEffect(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomEffectDimlets.select(random);
    }

    public static DimletKey getRandomStructure(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomStructureDimlets.select(random);
    }

    public static DimletKey getRandomFluidBlock(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomLiquidDimlets.select(random);
    }

    public static DimletKey getRandomMaterialBlock(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomMaterialDimlets.select(random);
    }

    public static DimletKey getRandomController(Random random) {
        ControllerType type = ControllerType.values()[random.nextInt(ControllerType.values().length)];
        return new DimletKey(DimletType.DIMLET_CONTROLLER, type.getId());
    }

    public static DimletKey getRandomBiome(Random random) {
        Biome biome;
        ArrayList keys = new ArrayList(Biome.field_185377_q.func_148742_b());
        int size = keys.size();
        while ((biome = (Biome)Biome.field_185377_q.func_82594_a(keys.get(random.nextInt(size)))) == null) {
        }
        return new DimletKey(DimletType.DIMLET_BIOME, biome.func_185359_l());
    }

    public static DimletKey getRandomMob(Random random) {
        DimletRandomizer.setupWeightedRandomList();
        return (DimletKey)randomMobDimlets.select(random);
    }

    public static WeightedRandomSelector<Integer, DimletKey> getRandomDimlets() {
        DimletRandomizer.setupWeightedRandomList();
        return randomDimlets;
    }

    public static ItemStack getRandomPart(Random random) {
        if (dimletPartDistribution == null) {
            dimletPartDistribution = new WeightedRandomSelector();
            dimletPartDistribution.addRarity((Object)0, DimletConfiguration.rarity0);
            dimletPartDistribution.addRarity((Object)1, DimletConfiguration.rarity1);
            dimletPartDistribution.addRarity((Object)2, DimletConfiguration.rarity2);
            dimletPartDistribution.addRarity((Object)3, DimletConfiguration.rarity3);
            dimletPartDistribution.addRarity((Object)4, DimletConfiguration.rarity4);
            dimletPartDistribution.addRarity((Object)5, DimletConfiguration.rarity5);
            dimletPartDistribution.addRarity((Object)6, DimletConfiguration.rarity6);
            List<List<ItemStack>> stacks = KnownDimletConfiguration.getRandomPartLists();
            for (int i = 0; i < stacks.size(); ++i) {
                int finalI = i;
                stacks.get(i).stream().forEach(s -> dimletPartDistribution.addItem((Object)finalI, s));
            }
        }
        return (ItemStack)dimletPartDistribution.select(random);
    }
}

