/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.dimlets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsdim.config.MobConfiguration;
import mcjty.rftoolsdim.dimensions.description.MobDescriptor;
import mcjty.rftoolsdim.dimensions.description.SkyDescriptor;
import mcjty.rftoolsdim.dimensions.description.WeatherDescriptor;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.dimensions.types.ControllerType;
import mcjty.rftoolsdim.dimensions.types.EffectType;
import mcjty.rftoolsdim.dimensions.types.FeatureType;
import mcjty.rftoolsdim.dimensions.types.SpecialType;
import mcjty.rftoolsdim.dimensions.types.StructureType;
import mcjty.rftoolsdim.dimensions.types.TerrainType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.StringUtils;

public class DimletObjectMapping {
    public static final String NONE_ID = "None";
    public static String DEFAULT_ID = "Default";
    private static Map<DimletKey, Float> dimletToCelestialAngle;
    private static Map<DimletKey, Float> dimletToSpeed;

    public static FeatureType getFeature(DimletKey dimlet) {
        if (DimletType.DIMLET_FEATURE.equals((Object)dimlet.getType())) {
            FeatureType type = FeatureType.getFeatureById(dimlet.getId());
            return type == null ? FeatureType.FEATURE_NONE : type;
        }
        return FeatureType.FEATURE_NONE;
    }

    public static ControllerType getController(DimletKey dimlet) {
        if (DimletType.DIMLET_CONTROLLER.equals((Object)dimlet.getType())) {
            ControllerType type = ControllerType.getControllerById(dimlet.getId());
            return type == null ? ControllerType.CONTROLLER_DEFAULT : type;
        }
        return ControllerType.CONTROLLER_DEFAULT;
    }

    public static EffectType getEffect(DimletKey dimlet) {
        if (DimletType.DIMLET_EFFECT.equals((Object)dimlet.getType())) {
            EffectType type = EffectType.getEffectById(dimlet.getId());
            return type == null ? EffectType.EFFECT_NONE : type;
        }
        return EffectType.EFFECT_NONE;
    }

    public static StructureType getStructure(DimletKey dimlet) {
        if (DimletType.DIMLET_STRUCTURE.equals((Object)dimlet.getType())) {
            StructureType type = StructureType.getStructureById(dimlet.getId());
            return type == null ? StructureType.STRUCTURE_NONE : type;
        }
        return StructureType.STRUCTURE_NONE;
    }

    public static TerrainType getTerrain(DimletKey dimlet) {
        if (DimletType.DIMLET_TERRAIN.equals((Object)dimlet.getType())) {
            TerrainType type = TerrainType.getTerrainById(dimlet.getId());
            return type == null ? TerrainType.TERRAIN_VOID : type;
        }
        return TerrainType.TERRAIN_VOID;
    }

    public static IBlockState getBlock(DimletKey dimlet) {
        if (DimletType.DIMLET_MATERIAL.equals((Object)dimlet.getType())) {
            int meta;
            String blockid;
            String id = dimlet.getId();
            if (DEFAULT_ID.equals(id)) {
                return Blocks.field_150348_b.func_176223_P();
            }
            int lastIndexOf = StringUtils.lastIndexOf((CharSequence)id, (CharSequence)"@");
            if (lastIndexOf == -1) {
                blockid = id;
                meta = 0;
            } else {
                blockid = id.substring(0, lastIndexOf);
                meta = Integer.parseInt(id.substring(lastIndexOf + 1));
            }
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockid));
            if (block == null) {
                return null;
            }
            return block.func_176203_a(meta);
        }
        return null;
    }

    public static Block getFluid(DimletKey dimlet) {
        if (DimletType.DIMLET_LIQUID.equals((Object)dimlet.getType())) {
            String id = dimlet.getId();
            if (DEFAULT_ID.equals(id)) {
                return Blocks.field_150355_j;
            }
            int lastIndexOf = StringUtils.lastIndexOf((CharSequence)id, (CharSequence)"@");
            String blockid = lastIndexOf == -1 ? id : id.substring(0, lastIndexOf);
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(blockid));
            if (block == null) {
                return null;
            }
            return block;
        }
        return null;
    }

    public static Biome getBiome(DimletKey dimlet) {
        if (DimletType.DIMLET_BIOME.equals((Object)dimlet.getType())) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(dimlet.getId()));
            return biome;
        }
        return null;
    }

    public static String getDigit(DimletKey dimlet) {
        if (DimletType.DIMLET_DIGIT.equals((Object)dimlet.getType())) {
            return dimlet.getId();
        }
        return "";
    }

    public static MobDescriptor getMob(DimletKey dimlet) {
        if (DimletType.DIMLET_MOB.equals((Object)dimlet.getType())) {
            MobDescriptor descriptor = MobConfiguration.mobClasses.get(dimlet.getId());
            if (descriptor == null) {
                return MobConfiguration.defaultDescriptor;
            }
            return descriptor;
        }
        return null;
    }

    public static SkyDescriptor getSky(DimletKey dimlet) {
        if (DimletType.DIMLET_SKY.equals((Object)dimlet.getType())) {
            // empty if block
        }
        return new SkyDescriptor.Builder().build();
    }

    public static WeatherDescriptor getWeather(DimletKey dimlet) {
        if (DimletType.DIMLET_WEATHER.equals((Object)dimlet.getType())) {
            // empty if block
        }
        return new WeatherDescriptor.Builder().build();
    }

    public static SpecialType getSpecial(DimletKey dimlet) {
        if (DimletType.DIMLET_SPECIAL.equals((Object)dimlet.getType())) {
            SpecialType type = SpecialType.getSpecialById(dimlet.getId());
            return type;
        }
        return null;
    }

    private static void setupTimeTables() {
        if (dimletToCelestialAngle == null) {
            dimletToCelestialAngle = new HashMap<DimletKey, Float>();
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Normal"), null);
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Noon"), Float.valueOf(0.0f));
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Midnight"), Float.valueOf(0.5f));
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Morning"), Float.valueOf(0.75f));
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Evening"), Float.valueOf(0.2f));
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Fast"), null);
            dimletToCelestialAngle.put(new DimletKey(DimletType.DIMLET_TIME, "Slow"), null);
        }
        if (dimletToSpeed == null) {
            dimletToSpeed = new HashMap<DimletKey, Float>();
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Normal"), null);
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Noon"), null);
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Midnight"), null);
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Morning"), null);
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Evening"), null);
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Fast"), Float.valueOf(2.0f));
            dimletToSpeed.put(new DimletKey(DimletType.DIMLET_TIME, "Slow"), Float.valueOf(0.5f));
        }
    }

    public static Collection<DimletKey> getTimeDimlets() {
        DimletObjectMapping.setupTimeTables();
        ArrayList<DimletKey> dimlets = new ArrayList<DimletKey>();
        for (DimletKey dimletKey : dimletToCelestialAngle.keySet()) {
            dimlets.add(dimletKey);
        }
        return dimlets;
    }

    public static Collection<DimletKey> getCelestialAngles() {
        DimletObjectMapping.setupTimeTables();
        ArrayList<DimletKey> dimlets = new ArrayList<DimletKey>();
        for (DimletKey dimletKey : dimletToCelestialAngle.keySet()) {
            if (dimletToCelestialAngle.get(dimletKey) == null) continue;
            dimlets.add(dimletKey);
        }
        return dimlets;
    }

    public static Float getCelestialAngle(DimletKey dimlet) {
        DimletObjectMapping.setupTimeTables();
        return dimletToCelestialAngle.get(dimlet);
    }

    public static Float getTimeSpeed(DimletKey dimlet) {
        DimletObjectMapping.setupTimeTables();
        return dimletToSpeed.get(dimlet);
    }
}

