/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsdim.config.DimletRules;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.dimensions.description.DimensionDescriptor;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.items.PhasedFieldGeneratorItem;
import mcjty.rftoolsdim.network.PacketRegisterDimensions;
import mcjty.rftoolsdim.network.PacketSyncDimensionInfo;
import mcjty.rftoolsdim.network.PacketSyncRules;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RfToolsDimensionManager
extends WorldSavedData {
    public static final String DIMMANAGER_NAME = "RFToolsDimensionManager";
    private static RfToolsDimensionManager instance = null;
    private final Map<Integer, DimensionDescriptor> dimensions = new HashMap<Integer, DimensionDescriptor>();
    private final Map<DimensionDescriptor, Integer> dimensionToID = new HashMap<DimensionDescriptor, Integer>();
    private final Map<Integer, DimensionInformation> dimensionInformation = new HashMap<Integer, DimensionInformation>();
    private final Set<Integer> reclaimedIds = new HashSet<Integer>();

    public void syncFromServer(Map<Integer, DimensionDescriptor> dims, Map<Integer, DimensionInformation> dimInfo) {
        int id;
        Logging.log((String)"RfToolsDimensionManager.syncFromServer");
        if (dims.isEmpty() || dimInfo.isEmpty()) {
            Logging.log((String)"Dimension information from server is empty.");
        }
        for (Map.Entry<Integer, DimensionDescriptor> entry : dims.entrySet()) {
            id = entry.getKey();
            DimensionDescriptor descriptor = entry.getValue();
            if (this.dimensions.containsKey(id)) {
                this.dimensionToID.remove(this.dimensions.get(id));
            }
            this.dimensions.put(id, descriptor);
            this.dimensionToID.put(descriptor, id);
        }
        for (Map.Entry<Integer, Object> entry : dimInfo.entrySet()) {
            id = entry.getKey();
            DimensionInformation info = (DimensionInformation)entry.getValue();
            this.dimensionInformation.put(id, info);
        }
    }

    public RfToolsDimensionManager(String identifier) {
        super(identifier);
    }

    public static void clearInstance() {
        if (instance != null) {
            RfToolsDimensionManager.instance.dimensions.clear();
            RfToolsDimensionManager.instance.dimensionToID.clear();
            RfToolsDimensionManager.instance.dimensionInformation.clear();
            RfToolsDimensionManager.instance.reclaimedIds.clear();
            instance = null;
        }
    }

    public static void cleanupDimensionInformation() {
        if (instance != null) {
            Logging.log((String)"Cleaning up RFTools dimensions");
            RfToolsDimensionManager.unregisterDimensions();
            instance.getDimensions().clear();
            RfToolsDimensionManager.instance.dimensionToID.clear();
            RfToolsDimensionManager.instance.dimensionInformation.clear();
            RfToolsDimensionManager.instance.reclaimedIds.clear();
            instance = null;
        }
    }

    public static void unregisterDimensions() {
        for (Map.Entry<Integer, DimensionDescriptor> me : instance.getDimensions().entrySet()) {
            int id = me.getKey();
            if (DimensionManager.isDimensionRegistered((int)id)) {
                Logging.log((String)("    Unregister dimension: " + id));
                try {
                    DimensionManager.unregisterDimension((int)id);
                }
                catch (Exception e) {
                    Logging.log((String)("        Could not unregister dimension: " + id));
                }
                continue;
            }
            Logging.log((String)("    Already unregistered! Dimension: " + id));
        }
    }

    public void save(World world) {
        world.func_175693_T().func_75745_a(DIMMANAGER_NAME, (WorldSavedData)this);
        this.func_76185_a();
        this.syncDimInfoToClients(world);
    }

    public void reclaimId(int id) {
        this.reclaimedIds.add(id);
    }

    public static void freezeDimension(World world) {
        ArrayList<BlockPos> pfgList = new ArrayList<BlockPos>();
        int radius = PowerConfiguration.phasedFieldGeneratorRange;
        if (radius > 0) {
            for (Object ent : world.field_73010_i) {
                RfToolsDimensionManager dimensionManager;
                DimensionInformation information;
                EntityPlayer player = (EntityPlayer)ent;
                int cost = 0;
                if (PowerConfiguration.dimensionDifficulty != -1 && (cost = (information = (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(world.field_73011_w.getDimension())).getActualRfCost()) == 0) {
                    DimensionDescriptor descriptor = dimensionManager.getDimensionDescriptor(world.field_73011_w.getDimension());
                    cost = descriptor.getRfMaintainCost();
                }
                if (!RfToolsDimensionManager.checkValidPhasedFieldGenerator(player, false, cost)) continue;
                pfgList.add(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v));
            }
        }
        ArrayList tokeep = new ArrayList();
        tokeep.addAll(world.field_73010_i);
        for (BlockPos coordinate : pfgList) {
            RfToolsDimensionManager.getEntitiesInSphere(world, coordinate, (float)radius, tokeep);
        }
        world.field_72996_f.clear();
        world.field_72996_f.addAll(tokeep);
        world.field_147482_g.clear();
    }

    private static void getEntitiesInSphere(World world, BlockPos c, float radius, List tokeep) {
        int i = MathHelper.func_76128_c((double)((double)((float)c.func_177958_n() - radius) / 16.0));
        int j = MathHelper.func_76128_c((double)((double)((float)(c.func_177958_n() + 1) + radius) / 16.0));
        int k = MathHelper.func_76128_c((double)((double)((float)c.func_177952_p() - radius) / 16.0));
        int l = MathHelper.func_76128_c((double)((double)((float)(c.func_177952_p() + 1) + radius) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (world.func_72863_F().func_186026_b(i1, j1) == null) continue;
                Chunk chunk = world.func_72964_e(i1, j1);
                RfToolsDimensionManager.getEntitiesInSphere(chunk, c, radius, tokeep);
            }
        }
    }

    private static void getEntitiesInSphere(Chunk chunk, BlockPos c, float radius, List entities) {
        float squaredRange = radius * radius;
        int i = MathHelper.func_76128_c((double)((double)((float)c.func_177956_o() - radius) / 16.0));
        int j = MathHelper.func_76128_c((double)((double)((float)(c.func_177956_o() + 1) + radius) / 16.0));
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(chunk.func_177429_s().length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(chunk.func_177429_s().length - 1));
        block0: for (int k = i; k <= j; ++k) {
            ClassInheritanceMultiMap entityList = chunk.func_177429_s()[k];
            for (Entity entity : entityList) {
                float sqdist;
                if (entity instanceof EntityPlayer || !((sqdist = RfToolsDimensionManager.squaredDistance(c, new BlockPos((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v))) < squaredRange)) continue;
                entities.add(entity);
                continue block0;
            }
        }
    }

    public static float squaredDistance(BlockPos p1, BlockPos c) {
        return (c.func_177958_n() - p1.func_177958_n()) * (c.func_177958_n() - p1.func_177958_n()) + (c.func_177956_o() - p1.func_177956_o()) * (c.func_177956_o() - p1.func_177956_o()) + (c.func_177952_p() - p1.func_177952_p()) * (c.func_177952_p() - p1.func_177952_p());
    }

    public static void unfreezeDimension(World world) {
        WorldServer worldServer = (WorldServer)world;
        for (Chunk chunk : worldServer.func_72863_F().func_189548_a()) {
            RfToolsDimensionManager.unfreezeChunk(chunk);
        }
    }

    public static void unfreezeChunk(Chunk chunk) {
        chunk.field_76636_d = true;
        chunk.func_177412_p().func_147448_a(chunk.func_177434_r().values());
        for (ClassInheritanceMultiMap entityList : chunk.func_177429_s()) {
            chunk.func_177412_p().field_72996_f.addAll(entityList);
        }
    }

    public static boolean checkValidPhasedFieldGenerator(EntityPlayer player, boolean consume, int tickCost) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70451_h(); ++i) {
            int toConsume;
            PhasedFieldGeneratorItem pfg;
            int energyStored;
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null || slot.func_77973_b() != ModItems.phasedFieldGeneratorItem || (energyStored = (pfg = (PhasedFieldGeneratorItem)slot.func_77973_b()).getEnergyStored(slot)) < (toConsume = GeneralConfiguration.enableDynamicPhaseCost ? (int)((float)(10 * tickCost) * GeneralConfiguration.dynamicPhaseCostAmount) : 10 * PowerConfiguration.PHASEDFIELD_CONSUMEPERTICK)) continue;
            if (consume) {
                pfg.extractEnergy(slot, toConsume, false);
            }
            return true;
        }
        return false;
    }

    public void syncDimletRules(EntityPlayer player) {
        if (!player.func_130014_f_().field_72995_K) {
            Logging.log((String)"Send dimlet rules to the client");
            RFToolsDimMessages.INSTANCE.sendTo((IMessage)new PacketSyncRules(DimletRules.getRules()), (EntityPlayerMP)player);
        }
    }

    public void syncDimInfoToClients(World world) {
        if (!world.field_72995_K) {
            Logging.log((String)"Sync dimension info to clients!");
            RFToolsDimMessages.INSTANCE.sendToAll((IMessage)new PacketSyncDimensionInfo(this.dimensions, this.dimensionInformation));
        }
    }

    public Map<Integer, DimensionDescriptor> getDimensions() {
        return this.dimensions;
    }

    public void registerDimensions() {
        Logging.log((String)"Registering RFTools dimensions");
        for (Map.Entry<Integer, DimensionDescriptor> me : this.dimensions.entrySet()) {
            int id = me.getKey();
            Logging.log((String)("    Dimension: " + id));
            this.registerDimensionToServerAndClient(id);
        }
    }

    private void registerDimensionToServerAndClient(int id) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.registerDimension((int)id, (DimensionType)ModDimensions.rftoolsType);
        }
        RFToolsDimMessages.INSTANCE.sendToAll((IMessage)new PacketRegisterDimensions(id));
    }

    public static RfToolsDimensionManager getDimensionManagerClient() {
        if (instance != null) {
            return instance;
        }
        instance = new RfToolsDimensionManager(DIMMANAGER_NAME);
        return instance;
    }

    public static RfToolsDimensionManager getDimensionManager(World world) {
        if (instance != null) {
            return instance;
        }
        instance = (RfToolsDimensionManager)world.func_175693_T().func_75742_a(RfToolsDimensionManager.class, DIMMANAGER_NAME);
        if (instance == null) {
            instance = new RfToolsDimensionManager(DIMMANAGER_NAME);
        }
        return instance;
    }

    public DimensionDescriptor getDimensionDescriptor(int id) {
        return this.dimensions.get(id);
    }

    public Integer getDimensionID(DimensionDescriptor descriptor) {
        return this.dimensionToID.get(descriptor);
    }

    public DimensionInformation getDimensionInformation(int id) {
        return this.dimensionInformation.get(id);
    }

    public static World getWorldForDimension(World world, int id) {
        WorldServer w = DimensionManager.getWorld((int)id);
        if (w == null) {
            w = world.func_73046_m().func_71218_a(id);
        }
        return w;
    }

    public void removeDimension(int id) {
        DimensionDescriptor descriptor = this.dimensions.get(id);
        this.dimensions.remove(id);
        this.dimensionToID.remove(descriptor);
        this.dimensionInformation.remove(id);
        if (DimensionManager.isDimensionRegistered((int)id)) {
            DimensionManager.unregisterDimension((int)id);
        }
        DimensionManager.unregisterDimension((int)id);
    }

    public void recoverDimension(World world, int id, DimensionDescriptor descriptor, String name, String playerName, UUID player) {
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            this.registerDimensionToServerAndClient(id);
        }
        DimensionInformation dimensionInfo = new DimensionInformation(name, descriptor, world, playerName, player);
        this.dimensions.put(id, descriptor);
        this.dimensionToID.put(descriptor, id);
        this.dimensionInformation.put(id, dimensionInfo);
        this.save(world);
        this.touchSpawnChunk(world, id);
    }

    public int countOwnedDimensions(UUID player) {
        int cnt = 0;
        for (Map.Entry<Integer, DimensionInformation> entry : this.dimensionInformation.entrySet()) {
            int id = entry.getKey();
            DimensionInformation information = entry.getValue();
            if (!player.equals(information.getOwner())) continue;
            ++cnt;
        }
        return cnt;
    }

    public int createNewDimension(World world, DimensionDescriptor descriptor, String name, String playerName, UUID player) {
        int id = 0;
        while (!this.reclaimedIds.isEmpty()) {
            int rid = this.reclaimedIds.iterator().next();
            this.reclaimedIds.remove(rid);
            if (DimensionManager.isDimensionRegistered((int)rid)) continue;
            id = rid;
            break;
        }
        if (id == 0) {
            id = DimensionManager.getNextFreeDimId();
        }
        this.registerDimensionToServerAndClient(id);
        Logging.log((String)("id = " + id + " for " + name + ", descriptor = " + descriptor.getDescriptionString()));
        this.dimensions.put(id, descriptor);
        this.dimensionToID.put(descriptor, id);
        try {
            DimensionInformation dimensionInfo = new DimensionInformation(name, descriptor, world, playerName, player);
            this.dimensionInformation.put(id, dimensionInfo);
        }
        catch (Exception e) {
            Logging.logError((String)"Something went wrong during creation of the dimension!");
            e.printStackTrace();
        }
        this.save(world);
        this.touchSpawnChunk(world, id);
        return id;
    }

    private void touchSpawnChunk(World world, int id) {
        WorldServer worldServerForDimension = world.func_73046_m().func_71218_a(id);
        ChunkProviderServer providerServer = worldServerForDimension.func_72863_F();
        if (!providerServer.func_73149_a(0, 0)) {
            try {
                providerServer.func_186025_d(0, 0);
                providerServer.field_186029_c.func_185931_b(0, 0);
            }
            catch (Exception e) {
                Logging.logError((String)"Something went wrong during creation of the dimension!");
                e.printStackTrace();
            }
        }
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        int[] lstIds;
        this.dimensions.clear();
        this.dimensionToID.clear();
        this.dimensionInformation.clear();
        this.reclaimedIds.clear();
        NBTTagList lst = tagCompound.func_150295_c("dimensions", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("id");
            DimensionDescriptor descriptor = new DimensionDescriptor(tc);
            this.dimensions.put(id, descriptor);
            this.dimensionToID.put(descriptor, id);
            DimensionInformation dimensionInfo = new DimensionInformation(descriptor, tc);
            this.dimensionInformation.put(id, dimensionInfo);
        }
        for (int id : lstIds = tagCompound.func_74759_k("reclaimedIds")) {
            this.reclaimedIds.add(id);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, DimensionDescriptor> me : this.dimensions.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            Integer id = me.getKey();
            tc.func_74768_a("id", id.intValue());
            me.getValue().writeToNBT(tc);
            DimensionInformation dimensionInfo = this.dimensionInformation.get(id);
            dimensionInfo.writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("dimensions", (NBTBase)lst);
        ArrayList<Integer> ids = new ArrayList<Integer>(this.reclaimedIds);
        int[] lstIds = new int[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            lstIds[i] = (Integer)ids.get(i);
        }
        tagCompound.func_74783_a("reclaimedIds", lstIds);
        return tagCompound;
    }
}

