/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mcjty.rftoolsdim.api.dimlet.IFilterBuilder;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import mcjty.rftoolsdim.network.ByteBufTools;
import mcjty.rftoolsdim.varia.JSonTools;

public class Filter {
    private final Set<String> mods;
    private final Set<String> names;
    private final Set<Pattern> nameRegexps;
    private final Set<DimletType> types;
    private final Set<Feature> features;
    private final Set<Integer> metas;
    private final Map<String, String> properties;
    public static final Filter MATCHALL = new Filter(null, null, null, null, null, null, null);

    private Filter(Set<String> mods, Set<String> names, Set<Pattern> nameRegexps, Set<DimletType> types, Set<Feature> features, Set<Integer> metas, Map<String, String> properties) {
        this.mods = mods;
        this.names = names;
        this.nameRegexps = nameRegexps;
        this.types = types;
        this.features = features;
        this.metas = metas;
        this.properties = properties;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufTools.writeSetAsStrings(buf, this.mods);
        ByteBufTools.writeSetAsStrings(buf, this.names);
        ByteBufTools.writeSetAsStrings(buf, this.nameRegexps);
        ByteBufTools.writeSetAsEnums(buf, this.types);
        ByteBufTools.writeSetAsEnums(buf, this.features);
        ByteBufTools.writeSetAsShorts(buf, this.metas);
        ByteBufTools.writeMapAsStrings(buf, this.properties);
    }

    public Filter(ByteBuf buf) {
        this.mods = ByteBufTools.readSetFromStrings(buf);
        this.names = ByteBufTools.readSetFromStrings(buf);
        this.nameRegexps = ByteBufTools.readSetFromStringsWithMapper(buf, p -> Pattern.compile(p));
        this.types = ByteBufTools.readSetFromShortsWithMapper(buf, p -> DimletType.values()[p]);
        this.features = ByteBufTools.readSetFromShortsWithMapper(buf, p -> Feature.values()[p]);
        this.metas = ByteBufTools.readSetFromShorts(buf);
        this.properties = ByteBufTools.readMapFromStrings(buf);
    }

    public boolean match(DimletType type, String mod, String name, int metaIn, Map<String, String> propertiesIn, Set<Feature> featuresIn) {
        if (this.types != null && !this.types.contains((Object)type)) {
            return false;
        }
        if (this.mods != null && !this.mods.contains(mod.toLowerCase())) {
            return false;
        }
        if (this.metas != null && !this.metas.contains(metaIn)) {
            return false;
        }
        if (this.names != null || this.nameRegexps != null) {
            if (this.names != null && this.names.contains(name.toLowerCase())) {
                return true;
            }
            if (this.nameRegexps != null) {
                for (Pattern pattern : this.nameRegexps) {
                    Matcher matcher = pattern.matcher(name.toLowerCase());
                    if (!matcher.matches()) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.features != null) {
            if (featuresIn == null) {
                return false;
            }
            if (!this.features.stream().allMatch(featuresIn::contains)) {
                return false;
            }
        }
        if (this.properties != null) {
            if (propertiesIn == null) {
                return false;
            }
            if (!this.properties.entrySet().stream().allMatch(e -> this.safeCompare(propertiesIn, (Map.Entry<String, String>)e))) {
                return false;
            }
        }
        return true;
    }

    private boolean safeCompare(Map<String, String> propertiesIn, Map.Entry<String, String> e) {
        if (!propertiesIn.containsKey(e.getKey())) {
            return false;
        }
        if (propertiesIn.get(e.getKey()) == null) {
            return false;
        }
        return propertiesIn.get(e.getKey()).equals(e.getValue());
    }

    public JsonElement buildElement() {
        if (this.mods == null && this.names == null && this.nameRegexps == null && this.types == null && this.features == null && this.metas == null && this.properties == null) {
            return null;
        }
        JsonObject jsonObject = new JsonObject();
        JSonTools.addArrayOrSingle(jsonObject, "mod", this.mods);
        Set<Object> namedAndRegexps = this.names == null && this.nameRegexps == null ? null : (this.names == null ? this.nameRegexps.stream().map(Pattern::toString).collect(Collectors.toSet()) : (this.nameRegexps == null ? this.names : Stream.concat(this.names.stream(), this.nameRegexps.stream().map(Pattern::toString)).collect(Collectors.toSet())));
        JSonTools.addArrayOrSingle(jsonObject, "name", namedAndRegexps);
        JSonTools.addIntArrayOrSingle(jsonObject, "meta", this.metas);
        JSonTools.addArrayOrSingle(jsonObject, "type", this.types == null ? null : (Collection)this.types.stream().map(t -> t.dimletType.getName().toLowerCase()).collect(Collectors.toList()));
        JSonTools.addArrayOrSingle(jsonObject, "feature", this.features == null ? null : (Collection)this.features.stream().map(t -> t.name().toLowerCase()).collect(Collectors.toList()));
        JSonTools.addPairs(jsonObject, "property", this.properties);
        return jsonObject;
    }

    public static Filter parse(JsonElement element) {
        if (element == null) {
            return MATCHALL;
        }
        Builder builder = new Builder();
        JsonObject jsonObject = element.getAsJsonObject();
        JSonTools.getElement(jsonObject, "mod").ifPresent(e -> JSonTools.asArrayOrSingle(e).map(JsonElement::getAsString).forEach(builder::mod));
        JSonTools.getElement(jsonObject, "name").ifPresent(e -> JSonTools.asArrayOrSingle(e).map(JsonElement::getAsString).forEach(builder::name));
        JSonTools.getElement(jsonObject, "type").ifPresent(e -> JSonTools.asArrayOrSingle(e).map(el -> DimletType.getTypeByName(el.getAsString())).forEach(builder::type));
        JSonTools.getElement(jsonObject, "feature").ifPresent(e -> JSonTools.asArrayOrSingle(e).map(el -> Feature.getFeatureByName(el.getAsString())).forEach(builder::feature));
        JSonTools.getElement(jsonObject, "meta").ifPresent(e -> JSonTools.asArrayOrSingle(e).map(JsonElement::getAsInt).forEach(builder::meta));
        JSonTools.getElement(jsonObject, "property").ifPresent(e -> JSonTools.asPairs(e).forEach(p -> builder.property((String)p.getKey(), (String)p.getValue())));
        return builder.build();
    }

    public static enum Feature {
        TILEENTITY,
        OREDICT,
        PLANTABLE,
        NOFULLBLOCK,
        FALLING;

        private static final Map<String, Feature> FEATURE_MAP;

        public static Feature getFeatureByName(String name) {
            return FEATURE_MAP.get(name);
        }

        static {
            FEATURE_MAP = new HashMap<String, Feature>();
            for (Feature type : Feature.values()) {
                FEATURE_MAP.put(type.name().toLowerCase(), type);
            }
        }
    }

    public static class Builder
    implements IFilterBuilder {
        private Set<String> mods = null;
        private Set<String> names = null;
        private Set<Pattern> name_regexps = null;
        private Set<DimletType> types = null;
        private Set<Feature> features = null;
        private Set<Integer> metas = null;
        private Map<String, String> properties = null;

        @Override
        public Builder mod(String mod) {
            if (this.mods == null) {
                this.mods = new HashSet<String>();
            }
            this.mods.add(mod.toLowerCase());
            return this;
        }

        @Override
        public Builder name(String name) {
            if (name.contains("*")) {
                if (this.name_regexps == null) {
                    this.name_regexps = new HashSet<Pattern>();
                }
                this.name_regexps.add(Pattern.compile(name));
            } else {
                if (this.names == null) {
                    this.names = new HashSet<String>();
                }
                this.names.add(name.toLowerCase());
            }
            return this;
        }

        @Override
        public IFilterBuilder type(String type) {
            return this.type(DimletType.getTypeByName(type));
        }

        public Builder type(DimletType type) {
            if (this.types == null) {
                this.types = EnumSet.noneOf(DimletType.class);
            }
            this.types.add(type);
            return this;
        }

        public Builder feature(Feature feature) {
            if (this.features == null) {
                this.features = EnumSet.noneOf(Feature.class);
            }
            this.features.add(feature);
            return this;
        }

        @Override
        public Builder property(String name, String value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(name, value);
            return this;
        }

        @Override
        public Builder meta(Integer meta) {
            if (this.metas == null) {
                this.metas = new HashSet<Integer>();
            }
            this.metas.add(meta);
            return this;
        }

        public Filter build() {
            return new Filter(this.mods, this.names, this.name_regexps, this.types, this.features, this.metas, this.properties);
        }
    }
}

