/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.commands;

import mcjty.rftoolsdim.commands.AbstractRfToolsCommand;
import mcjty.rftoolsdim.dimensions.DimensionInformation;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CmdSetOwner
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<id> <owner>";
    }

    @Override
    public String getCommand() {
        return "setowner";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 3) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "The dimension and player parameters are missing!"));
            return;
        }
        if (args.length > 3) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        String playerName = this.fetchString(sender, args, 2, null);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionDescriptor(dim) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        for (EntityPlayerMP entityPlayerMP : world.func_73046_m().func_184103_al().func_181057_v()) {
            if (!playerName.equals(entityPlayerMP.func_145748_c_())) continue;
            DimensionInformation information = dimensionManager.getDimensionInformation(dim);
            information.setOwner(playerName, entityPlayerMP.func_146103_bH().getId());
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Owner of dimension changed!"));
            dimensionManager.save(world);
            return;
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Could not find player!"));
    }
}

