/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.network.energy.cable;

import com.mrdimka.solarfluxreborn.te.cable.TileAbstractCable;
import java.util.HashSet;
import java.util.Set;

public class CableNetwork {
    public final Set<TileAbstractCable> wires = new HashSet<TileAbstractCable>();
    public final Set<TileAbstractCable> wiresTicked = new HashSet<TileAbstractCable>();
    public double energy;
    public double capacity;
    public int updateRate = 0;

    public void setNet(CableNetwork net) {
        if (net != null) {
            net.capacity += this.capacity;
            net.energy += this.energy;
        }
        for (TileAbstractCable w : this.wires.toArray(new TileAbstractCable[0])) {
            w.network = net;
            if (net == null) continue;
            net.wires.add(w);
        }
        this.wires.clear();
        this.wiresTicked.clear();
        this.updateCapacity();
    }

    public void markTicked(TileAbstractCable wire) {
        if (this.wires.contains(wire)) {
            this.wiresTicked.add(wire);
        }
        if (this.wiresTicked.size() == this.wires.size()) {
            this.wiresTicked.clear();
            this.masterTick();
        }
    }

    public void masterTick() {
        if (this.updateRate++ >= 80) {
            this.updateRate = 0;
            this.updateCapacity();
        }
    }

    public void updateCapacity() {
        this.capacity = 0.0;
        for (TileAbstractCable w : this.wires.toArray(new TileAbstractCable[0])) {
            this.capacity += w.getCapacityAddedToNet();
        }
        for (TileAbstractCable w : this.wires.toArray(new TileAbstractCable[0])) {
            if (!(w.internal > 0.0)) continue;
            this.energy += w.internal;
            if (!(this.energy > this.capacity)) continue;
            w.internal += this.energy - this.capacity;
            this.energy = this.capacity;
        }
    }

    public void splitEnergyTo1Wire(TileAbstractCable wire) {
        double eq = this.getEqualAmtFor1Wire();
        wire.internal += eq;
        this.energy -= eq;
    }

    public double getEqualAmtFor1Wire() {
        if (this.wires.size() == 0) {
            return 0.0;
        }
        return this.energy / (double)this.wires.size();
    }

    public void disconnect(TileAbstractCable wire) {
        this.wires.remove(wire);
        this.wiresTicked.remove(wire);
        wire.network = null;
        this.die();
    }

    public void connect(TileAbstractCable wire) {
        this.wires.add(wire);
        wire.network = this;
    }

    public void merge(CableNetwork network) {
        network.setNet(this);
    }

    public void die() {
        this.setNet(null);
    }
}

