/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.network;

import com.mrdimka.solarfluxreborn.network.NetUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketTransferTileDataToClient
implements IMessage,
IMessageHandler<PacketTransferTileDataToClient, IMessage> {
    public NBTTagCompound tileData;
    public BlockPos pos;

    public PacketTransferTileDataToClient(TileEntity tile) {
        this.prepare(tile);
    }

    public PacketTransferTileDataToClient() {
    }

    public PacketTransferTileDataToClient prepare(TileEntity tile) {
        this.pos = tile.func_174877_v();
        this.tileData = tile.func_189515_b(new NBTTagCompound());
        return this;
    }

    public IMessage onMessage(PacketTransferTileDataToClient p, MessageContext c) {
        if (c.side == Side.CLIENT) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(p.pos);
            p.tileData.func_74757_a("ClientIgnoredInv", true);
            if (te != null) {
                te.func_145839_a(p.tileData);
            }
        } else if (c.side == Side.SERVER) {
            TileEntity te = c.getServerHandler().field_147369_b.field_70170_p.func_175625_s(p.pos);
            p.tileData.func_74757_a("ClientIgnoredInv", true);
            if (te != null) {
                te.func_145839_a(p.tileData);
            }
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetUtil.loadBlockPos(buf);
        this.tileData = NetUtil.readCompound(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetUtil.writeBlockPos(this.pos, buf);
        NetUtil.writeCompound(buf, this.tileData);
    }
}

