/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.gui;

import com.google.common.collect.Maps;
import com.mrdimka.solarfluxreborn.gui.SlotUpgrade;
import com.mrdimka.solarfluxreborn.items.UpgradeItem;
import com.mrdimka.solarfluxreborn.te.SolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.utility.Utils;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerSolarPanel
extends Container {
    protected static final int MOUSE_LEFT_CLICK = 0;
    protected static final int MOUSE_RIGHT_CLICK = 1;
    protected static final int FAKE_SLOT_ID = -999;
    protected static final int CLICK_MODE_NORMAL = 0;
    protected static final int CLICK_MODE_SHIFT = 1;
    protected static final int CLICK_MODE_KEY = 2;
    protected static final int CLICK_MODE_PICK_ITEM = 3;
    protected static final int CLICK_MODE_OUTSIDE = 4;
    protected static final int CLICK_DRAG_RELEASE = 5;
    protected static final int CLICK_MODE_DOUBLE_CLICK = 6;
    protected static final int CLICK_DRAG_MODE_PRE = 0;
    protected static final int CLICK_DRAG_MODE_SLOT = 1;
    protected static final int CLICK_DRAG_MODE_POST = 2;
    protected static final int PLAYER_INVENTORY_ROWS = 3;
    protected static final int PLAYER_INVENTORY_COLUMNS = 9;
    private final Map<Integer, Integer> mProgressBarValues = Maps.newHashMap();
    private final SolarPanelTileEntity mSolarPanelTileEntity;

    public ContainerSolarPanel(InventoryPlayer pInventoryPlayer, SolarPanelTileEntity pSolarPanelTileEntity) {
        this.mSolarPanelTileEntity = pSolarPanelTileEntity;
        for (int i = 0; i < 5; ++i) {
            this.func_75146_a(new SlotUpgrade(this.mSolarPanelTileEntity, i, 17 + i * 18, 59));
        }
        this.addPlayerInventorySlotsToContainer(pInventoryPlayer, 8, 98);
        this.addPlayerActionSlotsToContainer(pInventoryPlayer, 8, 156);
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int pIndex, int pValue) {
        super.func_75137_b(pIndex, pValue);
        if (pIndex == 0) {
            this.mSolarPanelTileEntity.setEnergyStored(this.mSolarPanelTileEntity.getEnergyStored() & 0xFFFF0000 | pValue);
        }
        if (pIndex == 1) {
            this.mSolarPanelTileEntity.setEnergyStored(this.mSolarPanelTileEntity.getEnergyStored() & 0xFFFF | pValue << 16);
        }
        if (pIndex == 2) {
            this.mSolarPanelTileEntity.setCurrentEnergyGeneration(this.mSolarPanelTileEntity.getCurrentEnergyGeneration() & 0xFFFF0000 | pValue);
        }
        if (pIndex == 3) {
            this.mSolarPanelTileEntity.setCurrentEnergyGeneration(this.mSolarPanelTileEntity.getCurrentEnergyGeneration() & 0xFFFF | pValue << 16);
        }
        if (pIndex == 4) {
            this.mSolarPanelTileEntity.setSunIntensity((float)pValue / 100.0f);
        }
    }

    protected void addPlayerActionSlotsToContainer(InventoryPlayer pInventoryPlayer, int pLeft, int pTop) {
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)pInventoryPlayer, actionBarSlotIndex, pLeft + actionBarSlotIndex * 18, pTop));
        }
    }

    public boolean func_94531_b(Slot pSlot) {
        return pSlot.getSlotIndex() >= 5;
    }

    protected void addPlayerInventorySlotsToContainer(InventoryPlayer pInventoryPlayer, int pLeft, int pTop) {
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)pInventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, pLeft + inventoryColumnIndex * 18, pTop + inventoryRowIndex * 18));
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer pPlayer, int pSlotIndex) {
        return null;
    }

    public ItemStack func_184996_a(int slot, int btn, ClickType clickMode, EntityPlayer player) {
        int canAdd;
        ItemStack currentItemInSlot;
        ItemStack oldItemStack = player.field_71071_by.func_70445_o();
        if (SolarPanelTileEntity.UPGRADE_SLOTS.contains((Comparable)Integer.valueOf(slot)) && oldItemStack != null && oldItemStack.func_77973_b() instanceof UpgradeItem && (btn == 0 || btn == 1) && ((currentItemInSlot = this.mSolarPanelTileEntity.func_70301_a(slot)) == null || Utils.itemStacksEqualIgnoreStackSize(oldItemStack, currentItemInSlot)) && (canAdd = this.mSolarPanelTileEntity.additionalUpgradeAllowed(oldItemStack)) > 0) {
            ItemStack newStack;
            if (btn == 1) {
                canAdd = 1;
            }
            if (canAdd >= oldItemStack.field_77994_a) {
                newStack = oldItemStack;
                oldItemStack = null;
            } else {
                newStack = oldItemStack.func_77979_a(canAdd);
            }
            player.field_71071_by.func_70437_b(newStack);
            ItemStack result = super.func_184996_a(slot, btn, clickMode, player);
            player.field_71071_by.func_70437_b(oldItemStack);
            return result;
        }
        return super.func_184996_a(slot, btn, clickMode, player);
    }

    public boolean func_75145_c(EntityPlayer arg0) {
        return true;
    }
}

