/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.blocks;

import com.mrdimka.solarfluxreborn.SolarFluxRebornMod;
import com.mrdimka.solarfluxreborn.config.ModConfiguration;
import com.mrdimka.solarfluxreborn.creativetab.ModCreativeTab;
import com.mrdimka.solarfluxreborn.te.SolarPanelTileEntity;
import com.mrdimka.solarfluxreborn.utility.Lang;
import com.mrdimka.solarfluxreborn.utility.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SolarPanelBlock
extends BlockContainer {
    private final int mTierIndex;

    public SolarPanelBlock(String pName, int pTierIndex) {
        super(Material.field_151573_f);
        this.func_149663_c("SolarFluxReborn:" + pName);
        this.mTierIndex = pTierIndex;
        this.func_149647_a(ModCreativeTab.MOD_TAB);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public boolean func_149662_c(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public boolean func_185481_k(IBlockState p_isFullyOpaque_1_) {
        return false;
    }

    public boolean func_149686_d(IBlockState p_isFullCube_1_) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState s, IBlockAccess w, BlockPos p) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState s, World w, BlockPos p) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public AxisAlignedBB func_180640_a(IBlockState s, World w, BlockPos p) {
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)p.func_177956_o() + 0.375, (double)(p.func_177952_p() + 1));
    }

    public TileEntity func_149915_a(World pWorld, int pMetadata) {
        return new SolarPanelTileEntity(this.mTierIndex);
    }

    public EnumBlockRenderType func_149645_b(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World w, BlockPos pos, IBlockState s, EntityLivingBase ent, ItemStack stack) {
        super.func_180633_a(w, pos, s, ent, stack);
        if (stack.func_77978_p() != null) {
            SolarPanelTileEntity localTileCell = (SolarPanelTileEntity)w.func_175625_s(pos);
            localTileCell.getInventory().readFromNBT(stack.func_77978_p());
            localTileCell.func_70296_d();
            localTileCell.setEnergyStored(stack.func_77978_p().func_74762_e("SFEnergy"));
        }
    }

    public boolean func_180639_a(World w, BlockPos pos, IBlockState s, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float p_onBlockActivated_8_, float p_onBlockActivated_9_, float p_onBlockActivated_10_) {
        if (!w.field_72995_K) {
            if (player.func_70093_af()) {
                if (Utils.hasUsableWrench(player, pos)) {
                    this.dismantleBlock(w, pos);
                    return true;
                }
                if (ModConfiguration.infoOnSneakClick()) {
                    this.displayChatInformation(w, pos, player);
                }
            } else if (w.func_175625_s(pos) instanceof SolarPanelTileEntity) {
                player.openGui((Object)SolarFluxRebornMod.instance, 0, w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private void displayChatInformation(World pWorld, BlockPos pos, EntityPlayer pPlayer) {
        SolarPanelTileEntity tile = (SolarPanelTileEntity)pWorld.func_175625_s(pos);
        String message = String.format("%s: [%d%%] %,d / %,d %s: %,d", Lang.localise("energy.stored"), tile.getPercentageEnergyStored(), tile.getEnergyStored(), tile.getMaxEnergyStored(), Lang.localise("energy.generation"), tile.getCurrentEnergyGeneration());
        pPlayer.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private void dismantleBlock(World pWorld, BlockPos pos) {
        int upgradeInstalled;
        SolarPanelTileEntity localTileCell;
        int internalEnergy;
        ItemStack itemStack = new ItemStack((Block)this);
        if (ModConfiguration.doesKeepEnergyWhenDismantled() && (internalEnergy = (localTileCell = (SolarPanelTileEntity)pWorld.func_175625_s(pos)).getEnergyStored()) > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("SFEnergy", internalEnergy);
        }
        if (ModConfiguration.doesKeepInventoryWhenDismantled() && (upgradeInstalled = (localTileCell = (SolarPanelTileEntity)pWorld.func_175625_s(pos)).getTotalUpgradeInstalled()) > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            localTileCell.getInventory().writeToNBT(itemStack.func_77978_p());
            itemStack.func_77978_p().func_74768_a("SFTLUpgradeCount", upgradeInstalled);
            itemStack.func_77978_p().func_74768_a("SFTLCapacity", localTileCell.getEnergyStorage().getMaxEnergyStored());
            itemStack.func_77978_p().func_74768_a("SFTLTransferRate", localTileCell.getEnergyStorage().getMaxTransferExtract());
            pWorld.func_175713_t(pos);
        }
        pWorld.func_175698_g(pos);
        pWorld.func_72838_d((Entity)new EntityItem(pWorld, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, itemStack));
    }

    public int getTierIndex() {
        return this.mTierIndex;
    }
}

