/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.common.utils;

import com.mrdimka.solarfluxreborn.network.SFRNetwork;
import com.mrdimka.solarfluxreborn.utility.SFRLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class CommonTileEntity_SFR
extends TileEntity
implements ITickable {
    public static long lastSyncedTileTime = 0L;
    private List<EntityPlayer> playersNearby = new ArrayList<EntityPlayer>();
    private int syncDelay = 0;

    public abstract void readCustomNBT(NBTTagCompound var1);

    public abstract void writeCustomNBT(NBTTagCompound var1);

    public void updateEntity() {
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.syncDelay = nbt.func_74762_e("SyncDelay");
        this.readCustomNBT(nbt);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("SyncDelay", this.syncDelay);
        this.writeCustomNBT(nbt);
        return nbt;
    }

    public Packet getDescriptionPacket() {
        return this.func_189518_D_();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readCustomNBT(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 64537, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
    }

    public final void func_73660_a() {
        try {
            this.updateEntity();
        }
        catch (Throwable err) {
            SFRLog.bigWarning("WARNING: Tile Entity " + ((Object)((Object)this)).getClass().getName() + " failed to tick!", new Object[0]);
            err.printStackTrace();
            SFRLog.severe("Removing dangerous tile..", new Object[0]);
            IBlockState s = this.field_145850_b.func_180495_p(this.field_174879_c);
            s.func_177230_c().func_176226_b(this.field_145850_b, this.field_174879_c, s, 0);
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
        if (!this.field_145850_b.field_72995_K && this.hasSync()) {
            int prev = this.playersNearby != null ? this.playersNearby.size() : 0;
            this.playersNearby = this.field_145850_b.func_72872_a(EntityPlayer.class, this.getSyncRad());
            if (this.playersNearby.size() != prev) {
                this.syncDelay = this.getSyncDelay() - 80;
            }
            if (this.syncDelay < this.getSyncDelay()) {
                ++this.syncDelay;
            }
            if (this.syncDelay > this.getSyncDelay() && System.currentTimeMillis() - lastSyncedTileTime > 50L) {
                SFRNetwork.sync(this);
                this.syncDelay = 0;
                lastSyncedTileTime = System.currentTimeMillis();
            }
        }
    }

    protected AxisAlignedBB getSyncRad() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 128), (double)(this.field_174879_c.func_177956_o() - 128), (double)(this.field_174879_c.func_177952_p() - 128), (double)(this.field_174879_c.func_177958_n() + 128), (double)(this.field_174879_c.func_177956_o() + 128), (double)(this.field_174879_c.func_177952_p() + 128));
    }

    protected boolean hasSync() {
        return true;
    }

    protected int getSyncDelay() {
        return 80;
    }
}

