/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.BackupCommand;
import aroma1997.backup.Config;
import aroma1997.backup.EventListener;
import aroma1997.backup.Reference;
import aroma1997.backup.ThreadBackup;
import aroma1997.backup.ThreadSchedule;
import aroma1997.backup.WorldIndex;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import aroma1997.core.version.VersionCheck;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="AromaBackup", name="AromaBackup", dependencies="required-after:Aroma1997Core", acceptedMinecraftVersions="[1.9.4]")
public class AromaBackup
implements ICommandSender {
    public Logger logger = LogHelper.genNewLogger((String)"AromaBackup");
    @Mod.Instance(value="AromaBackup")
    public static AromaBackup instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.instance.reload();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        VersionCheck.registerVersionChecker((String)"AromaBackup", (String)Reference.VERSION);
        EventListener el = new EventListener();
        FMLCommonHandler.instance().bus().register((Object)el);
        MinecraftForge.EVENT_BUS.register((Object)el);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new BackupCommand());
        WorldIndex.load();
        if (Config.instance.delay != 0L) {
            ThreadSchedule.startNewThread();
        }
        ThreadBackup.shouldBackup = true;
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        try {
            BasicFileAttributes attr = Files.readAttributes(Util.getWorldFolder().toPath(), BasicFileAttributes.class, new LinkOption[0]);
            long fileCreated = attr.creationTime().toMillis();
            ThreadSchedule.nextbackup = Config.instance.onStartup ? (fileCreated > System.currentTimeMillis() - 10000L && fileCreated <= System.currentTimeMillis() ? System.currentTimeMillis() + 60000L : System.currentTimeMillis() + 5000L) : System.currentTimeMillis() + Config.instance.delay;
        }
        catch (IOException e) {
            ThreadSchedule.nextbackup = Config.instance.onStartup ? System.currentTimeMillis() + 60000L : System.currentTimeMillis() + Config.instance.delay;
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, "Next Backup in: " + (ThreadSchedule.nextbackup - System.currentTimeMillis() + 1L) / 1000L + " seconds.");
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        ThreadSchedule.stopThread();
    }

    public String func_70005_c_() {
        return "AromaBackup";
    }

    public boolean func_70003_b(int i, String s) {
        return true;
    }

    public World func_130014_f_() {
        return null;
    }

    public void func_145747_a(ITextComponent comp) {
        this.logger.log(Level.TRACE, comp.func_150260_c());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return ServerUtil.getChatForString((String)LogHelper.getLoggerPrefix((boolean)true, (Logger)this.logger, (String)this.func_70005_c_()));
    }

    public BlockPos func_180425_c() {
        return new BlockPos(0, 0, 0);
    }

    public Vec3d func_174791_d() {
        return Vec3d.field_186680_a;
    }

    public Entity func_174793_f() {
        return null;
    }

    public boolean func_174792_t_() {
        return true;
    }

    public void func_174794_a(CommandResultStats.Type type, int amount) {
    }

    public MinecraftServer func_184102_h() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }
}

