/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.modmuss50.fr.repack.kotlin.collections.IndexedValue;
import me.modmuss50.fr.repack.kotlin.collections.MapsKt;
import me.modmuss50.fr.repack.kotlin.jvm.functions.Function0;
import me.modmuss50.fr.repack.kotlin.jvm.functions.Function1;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.FlexibleTypeFactory;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.types.Variance;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(additionalAnnotations, "additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeFactory flexibleTypeFactory = this.c.getComponents().getFlexibleTypeFactory();
            if (Intrinsics.areEqual(flexibleTypeFactory.getId(), id) ^ true) {
                KotlinType kotlinType = ErrorUtils.createErrorType(new DeserializedType(this.c, proto, null, 4, null) + ": " + ("Unexpected flexible type factory. Expected: " + flexibleTypeFactory.getId() + " Actual: " + id));
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "ErrorUtils.createErrorTy\u2026Factory.id} Actual: $id\")");
                return kotlinType;
            }
            KotlinType kotlinType = new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            return flexibleTypeFactory.create(kotlinType, new DeserializedType(this.c, type2, null, 4, null));
        }
        return new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: type");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        if (proto.hasClassName()) {
            annotated = this.classDescriptors.invoke(proto.getClassName());
            if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
                annotated = this.c.getComponents().getNotFoundClasses().get(proto, this.c.getNameResolver(), this.c.getTypeTable());
            }
        } else if (proto.hasTypeParameter()) {
            annotated = this.typeParameterTypeConstructor(proto.getTypeParameter());
            if (annotated == null) {
                TypeConstructor typeConstructor2 = ErrorUtils.createErrorType("Unknown type parameter " + proto.getTypeParameter()).getConstructor();
                annotated = typeConstructor2;
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "ErrorUtils.createErrorTy\u2026eParameter}\").constructor");
            }
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v5;
            String name;
            DeclarationDescriptor container;
            block14: {
                List<Object> list;
                container = this.c.getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    List<TypeParameterDescriptor> list2 = ((ClassDescriptor)container).getTypeConstructor().getParameters();
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull(list2, "container.typeConstructor.parameters");
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    List<TypeParameterDescriptor> list3 = ((CallableDescriptor)container).getTypeParameters();
                    list = list3;
                    Intrinsics.checkExpressionValueIsNotNull(list3, "container.typeParameters");
                } else {
                    list = me.modmuss50.fr.repack.kotlin.collections.CollectionsKt.emptyList();
                }
                List<Object> typeParameters = list;
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = typeParameters;
                Iterable iterable2 = iterable;
                for (Object t : iterable2) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)t;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v5 = t;
                    break block14;
                }
                v5 = null;
            }
            if ((annotated = (parameter = (TypeParameterDescriptor)v5)) == null || (annotated = annotated.getTypeConstructor()) == null) {
                TypeConstructor typeConstructor3 = ErrorUtils.createErrorType("Deserialized type parameter " + name + " in " + container).getConstructor();
                annotated = typeConstructor3;
                Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "ErrorUtils.createErrorTy\u2026 $container\").constructor");
            }
        } else {
            TypeConstructor typeConstructor4 = ErrorUtils.createErrorType("Unknown type").getConstructor();
            annotated = typeConstructor4;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor4, "ErrorUtils.createErrorTy\u2026nknown type\").constructor");
        }
        return annotated;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Annotated annotated = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            annotated = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return annotated;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull(classId, "id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        Intrinsics.checkParameterIsNotNull(typeArgumentProto, "typeArgumentProto");
        if (Intrinsics.areEqual(typeArgumentProto.getProjection(), ProtoBuf.Type.Argument.Projection.STAR)) {
            TypeProjection typeProjection;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull(projection, "typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map2;
                if (TypeDeserializer.access$getTypeParameterProtos$p(this.this$0).isEmpty()) {
                    map2 = MapsKt.emptyMap();
                } else {
                    LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                    for (IndexedValue<T> indexedValue : me.modmuss50.fr.repack.kotlin.collections.CollectionsKt.withIndex(TypeDeserializer.access$getTypeParameterProtos$p(this.this$0))) {
                        int index = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        Map map3 = result;
                        Integer n = proto.getId();
                        DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$p(this.this$0), proto, index);
                        map3.put(n, deserializedTypeParameterDescriptor);
                    }
                    map2 = result;
                }
                return map2;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List access$getTypeParameterProtos$p(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }
}

