/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import me.modmuss50.fr.repack.kotlin.TypeCastException;
import me.modmuss50.fr.repack.kotlin.collections.CollectionsKt;
import me.modmuss50.fr.repack.kotlin.jvm.functions.Function1;
import me.modmuss50.fr.repack.kotlin.jvm.internal.Intrinsics;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.ClassId;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.FqName;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.name.Name;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import me.modmuss50.fr.repack.kotlin.reflect.jvm.internal.impl.serialization.deserialization.NotFoundClasses;
import me.modmuss50.fr.repack.kotlin.sequences.SequencesKt;
import me.modmuss50.fr.repack.org.jetbrains.annotations.NotNull;
import me.modmuss50.fr.repack.org.jetbrains.annotations.Nullable;

public final class FindClassInModuleKt {
    @Nullable
    public static final ClassDescriptor findClassAcrossModuleDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId) {
        ClassDescriptor topLevelClass;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.packageFqName");
        PackageViewDescriptor packageViewDescriptor = $receiver.getPackage(fqName2);
        List<Name> segments = classId.getRelativeClassName().pathSegments();
        MemberScope memberScope2 = packageViewDescriptor.getMemberScope();
        Name name = CollectionsKt.first(segments);
        Intrinsics.checkExpressionValueIsNotNull(name, "segments.first()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name, NoLookupLocation.FROM_DESERIALIZATION);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor result = topLevelClass = classDescriptor;
        for (Name name2 : segments.subList(1, segments.size())) {
            MemberScope memberScope3 = result.getUnsubstitutedInnerClassesScope();
            Name name3 = name2;
            Intrinsics.checkExpressionValueIsNotNull(name3, "name");
            ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name3, NoLookupLocation.FROM_DESERIALIZATION);
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            if ((ClassDescriptor)classifierDescriptor2 != null) continue;
            return null;
        }
        return result;
    }

    @NotNull
    public static final ClassDescriptor findNonGenericClassAcrossDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        Intrinsics.checkParameterIsNotNull(notFoundClasses, "notFoundClasses");
        ClassDescriptor existingClass = FindClassInModuleKt.findClassAcrossModuleDependencies($receiver, classId);
        if (existingClass != null) {
            return existingClass;
        }
        List<Integer> typeParametersCount2 = SequencesKt.toList(SequencesKt.map(SequencesKt.generateSequence(classId, (Function1)findNonGenericClassAcrossDependencies.typeParametersCount.1.INSTANCE), findNonGenericClassAcrossDependencies.typeParametersCount.2.INSTANCE));
        ClassifierDescriptor classifierDescriptor = notFoundClasses.get(classId, typeParametersCount2).getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return (ClassDescriptor)classifierDescriptor;
    }
}

