/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.items;

import java.util.List;
import jotato.quantumflux.Logger;
import jotato.quantumflux.helpers.NbtHelpers;
import jotato.quantumflux.items.ItemBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMatterTransporter
extends ItemBase {
    private static final String HAS_BLOCK = "hasblock";
    private static final String HAS_TILEENTITY = "hasentity";
    private static final String STORED_BLOCK = "block";
    private static final String STORED_TILEENTITY = "tileentity";
    private static final String STORED_METADATA = "metadata";
    private int maxDamage = 50;

    public ItemMatterTransporter() {
        super("matterTransporter");
        this.func_77625_d(1);
        this.func_77656_e(this.maxDamage);
    }

    @Override
    public void initModel() {
        Logger.info("    Registering model for %s", this.getSimpleName());
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack item) {
        return NbtHelpers.getBoolean(item, HAS_BLOCK, false);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean p4) {
        if (itemstack.func_77978_p() == null) {
            return;
        }
        if (NbtHelpers.getBoolean(itemstack, HAS_BLOCK, false)) {
            Block block = this.getBlockFromNbt(itemstack);
            String name = new ItemStack(block).func_82833_r();
            list.add(name);
        }
    }

    public EnumActionResult func_180614_a(ItemStack stackIn, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean hasBlock = NbtHelpers.getBoolean(stackIn, HAS_BLOCK, false);
        boolean hasTE = NbtHelpers.getBoolean(stackIn, HAS_TILEENTITY, false);
        if (hasBlock) {
            int metadata = NbtHelpers.getInt(stackIn, STORED_METADATA, 0);
            Block storedBlock = this.getBlockFromNbt(stackIn);
            BlockPos targetPos = pos.func_177971_a(facing.func_176730_m());
            Block targetBlock = worldIn.func_180495_p(targetPos).func_177230_c();
            if ((worldIn.func_175623_d(targetPos) || targetBlock.func_176200_f((IBlockAccess)worldIn, targetPos)) && storedBlock.func_176196_c(worldIn, targetPos)) {
                worldIn.func_175656_a(targetPos, storedBlock.func_176203_a(metadata));
                if (hasTE) {
                    NBTTagCompound tileEntityNbtData = NbtHelpers.getCompoundTag(stackIn, STORED_TILEENTITY);
                    TileEntity te = worldIn.func_175625_s(targetPos);
                    if (te != null) {
                        tileEntityNbtData.func_74768_a("x", targetPos.func_177958_n());
                        tileEntityNbtData.func_74768_a("y", targetPos.func_177956_o());
                        tileEntityNbtData.func_74768_a("z", targetPos.func_177952_p());
                        te.func_145839_a(tileEntityNbtData);
                        te.func_70296_d();
                    }
                }
                NbtHelpers.setBoolean(stackIn, HAS_BLOCK, false);
                NbtHelpers.setBoolean(stackIn, HAS_TILEENTITY, false);
                if (storedBlock.func_149732_F().toLowerCase().contains("spawner")) {
                    stackIn.func_77972_a(this.maxDamage / 4, (EntityLivingBase)playerIn);
                } else {
                    stackIn.func_77972_a(1, (EntityLivingBase)playerIn);
                }
                worldIn.func_180496_d(targetPos, storedBlock);
                playerIn.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        } else if (!worldIn.func_175623_d(pos)) {
            IBlockState targetBlockState = worldIn.func_180495_p(pos);
            Block targetBlock = targetBlockState.func_177230_c();
            int metadata = targetBlock.func_176201_c(targetBlockState);
            if (targetBlock.field_149763_I == -1.0f || targetBlock.func_176195_g(targetBlockState, worldIn, pos) < 0.0f) {
                return EnumActionResult.FAIL;
            }
            if (worldIn.func_175625_s(pos) != null) {
                NBTTagCompound savedTE = new NBTTagCompound();
                TileEntity te = worldIn.func_175625_s(pos);
                te.func_189515_b(savedTE);
                NbtHelpers.setBoolean(stackIn, HAS_TILEENTITY, true);
                NbtHelpers.setTag(stackIn, STORED_TILEENTITY, (NBTBase)savedTE);
            }
            NBTTagCompound blockNbt = new NBTTagCompound();
            ItemStack i = new ItemStack(targetBlock);
            i.func_77955_b(blockNbt);
            NbtHelpers.setTag(stackIn, STORED_BLOCK, (NBTBase)blockNbt);
            NbtHelpers.setInt(stackIn, STORED_METADATA, metadata);
            try {
                this.getBlockFromNbt(stackIn);
            }
            catch (Exception e) {
                return EnumActionResult.FAIL;
            }
            worldIn.func_175713_t(pos);
            worldIn.func_175698_g(pos);
            playerIn.func_184185_a(SoundEvents.field_187638_cR, 0.15f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            NbtHelpers.setBoolean(stackIn, HAS_BLOCK, true);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77622_d(ItemStack itemstack, World world, EntityPlayer player) {
        NbtHelpers.setBoolean(itemstack, HAS_BLOCK, false);
        NbtHelpers.setBoolean(itemstack, HAS_TILEENTITY, false);
    }

    private Block getBlockFromNbt(ItemStack itemstack) {
        NBTTagCompound storedBlock = NbtHelpers.getCompoundTag(itemstack, STORED_BLOCK);
        ItemStack storedStack = ItemStack.func_77949_a((NBTTagCompound)storedBlock);
        Block block = Block.func_149634_a((Item)storedStack.func_77973_b());
        return block;
    }
}

