/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.items;

import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import jotato.quantumflux.Logger;
import jotato.quantumflux.helpers.ItemHelpers;
import jotato.quantumflux.items.ItemBase;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.oredict.OreDictionary;

public class ItemCraftingPiece
extends ItemBase {
    public TMap<String, SubItem> subItemMap = new THashMap();
    public ArrayList<SubItem> subItemList = new ArrayList();

    public ItemCraftingPiece() {
        super("craftingPiece");
        this.func_77627_a(true);
    }

    @Override
    public void initModel() {
        for (SubItem item : this.subItemList) {
            Logger.info("    Registering model for %s", item.name);
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)item.meta, (ModelResourceLocation)new ModelResourceLocation("quantumflux:" + item.name, "inventory"));
        }
    }

    public SubItem getUnderlyingItem(ItemStack stack) {
        return this.subItemList.get(stack.func_77952_i());
    }

    public ItemStack addItem(String name, String oreDictName, int number) {
        if (this.subItemMap.containsKey((Object)String.valueOf(name))) {
            return null;
        }
        SubItem entry = new SubItem(name, number);
        this.subItemMap.put((Object)String.valueOf(name), (Object)entry);
        this.subItemList.add(entry);
        ItemStack item = new ItemStack((Item)this, 1, number);
        if (oreDictName != null && oreDictName.trim().length() > 0) {
            OreDictionary.registerOre((String)oreDictName.trim(), (ItemStack)item);
        }
        this.subItemList.trimToSize();
        return item;
    }

    public ItemStack addItem(String name, int number) {
        return this.addItem(name, null, number);
    }

    public ItemStack getSubItem(String name) {
        return this.getSubItem(name, 1);
    }

    public ItemStack getSubItem(String name, int amount) {
        if (this.subItemMap.containsKey((Object)name)) {
            int meta = ((SubItem)this.subItemMap.get((Object)name)).meta;
            return new ItemStack((Item)this, amount, meta);
        }
        return new ItemStack(Items.field_151034_e, amount);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < this.subItemList.size(); ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        int meta = this.getDamage(stack);
        if (this.subItemList.size() <= meta) {
            return "item.invalid";
        }
        SubItem item = this.subItemList.get(meta);
        return "item." + item.name;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ItemHelpers.addFlairToList(tooltip, this.func_77667_c(stack));
    }

    public class SubItem {
        public String name;
        public int meta;

        public SubItem(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }
    }
}

