/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.reflection;

import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AdvancedReflectionHelper {
    private static final Field fieldConstructorModifiers;
    private static final Field fieldFieldModifiers;
    private static final Field fieldMethodModifiers;

    private static int set(int original, int modifier, boolean on) {
        if (on) {
            return original | modifier;
        }
        return original & ~modifier;
    }

    static {
        try {
            fieldConstructorModifiers = Constructor.class.getDeclaredField("modifiers");
            fieldConstructorModifiers.setAccessible(true);
            fieldFieldModifiers = Field.class.getDeclaredField("modifiers");
            fieldFieldModifiers.setAccessible(true);
            fieldMethodModifiers = Method.class.getDeclaredField("modifiers");
            fieldMethodModifiers.setAccessible(true);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class AMethod<C, T>
    extends ReflectionObject<C, Method> {
        private final Method method;

        public AMethod(Method method) {
            super(method.getDeclaringClass());
            this.method = method;
        }

        public AMethod(Class<C> clas, String[] names, Class ... args) {
            this(ReflectionHelper.findMethod(clas, null, (String[])names, (Class[])args));
        }

        @Override
        public AMethod<C, T> set(int modifier, boolean on) {
            try {
                fieldMethodModifiers.setInt(this.method, AdvancedReflectionHelper.set(this.method.getModifiers(), modifier, on));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            return this;
        }

        @Override
        public AMethod<C, T> setAccessible(boolean accessible) {
            this.method.setAccessible(accessible);
            return this;
        }

        public AMethod<C, T> setFinal(boolean finall) {
            return this.set(16, finall);
        }

        @Override
        public Method get() {
            return this.method;
        }

        public <I extends C> T invoke(I instance, Object ... args) {
            try {
                return (T)this.method.invoke(instance, args);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class AField<C, T>
    extends ReflectionObject<C, Field> {
        private final Field field;

        public AField(Field field) {
            super(field.getDeclaringClass());
            this.field = field;
        }

        public AField(Class<C> clas, String ... names) {
            this(ReflectionHelper.findField(clas, (String[])names));
        }

        @Override
        public AField<C, T> set(int modifier, boolean on) {
            try {
                fieldFieldModifiers.setInt(this.field, AdvancedReflectionHelper.set(this.field.getModifiers(), modifier, on));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            return this;
        }

        @Override
        public AField<C, T> setAccessible(boolean accessible) {
            this.field.setAccessible(accessible);
            return this;
        }

        public AField<C, T> setFinal(boolean finall) {
            return this.set(16, finall);
        }

        @Override
        public Field get() {
            return this.field;
        }

        public <I extends C> T get(I instance) {
            try {
                return (T)this.field.get(instance);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public <I extends C> void set(I instance, T t) {
            try {
                this.field.set(instance, t);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class AConstructor<C>
    extends ReflectionObject<C, Constructor<C>> {
        private final Constructor<C> constructor;

        public AConstructor(Constructor<C> constructor) {
            super(constructor.getDeclaringClass());
            this.constructor = constructor;
        }

        public AConstructor(Class<C> clas, Class ... args) {
            super(clas);
            try {
                this.constructor = clas.getDeclaredConstructor(args);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public AConstructor<C> set(int modifier, boolean on) {
            try {
                fieldConstructorModifiers.setInt(this.constructor, AdvancedReflectionHelper.set(this.constructor.getModifiers(), modifier, on));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            return this;
        }

        @Override
        public AConstructor<C> setAccessible(boolean accessible) {
            this.constructor.setAccessible(accessible);
            return this;
        }

        @Override
        public Constructor get() {
            return this.constructor;
        }

        public C newInstance(Object ... args) {
            try {
                return this.constructor.newInstance(args);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static abstract class ReflectionObject<C, T> {
        private final AClass<C> clas;

        public ReflectionObject(Class<C> clas) {
            this.clas = new AClass<C>(clas);
        }

        public ReflectionObject(String clas) {
            try {
                this.clas = new AClass(Class.forName(clas));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public AClass<C> clas() {
            return this.clas;
        }

        public abstract <R extends ReflectionObject<C, T>> R set(int var1, boolean var2);

        public abstract <R extends ReflectionObject<C, T>> R setAccessible(boolean var1);

        public abstract T get();
    }

    public static class AClass<C> {
        protected final Class<C> clas;

        public AClass(Class<C> clas) {
            this.clas = clas;
        }

        public AClass(String clas) {
            try {
                this.clas = Class.forName(clas);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean isInterface() {
            return this.clas.isInterface();
        }

        public AInterface<C> toInterface() {
            return new AInterface(this.clas);
        }

        public boolean isEnum() {
            return this.clas.isEnum();
        }

        public <E extends Enum> AEnum<E> toEnum() {
            return new AEnum(this.clas);
        }

        public boolean isAnnotation() {
            return this.clas.isAnnotation();
        }

        public AAnnotation<C> toAnnotation() {
            return new AAnnotation(this.clas);
        }

        public AConstructor<C> getDeclaredConstructor(Class ... args) {
            return new AConstructor<C>(this.clas, args);
        }

        public <T> AField<C, T> getDeclaredField(String ... names) {
            return new AField(this.clas, names);
        }

        public <T> AMethod<C, T> getDeclaredMethod(String[] names, Class ... args) {
            return new AMethod(this.clas, names, args);
        }

        public static class AAnnotation<C>
        extends AClass<C> {
            private AAnnotation(Class<C> clas) {
                super(clas);
            }
        }

        public static class AEnum<C extends Enum>
        extends AClass<C> {
            private AEnum(Class<C> clas) {
                super(clas);
            }

            public C getEnum(int ordinal) {
                return (C)((Enum[])this.clas.getEnumConstants())[ordinal];
            }

            public C getEnum(String name) {
                return (C)Enum.valueOf(this.clas, name);
            }
        }

        public static class AInterface<C>
        extends AClass<C> {
            private AInterface(Class<C> clas) {
                super(clas);
            }
        }
    }
}

