/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.color;

import code.elix_x.excore.utils.color.HSBA;
import code.elix_x.excore.utils.color.IColor;
import net.minecraft.nbt.NBTTagCompound;

public class RGBA
implements IColor {
    public int r;
    public int g;
    public int b;
    public int a;

    private RGBA() {
    }

    public RGBA(int r, int g, int b, int a) {
        this.r = Math.max(Math.min(r, 255), 0);
        this.g = Math.max(Math.min(g, 255), 0);
        this.b = Math.max(Math.min(b, 255), 0);
        this.a = Math.max(Math.min(a, 255), 0);
    }

    public RGBA(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public RGBA(float r, float g, float b) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public RGBA(float r, float g, float b, float a) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public RGBA(int argb) {
        this(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF);
    }

    public int getRI() {
        return this.r;
    }

    public int getGI() {
        return this.g;
    }

    public int getBI() {
        return this.b;
    }

    public int getAI() {
        return this.a;
    }

    public void setRI(int r) {
        this.r = r;
    }

    public void setGI(int g) {
        this.g = g;
    }

    public void setBI(int b) {
        this.b = b;
    }

    public void setAI(int a) {
        this.a = a;
    }

    public float getRF() {
        return (float)this.r / 255.0f;
    }

    public float getGF() {
        return (float)this.g / 255.0f;
    }

    public float getBF() {
        return (float)this.b / 255.0f;
    }

    public float getAF() {
        return (float)this.a / 255.0f;
    }

    public void setRF(float r) {
        this.r = (int)(r * 255.0f);
    }

    public void setGF(float g) {
        this.g = (int)(g * 255.0f);
    }

    public void setBF(float b) {
        this.b = (int)(b * 255.0f);
    }

    public void setAF(float a) {
        this.a = (int)(a * 255.0f);
    }

    public RGBA add(RGBA rgba) {
        return new RGBA(this.getRF() + rgba.getRF(), this.getGF() + rgba.getGF(), this.getBF() + rgba.getBF(), this.getAF() + rgba.getAF());
    }

    public RGBA substract(RGBA rgba) {
        return new RGBA(this.getRF() - rgba.getRF(), this.getGF() - rgba.getGF(), this.getBF() - rgba.getBF(), this.getAF() - rgba.getAF());
    }

    public RGBA multiply(RGBA rgba) {
        return new RGBA(this.getRF() * rgba.getRF(), this.getGF() * rgba.getGF(), this.getBF() * rgba.getBF(), this.getAF() * rgba.getAF());
    }

    public RGBA divide(RGBA rgba) {
        return new RGBA(this.getRF() / rgba.getRF(), this.getGF() / rgba.getGF(), this.getBF() / rgba.getBF(), this.getAF() / rgba.getAF());
    }

    public int argb() {
        return this.a << 24 | this.r << 16 | this.g << 8 | this.b;
    }

    public int rgba() {
        return this.r << 24 | this.g << 16 | this.b << 8 | this.a;
    }

    @Override
    public RGBA toRGBA() {
        return this;
    }

    @Override
    public HSBA toHSBA() {
        float hue;
        int i1;
        int l;
        int n = l = this.r <= this.g ? this.g : this.r;
        if (this.b > l) {
            l = this.b;
        }
        int n2 = i1 = this.r >= this.g ? this.g : this.r;
        if (this.b < i1) {
            i1 = this.b;
        }
        float brightness = (float)l / 255.0f;
        float saturation = l != 0 ? (float)(l - i1) / (float)l : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float f3 = (float)(l - this.r) / (float)(l - i1);
            float f4 = (float)(l - this.g) / (float)(l - i1);
            float f5 = (float)(l - this.b) / (float)(l - i1);
            hue = this.r == l ? f5 - f4 : (this.g == l ? 2.0f + f3 - f5 : 4.0f + f4 - f3);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        return new HSBA(hue, saturation, brightness, this.a * 255);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("r", this.r);
        nbt.func_74768_a("g", this.g);
        nbt.func_74768_a("b", this.b);
        nbt.func_74768_a("a", this.a);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.r = nbt.func_74762_e("r");
        this.g = nbt.func_74762_e("g");
        this.b = nbt.func_74762_e("b");
        this.a = nbt.func_74762_e("a");
    }

    public static RGBA createFromNBT(NBTTagCompound nbt) {
        RGBA rgba = new RGBA();
        rgba.readFromNBT(nbt);
        return rgba;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + this.a;
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBA other = (RGBA)obj;
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        if (this.a != other.a) {
            return false;
        }
        return this.r == other.r;
    }

    public String toString() {
        return "RGBA{ " + this.r + ", " + this.g + ", " + this.b + ", " + this.a + "}";
    }
}

