/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.PositionedGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import org.lwjgl.util.Rectangle;

public abstract class RectangularGuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
extends PositionedGuiElement<H> {
    protected int width;
    protected int height;
    protected int borderX;
    protected int borderY;

    public RectangularGuiElement(String name, int xPos, int yPos, int width, int height, int borderX, int borderY) {
        super(name, xPos, yPos);
        this.width = width;
        this.height = height;
        this.borderX = borderX;
        this.borderY = borderY;
    }

    public int getWidth() {
        return this.borderX + this.width + this.borderX;
    }

    public int getHeight() {
        return this.borderY + this.height + this.borderY;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getBorderX() {
        return this.borderX;
    }

    public void setBorderX(int borderX) {
        this.borderX = borderX;
    }

    public int getBorderY() {
        return this.borderY;
    }

    public void setBorderY(int borderY) {
        this.borderY = borderY;
    }

    public int getRight() {
        return this.getXPos() + this.getWidth();
    }

    public int getBottom() {
        return this.getYPos() + this.getHeight();
    }

    public void centerX() {
        this.xPos = (RectangularGuiElement.screenWidth() - this.getWidth()) / 2;
    }

    public void centerY() {
        this.yPos = (RectangularGuiElement.screenHeight() - this.getHeight()) / 2;
    }

    public void center() {
        this.centerX();
        this.centerY();
    }

    public boolean inside(int x, int y) {
        return this.getXPos() <= x && x <= this.getRight() && this.getYPos() <= y && y <= this.getBottom();
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.getXPos(), this.getYPos(), this.getWidth(), this.getHeight());
    }

    public Rectangle toInnerRectangle() {
        return new Rectangle(this.getXPos() + this.getBorderX(), this.getYPos() + this.getBorderY(), this.getWidth() - this.getBorderX() * 2, this.getHeight() - this.getBorderY() * 2);
    }

    public void fill(RGBA color) {
        RectangularGuiElement.drawColoredRect(this.toRectangle(), color);
    }
}

