/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.RectangularGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import java.lang.reflect.Array;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.ArrayUtils;

public class ListGuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
extends RectangularGuiElement<H> {
    protected ListElement[] elements = (ListElement[])Array.newInstance(ListElement.class, 0);
    public int elementY;
    public RGBA backgroundColor;
    protected boolean inverted = false;
    protected int scrollDistance;
    protected int clickTimeThreshold = 250;
    protected int clickDistanceThreshold = 2;
    private long prevClickTime;
    private int prevGrabY = -1;
    private int prevGrabScrollDistance = -1;

    public ListGuiElement(String name, int xPos, int yPos, int width, int height, int elementY, int borderX, int borderY, RGBA backgroundColor) {
        super(name, xPos, yPos, width, height, borderX, borderY);
        this.elementY = elementY;
        this.backgroundColor = backgroundColor;
    }

    public ListGuiElement(String name, int xPos, int yPos, int width, int height, int elementY, int borderX, int borderY, RGBA backgroundColor, ListElement ... elements) {
        this(name, xPos, yPos, width, height, elementY, borderX, borderY, backgroundColor);
        this.elements = elements;
    }

    public ListGuiElement(String name, int xPos, int yPos, int width, int height, int elementY, int borderX, int borderY, RGBA backgroundColor, Iterable<ListElement> elements) {
        this(name, xPos, yPos, width, height, elementY, borderX, borderY, backgroundColor);
        for (ListElement element : elements) {
            this.elements = (ListElement[])ArrayUtils.add((Object[])this.elements, (Object)element);
        }
    }

    protected void reInitElements(int length) {
        this.elements = (ListElement[])Array.newInstance(ListElement.class, length);
    }

    protected void reInitElements() {
        this.reInitElements(0);
    }

    @Override
    public int getYPos() {
        return this.inverted ? super.getYPos() + this.borderY + this.elementY + this.borderY - this.getHeight() : super.getYPos();
    }

    public int getTotalHeight() {
        return this.borderY + this.elements.length * (this.elementY + this.borderY);
    }

    public int calcX() {
        return this.getXPos() + this.borderX;
    }

    public int calcRelY(int index) {
        return this.inverted ? this.getBottom() - (index + 1) * (this.elementY + this.borderY) - this.scrollDistance : this.getYPos() + this.borderY + index * (this.elementY + this.borderY) - this.scrollDistance;
    }

    public int maxScrollDistance() {
        return this.getTotalHeight() - this.getHeight();
    }

    public boolean scrollable() {
        return this.getTotalHeight() > this.getHeight();
    }

    public float getScrollMultiplier(boolean ctrl) {
        return ctrl ? 0.5f : 0.05f;
    }

    public void checkScrollDistance() {
        this.scrollDistance = this.inverted ? Math.min(Math.max(this.scrollDistance, -this.maxScrollDistance()), 0) : Math.max(Math.min(this.scrollDistance, this.maxScrollDistance()), 0);
    }

    public void setScrollDistance(int scrollDistance) {
        this.scrollDistance = scrollDistance;
        this.checkScrollDistance();
    }

    public void scroll(int distance) {
        this.scrollDistance += distance;
        this.checkScrollDistance();
    }

    public boolean grab(int mouseY) {
        return System.currentTimeMillis() - this.prevClickTime > (long)this.clickTimeThreshold || Math.abs(mouseY - this.prevGrabY) > this.clickDistanceThreshold;
    }

    public ListElement get(int i) {
        return this.elements[i];
    }

    public void set(ListElement element, int i) {
        this.elements[i] = element;
    }

    public void add(ListElement element) {
        this.elements = (ListElement[])ArrayUtils.add((Object[])this.elements, (Object)element);
    }

    public void add(ListElement element, int i) {
        this.elements = (ListElement[])ArrayUtils.add((Object[])this.elements, (int)i, (Object)element);
    }

    public void remove(int i) {
        this.elements = (ListElement[])ArrayUtils.remove((Object[])this.elements, (int)i);
    }

    public void remove(ListElement element) {
        this.elements = (ListElement[])ArrayUtils.removeElement((Object[])this.elements, (Object)element);
    }

    @Override
    public void openGui(H handler, GuiScreen gui) {
    }

    @Override
    public void initGui(H handler, GuiScreen gui) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].initGui(handler, gui, i, this.calcX(), this.calcRelY(i));
        }
    }

    @Override
    public void drawGuiPre(H handler, GuiScreen gui, int mouseX, int mouseY) {
        if (this.prevClickTime != -1L && this.grab(mouseY)) {
            this.setScrollDistance(this.prevGrabScrollDistance - (mouseY - this.prevGrabY));
        }
        ListGuiElement.scissorsPre();
        ListGuiElement.scisors(this.toRectangle());
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].drawGuiPre(handler, gui, i, this.calcX(), this.calcRelY(i), mouseX, mouseY);
        }
        ListGuiElement.scissorsPost();
    }

    @Override
    public void drawBackground(H handler, GuiScreen gui, int mouseX, int mouseY) {
        ListGuiElement.scissorsPre();
        ListGuiElement.scisors(this.toRectangle());
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].drawBackground(handler, gui, i, this.calcX(), this.calcRelY(i), mouseX, mouseY);
        }
        ListGuiElement.scissorsPost();
    }

    @Override
    public void drawGuiPost(H handler, GuiScreen gui, int mouseX, int mouseY) {
        ListGuiElement.scissorsPre();
        ListGuiElement.scisors(this.toRectangle());
        this.fill(this.backgroundColor);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].drawGuiPost(handler, gui, i, this.calcX(), this.calcRelY(i), mouseX, mouseY);
        }
        ListGuiElement.scissorsPost();
    }

    @Override
    public void drawGuiPostPost(H handler, GuiScreen gui, int mouseX, int mouseY) {
        ListGuiElement.scissorsPre();
        ListGuiElement.scisors(this.toRectangle());
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null) continue;
            this.elements[i].drawGuiPostPost(handler, gui, i, this.calcX(), this.calcRelY(i), mouseX, mouseY);
        }
        ListGuiElement.scissorsPost();
    }

    @Override
    public boolean handleKeyboardEvent(H handler, GuiScreen gui, boolean down, int key, char c) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null || !this.elements[i].handleKeyboardEvent(handler, gui, i, this.calcX(), this.calcRelY(i), down, key, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        return this.handleMousEventPre(handler, gui, mouseX, mouseY, down, key) || this.handleMouseEventPost(handler, gui, mouseX, mouseY, down, key);
    }

    protected boolean handleMousEventPre(H handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (key == 0) {
            if (down) {
                if (this.inside(mouseX, mouseY) && this.prevClickTime == -1L) {
                    this.prevClickTime = System.currentTimeMillis();
                    this.prevGrabY = mouseY;
                    this.prevGrabScrollDistance = this.scrollDistance;
                    return true;
                }
            } else if (this.prevClickTime != -1L) {
                if (this.grab(mouseY)) {
                    this.setScrollDistance(this.prevGrabScrollDistance - (mouseY - this.prevGrabY));
                    this.prevClickTime = -1L;
                    this.prevGrabY = -1;
                    this.prevGrabScrollDistance = -1;
                    return true;
                }
                this.prevClickTime = -1L;
                this.prevGrabY = -1;
                this.prevGrabScrollDistance = -1;
                return this.handleMouseEventPost(handler, gui, mouseX, mouseY, true, key);
            }
        }
        return false;
    }

    protected boolean handleMouseEventPost(H handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] == null || !this.elements[i].handleMouseEvent(handler, gui, i, this.calcX(), this.calcRelY(i), mouseX, mouseY, down, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, int dWheel) {
        if (this.scrollable() && this.inside(mouseX, mouseY)) {
            this.scroll((int)((float)(-dWheel) * this.getScrollMultiplier(gui.func_146271_m())));
            return true;
        }
        return false;
    }

    public class ListElement {
        public boolean inside(int relY, int x, int y) {
            return ListGuiElement.this.xPos + ListGuiElement.this.borderX <= x && x <= ListGuiElement.this.getRight() - ListGuiElement.this.borderX && relY <= y && y <= relY + ListGuiElement.this.elementY && ListGuiElement.this.getYPos() <= y && y <= ListGuiElement.this.getBottom();
        }

        public void initGui(H handler, GuiScreen gui, int index, int x, int relY) {
        }

        public void drawBackground(H handler, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
        }

        public void drawGuiPre(H handler, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
        }

        public void drawGuiPost(H handler, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
        }

        public void drawGuiPostPost(H handler, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
        }

        public boolean handleKeyboardEvent(H handler, GuiScreen gui, int index, int x, int relY, boolean down, int key, char c) {
            return false;
        }

        public boolean handleMouseEvent(H handler, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY, boolean down, int key) {
            return false;
        }
    }
}

