/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.RectangularGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class IncrementerGuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
extends RectangularGuiElement<H> {
    protected int numberWidth;
    protected int buttonsWidth;
    protected double step;
    protected double min;
    protected double max;
    protected double value;

    public IncrementerGuiElement(String name, int xPos, int yPos, int numberWidth, int buttonsWidth, int height, int borderX, int borderY, double step, double min, double max, double defaultValue) {
        super(name, xPos, yPos, numberWidth + buttonsWidth, height, borderX, borderY);
        this.numberWidth = numberWidth;
        this.buttonsWidth = buttonsWidth;
        this.step = step;
        this.min = min;
        this.max = max;
        this.value = defaultValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = Math.max(Math.min(value, this.max), this.min);
    }

    @Override
    public void openGui(H handler, GuiScreen gui) {
    }

    @Override
    public void initGui(H handler, GuiScreen gui) {
    }

    @Override
    public void drawGuiPre(H handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    @Override
    public void drawBackground(H handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    @Override
    public void drawGuiPost(H handler, GuiScreen gui, int mouseX, int mouseY) {
        IncrementerGuiElement.drawStringFull(gui.field_146297_k.field_71466_p, String.valueOf(this.getValue()), this.xPos + this.borderX, this.yPos + this.borderY + this.height - 8, new RGBA(1.0f, 1.0f, 1.0f, 1.0f));
        new GuiButtonExt(0, this.xPos + this.borderX + this.numberWidth, this.yPos + this.borderY, this.buttonsWidth, this.height / 2, "\u0432\u2013\u0406").func_146112_a(gui.field_146297_k, mouseX, mouseY);
        new GuiButtonExt(0, this.xPos + this.borderX + this.numberWidth, this.yPos + this.borderY + this.height / 2, this.buttonsWidth, this.height / 2, "\u0432\u2013\u0458").func_146112_a(gui.field_146297_k, mouseX, mouseY);
    }

    @Override
    public void drawGuiPostPost(H handler, GuiScreen gui, int mouseX, int mouseY) {
    }

    @Override
    public boolean handleKeyboardEvent(H handler, GuiScreen gui, boolean down, int key, char c) {
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (down && key == 0 && this.inside(mouseX, mouseY) && mouseX >= this.xPos + this.borderX + this.numberWidth) {
            if (mouseY < this.yPos + this.borderY + this.height / 2) {
                this.setValue(this.getValue() + this.step);
            } else {
                this.setValue(this.getValue() - this.step);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleMouseEvent(H handler, GuiScreen gui, int mouseX, int mouseY, int dWheel) {
        return false;
    }
}

