/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.gui.elements;

import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.render.ItemStackRenderer;
import code.elix_x.excore.utils.color.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public abstract class GuiElement<H extends IGuiElementsHandler<? extends IGuiElement<H>>>
implements IGuiElement<H> {
    protected String name;

    public GuiElement(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ScaledResolution screenResolution() {
        return new ScaledResolution(Minecraft.func_71410_x());
    }

    public static int screenWidth() {
        return GuiElement.screenResolution().func_78326_a();
    }

    public static int screenHeight() {
        return GuiElement.screenResolution().func_78328_b();
    }

    public static int toLocal(int screen) {
        return screen / GuiElement.screenResolution().func_78325_e();
    }

    public static int toScreen(int local) {
        return local * GuiElement.screenResolution().func_78325_e();
    }

    public static Rectangle screen() {
        return new Rectangle(0, 0, GuiElement.screenWidth(), GuiElement.screenHeight());
    }

    public static int mouseX() {
        return GuiElement.toLocal(Mouse.getX());
    }

    public static int mouseY() {
        return GuiElement.screenHeight() - GuiElement.toLocal(Mouse.getY()) - 1;
    }

    public static Rectangle cursor(int mouseX, int mouseY) {
        return new Rectangle(mouseX, mouseY, 8, 8);
    }

    public static int right(Rectangle element) {
        return element.getX() + element.getWidth();
    }

    public static int bottom(Rectangle element) {
        return element.getY() + element.getHeight();
    }

    public static Rectangle smartPos(Rectangle screen, Rectangle element) {
        if (element.getWidth() > screen.getWidth() || element.getHeight() > screen.getHeight()) {
            throw new IllegalArgumentException("Element larger than screen");
        }
        if (element.getX() < screen.getX()) {
            element.setX(screen.getX());
        }
        if (element.getY() < screen.getY()) {
            element.setY(screen.getY());
        }
        if (GuiElement.right(element) > GuiElement.right(screen)) {
            element.setX(GuiElement.right(screen) - element.getWidth());
        }
        if (GuiElement.bottom(element) > GuiElement.bottom(screen)) {
            element.setY(GuiElement.bottom(screen) - element.getHeight());
        }
        return element;
    }

    public static Rectangle smartPos(Rectangle screen, Rectangle cursor, Rectangle element, boolean alignLeft, boolean alignTop) {
        if ((element = GuiElement.smartPos(screen, element)).intersects((ReadableRectangle)cursor)) {
            if (GuiElement.right(element) > cursor.getX() && element.getX() < GuiElement.right(cursor)) {
                if (cursor.getX() - screen.getX() < element.getWidth()) {
                    alignLeft = false;
                }
                if (GuiElement.right(screen) - GuiElement.right(cursor) < element.getWidth()) {
                    alignLeft = true;
                }
                if (alignLeft) {
                    element.setX(cursor.getX() - element.getWidth());
                } else {
                    element.setX(GuiElement.right(cursor));
                }
            }
            if (GuiElement.bottom(element) > cursor.getY() && element.getY() < GuiElement.bottom(cursor)) {
                if (cursor.getY() - screen.getY() < element.getHeight()) {
                    alignTop = false;
                }
                if (GuiElement.bottom(screen) - GuiElement.bottom(cursor) < element.getHeight()) {
                    alignTop = true;
                }
                if (alignTop) {
                    element.setY(cursor.getY() - element.getHeight());
                } else {
                    element.setY(GuiElement.bottom(cursor));
                }
            }
        }
        return element;
    }

    public static void drawColoredRect(Rectangle element, RGBA color, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)color.getRF(), (float)color.getGF(), (float)color.getBF(), (float)color.getAF());
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b((double)element.getX(), (double)GuiElement.bottom(element), zLevel).func_181675_d();
        vertexbuffer.func_181662_b((double)GuiElement.right(element), (double)GuiElement.bottom(element), zLevel).func_181675_d();
        vertexbuffer.func_181662_b((double)GuiElement.right(element), (double)element.getY(), zLevel).func_181675_d();
        vertexbuffer.func_181662_b((double)element.getX(), (double)element.getY(), zLevel).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawColoredRect(Rectangle element, RGBA color) {
        GuiElement.drawColoredRect(element, color, 0.0);
    }

    public static void drawTexturedRect(Rectangle element, Vec2f tl, Vec2f br, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)element.getX(), (double)GuiElement.bottom(element), zLevel).func_187315_a((double)tl.field_189982_i, (double)br.field_189983_j).func_181675_d();
        vertexbuffer.func_181662_b((double)GuiElement.right(element), (double)GuiElement.bottom(element), zLevel).func_187315_a((double)br.field_189982_i, (double)br.field_189983_j).func_181675_d();
        vertexbuffer.func_181662_b((double)GuiElement.right(element), (double)element.getY(), zLevel).func_187315_a((double)br.field_189982_i, (double)tl.field_189983_j).func_181675_d();
        vertexbuffer.func_181662_b((double)element.getX(), (double)element.getY(), zLevel).func_187315_a((double)tl.field_189982_i, (double)tl.field_189983_j).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRect(Rectangle element, Vec2f tl, Vec2f br) {
        GuiElement.drawTexturedRect(element, tl, br, 0.0);
    }

    public static void drawTexturedRect(Rectangle element, Rectangle texture, int textureWidth, int textureHeight, double zLevel) {
        float uScale = 1.0f / (float)textureWidth;
        float vScale = 1.0f / (float)textureHeight;
        GuiElement.drawTexturedRect(element, new Vec2f((float)texture.getX() * uScale, (float)texture.getY() * vScale), new Vec2f((float)GuiElement.right(texture) * uScale, (float)GuiElement.bottom(texture) * vScale), zLevel);
    }

    public static void drawTexturedRect(Rectangle element, Rectangle texture, int textureWidth, int textureHeight) {
        GuiElement.drawTexturedRect(element, texture, textureWidth, textureHeight, 0.0);
    }

    public static void scissorsPre() {
        GL11.glEnable((int)3089);
    }

    public static void scisors(Rectangle element) {
        GL11.glScissor((int)GuiElement.toScreen(element.getX()), (int)GuiElement.toScreen(GuiElement.screenHeight() - element.getY() - element.getHeight()), (int)GuiElement.toScreen(element.getWidth()), (int)GuiElement.toScreen(element.getHeight()));
    }

    public static void scissorsPost() {
        GL11.glDisable((int)3089);
    }

    public static void drawStringPre() {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    public static void drawString(FontRenderer font, String text, int x, int y, RGBA color) {
        font.func_175063_a(text, (float)x, (float)y, color.argb());
    }

    public static void drawStringPost() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }

    public static void drawStringFull(FontRenderer font, String text, int x, int y, RGBA color) {
        GuiElement.drawStringPre();
        GuiElement.drawString(font, text, x, y, color);
        GuiElement.drawStringPost();
    }

    public static void renderItemStackPre() {
        RenderHelper.func_74520_c();
    }

    public static void renderItemStack(ItemStack itemstack, int x, int y) {
        ItemStackRenderer.renderItemStack(Minecraft.func_71410_x(), x, y, itemstack);
    }

    public static void renderItemStackPost() {
        RenderHelper.func_74518_a();
    }

    public static void renderItemStackFull(ItemStack itemstack, int x, int y) {
        GuiElement.renderItemStackPre();
        GuiElement.renderItemStack(itemstack, x, y);
        GuiElement.renderItemStackPost();
    }

    public static int maxWidth(FontRenderer font, String ... ss) {
        int max = 0;
        for (String s : ss) {
            max = Math.max(max, font.func_78256_a(s));
        }
        return max;
    }

    public static String[] translate(String ... strings) {
        String[] trans = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            trans[i] = I18n.func_74838_a((String)strings[i]);
        }
        return trans;
    }

    public static void drawStandartTooltipBackground(Rectangle element) {
        int zLevel = 300;
        int backgroundColor = -267386864;
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 3), (int)(element.getY() - 4), (int)(GuiElement.right(element) + 3), (int)(element.getY() - 3), (int)-267386864, (int)-267386864);
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 3), (int)(GuiElement.bottom(element) + 3), (int)(GuiElement.right(element) + 3), (int)(GuiElement.bottom(element) + 4), (int)-267386864, (int)-267386864);
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 3), (int)(element.getY() - 3), (int)(GuiElement.right(element) + 3), (int)(GuiElement.bottom(element) + 3), (int)-267386864, (int)-267386864);
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 4), (int)(element.getY() - 3), (int)(element.getX() - 3), (int)(GuiElement.bottom(element) + 3), (int)-267386864, (int)-267386864);
        GuiUtils.drawGradientRect((int)300, (int)(GuiElement.right(element) + 3), (int)(element.getY() - 3), (int)(GuiElement.right(element) + 4), (int)(GuiElement.bottom(element) + 3), (int)-267386864, (int)-267386864);
        int borderColorStart = 0x505000FF;
        int borderColorEnd = 1344798847;
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 3), (int)(element.getY() - 3 + 1), (int)(element.getX() - 3 + 1), (int)(GuiElement.bottom(element) + 3 - 1), (int)0x505000FF, (int)1344798847);
        GuiUtils.drawGradientRect((int)300, (int)(GuiElement.right(element) + 2), (int)(element.getY() - 3 + 1), (int)(GuiElement.right(element) + 3), (int)(GuiElement.bottom(element) + 3 - 1), (int)0x505000FF, (int)1344798847);
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 3), (int)(element.getY() - 3), (int)(GuiElement.right(element) + 3), (int)(element.getY() - 3 + 1), (int)0x505000FF, (int)0x505000FF);
        GuiUtils.drawGradientRect((int)300, (int)(element.getX() - 3), (int)(GuiElement.bottom(element) + 2), (int)(GuiElement.right(element) + 3), (int)(GuiElement.bottom(element) + 3), (int)1344798847, (int)1344798847);
    }

    public static void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, boolean background, boolean translate, String ... tooltips) {
        if (translate) {
            tooltips = GuiElement.translate(tooltips);
        }
        Rectangle tooltip = GuiElement.smartPos(GuiElement.screen(), GuiElement.cursor(mouseX, mouseY), new Rectangle(mouseX, mouseY, GuiElement.maxWidth(font, tooltips), tooltips.length * (8 + verticalTextSpace) - verticalTextSpace), alignLeft, alignTop);
        if (background) {
            GuiElement.drawStandartTooltipBackground(tooltip);
        }
        GuiElement.drawStringPre();
        for (int i = 0; i < tooltips.length; ++i) {
            GuiElement.drawString(font, tooltips[i], tooltip.getX(), tooltip.getY() + i * (8 + verticalTextSpace), textColor);
        }
        GuiElement.drawStringPost();
    }

    public static void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, false, false, tooltips);
    }

    public static void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public static void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltip(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, false, true, tooltips);
    }

    public static void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltipTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public static void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        GuiElement.drawTooltipTranslate(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltipTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        GuiElement.drawTooltipTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, true, false, tooltips);
    }

    public static void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltipWithBackground(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public static void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        GuiElement.drawTooltipWithBackground(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltipWithBackground(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        GuiElement.drawTooltipWithBackground(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltip(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, textColor, true, true, tooltips);
    }

    public static void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, RGBA textColor, String ... tooltips) {
        GuiElement.drawTooltipWithBackgroundTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, textColor, tooltips);
    }

    public static void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, int verticalTextSpace, String ... tooltips) {
        GuiElement.drawTooltipWithBackgroundTranslate(font, mouseX, mouseY, alignLeft, alignTop, verticalTextSpace, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }

    public static void drawTooltipWithBackgroundTranslate(FontRenderer font, int mouseX, int mouseY, boolean alignLeft, boolean alignTop, String ... tooltips) {
        GuiElement.drawTooltipWithBackgroundTranslate(font, mouseX, mouseY, alignLeft, alignTop, 2, new RGBA(1.0f, 1.0f, 1.0f, 1.0f), tooltips);
    }
}

