/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.client.thingy;

import code.elix_x.excore.utils.color.RGBA;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import jline.internal.InputStreamReader;
import net.minecraft.util.text.ITextComponent;

public class ThingyData {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).create();
    List<Human> humans;
    Map<String, HumanCategory> humanCategories;
    Map<String, URL> linkIcons;

    public static ThingyData read(URL url) throws IOException {
        return (ThingyData)gson.fromJson((Reader)new InputStreamReader(url.openStream()), ThingyData.class);
    }

    public String toString() {
        return "ThingyData [humans=" + this.humans + ", humanCategories=" + this.humanCategories + ", linkIcons=" + this.linkIcons + "]";
    }

    public class HumanCategory {
        String name;
        boolean glint;
        RGBA color;

        public String toString() {
            return "HumanCategory [name=" + this.name + ", glint=" + this.glint + ", color=" + this.color + "]";
        }
    }

    public class Human {
        String name;
        String category;
        List<ITextComponent> bio;
        URL icon;
        List<Link> links;

        HumanCategory getCategory(ThingyData data) {
            return data.humanCategories.get(this.category);
        }

        public String toString() {
            return "Human [name=" + this.name + ", category=" + this.category + ", bio=" + this.bio + ", icon=" + this.icon + ", links=" + this.links + "]";
        }

        public class Link {
            URL url;
            String icon;

            URL getIcon(ThingyData data) {
                return data.linkIcons.get(this.icon);
            }

            public String toString() {
                return "Link [url=" + this.url + ", icon=" + this.icon + "]";
            }
        }
    }
}

