/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.d3core.client;

import java.util.LinkedHashMap;
import java.util.Map;
import net.doubledoordev.d3core.events.D3LanguageInjectEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LanguageHelper {
    private static final LinkedHashMap<String, Integer> ROMAN_NUMERALS = new LinkedHashMap();
    public static final LanguageHelper I = new LanguageHelper();
    private static final String PREFIX = "enchantment.level.";

    public static void run() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                D3LanguageInjectEvent event = new D3LanguageInjectEvent();
                MinecraftForge.EVENT_BUS.post((Event)event);
                LanguageMap.func_135063_a(event.map);
            }
        });
    }

    private static String romanNumerals(int Int) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Integer> entry : ROMAN_NUMERALS.entrySet()) {
            int matches = Int / entry.getValue();
            String s = entry.getKey();
            for (int i = 0; i < matches; ++i) {
                builder.append(s);
            }
            Int %= entry.getValue().intValue();
        }
        return builder.toString();
    }

    @SubscribeEvent
    public void d3LanguageInjectEvent(D3LanguageInjectEvent event) {
        Enchantment enchantment = null;
        int i = 0;
        while (enchantment == null) {
            enchantment = (Enchantment)Enchantment.field_185264_b.func_148754_a(i++);
        }
        Item item = null;
        int i2 = 0;
        while (item == null) {
            item = (Item)Item.field_150901_e.func_148754_a(i2++);
        }
        ItemStack s = new ItemStack(item);
        s.func_77966_a(enchantment, Integer.MAX_VALUE);
        int max = EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)s);
        for (int i3 = 0; i3 < max; ++i3) {
            String key = PREFIX + i3;
            if (event.map.containsKey(key)) continue;
            String val = LanguageHelper.romanNumerals(i3);
            event.map.put(key, val);
        }
    }

    static {
        ROMAN_NUMERALS.put("M", 1000);
        ROMAN_NUMERALS.put("CM", 900);
        ROMAN_NUMERALS.put("D", 500);
        ROMAN_NUMERALS.put("CD", 400);
        ROMAN_NUMERALS.put("C", 100);
        ROMAN_NUMERALS.put("XC", 90);
        ROMAN_NUMERALS.put("L", 50);
        ROMAN_NUMERALS.put("XL", 40);
        ROMAN_NUMERALS.put("X", 10);
        ROMAN_NUMERALS.put("IX", 9);
        ROMAN_NUMERALS.put("V", 5);
        ROMAN_NUMERALS.put("IV", 4);
        ROMAN_NUMERALS.put("I", 1);
    }
}

