/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.forestry.capability.tesla;

import forestry.core.tiles.TileEngine;
import forestry.energy.tiles.TileEngineBiogas;
import forestry.energy.tiles.TileEngineClockwork;
import forestry.energy.tiles.TileEngineElectric;
import forestry.energy.tiles.TileEnginePeat;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.modcompat.forestry.capability.tesla.HolderTileEngine;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultSidedCapabilityProvider;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.SimpleCapabilityConstructor;

public class ForestryTeslaIntegration {
    public static void load() {
        CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
        ForestryTeslaIntegration.registerTileEngineTeslaHolder(registry, TileEngineBiogas.class);
        ForestryTeslaIntegration.registerTileEngineTeslaHolder(registry, TileEngineClockwork.class);
        ForestryTeslaIntegration.registerTileEngineTeslaHolder(registry, TileEngineElectric.class);
        ForestryTeslaIntegration.registerTileEngineTeslaHolder(registry, TileEnginePeat.class);
    }

    protected static <T extends TileEngine> void registerTileEngineTeslaHolder(CapabilityConstructorRegistry registry, Class<T> clazz) {
        registry.registerTile(clazz, (ICapabilityConstructor)new SimpleCapabilityConstructor<ITeslaHolder, T>(){

            public Capability<ITeslaHolder> getCapability() {
                return TeslaCapabilities.CAPABILITY_HOLDER;
            }

            @Nullable
            public ICapabilityProvider createProvider(final TileEngine host) {
                return new DefaultSidedCapabilityProvider(DefaultSidedCapabilityProvider.forAllSides((Capability)TeslaCapabilities.CAPABILITY_HOLDER, (DefaultSidedCapabilityProvider.ISidedCapabilityConstructor)new DefaultSidedCapabilityProvider.ISidedCapabilityConstructor<ITeslaHolder>(){

                    public ITeslaHolder createForSide(EnumFacing side) {
                        return new HolderTileEngine(side, host);
                    }
                }));
            }
        });
    }
}

