/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.valkyrielib.gui.client.elements;

import com.valkyrieofnight.valkyrielib.gui.client.VLGuiContainer;
import com.valkyrieofnight.valkyrielib.gui.client.elements.VLElement;
import java.util.ArrayList;
import java.util.List;

public class VLElementIndex
extends VLElement {
    private int currentIDTotal;
    private int xOffset;
    private int yOffset;
    protected List<VLElement> elements = new ArrayList<VLElement>();
    private String currentElementAddress;
    private VLElement currentElement;
    private int currentElementID;

    public VLElementIndex(VLGuiContainer gui, int xOffset, int yOffset) {
        super(gui);
        this.init(xOffset, yOffset);
    }

    public VLElementIndex(String elementAddress, VLGuiContainer gui, int xOffset, int yOffset) {
        super(elementAddress, gui);
        this.init(xOffset, yOffset);
    }

    private void init(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void addIndex(VLElement ele) {
        if (ele == null) {
            return;
        }
        if (!this.hasIndex(this.elementAddress)) {
            this.elements.add(ele);
            ele.setID(this.currentIDTotal++);
        }
        if (this.currentElementAddress == null) {
            this.currentElementAddress = this.elementAddress;
            this.currentElement = this.getElement(this.currentElementAddress);
        }
    }

    public boolean setIndex(String elementAddress) {
        for (int i = 0; i < this.elements.size(); ++i) {
            VLElement ele = this.elements.get(i);
            if (ele == null || !ele.elementAddress.equals(elementAddress)) continue;
            this.currentElementAddress = elementAddress;
            this.currentElement = ele;
            this.currentElementID = i;
            return true;
        }
        return false;
    }

    public boolean setIndex(int index) {
        if (index < this.elements.size() && index >= 0) {
            this.currentElement = this.elements.get(index);
            this.currentElementAddress = this.currentElement != null ? this.currentElement.elementAddress : "";
            this.currentElementID = index;
            return this.currentElement != null;
        }
        return false;
    }

    public String getNextIndex() {
        int prev = this.currentElementID + 1;
        if (prev < this.elements.size()) {
            return this.elements.get((int)prev).elementAddress;
        }
        return this.elements.get((int)0).elementAddress;
    }

    public String getPrevIndex() {
        int prev = this.currentElementID - 1;
        if (prev >= 0) {
            return this.elements.get((int)prev).elementAddress;
        }
        return this.elements.get((int)(this.elements.size() - 1)).elementAddress;
    }

    public boolean hasNextIndex() {
        return this.elements.size() - 1 > this.currentElementID;
    }

    public boolean hasPrevIndex() {
        return 0 < this.currentElementID;
    }

    public boolean hasIndex(String elementAddress) {
        if (elementAddress == null) {
            return false;
        }
        for (VLElement ele : this.elements) {
            if (!elementAddress.equals(ele.elementAddress)) continue;
            return true;
        }
        return false;
    }

    protected VLElement getElement(String elementAddress) {
        for (VLElement ele : this.elements) {
            if (!ele.elementAddress.equals(elementAddress)) continue;
            return ele;
        }
        return null;
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.currentElement != null) {
            this.currentElement.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY, guiLeft + this.xOffset, guiTop + this.yOffset);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.currentElement != null) {
            this.currentElement.drawGuiContainerForegroundLayer(mouseX, mouseY);
        }
    }

    @Override
    public void updateScreen() {
        if (this.currentElement != null) {
            this.currentElement.updateScreen();
        }
    }

    @Override
    public boolean onMouseClick(int guiLeft, int guiTop, int mouseX, int mouseY, int mouseButton) {
        if (this.currentElement != null && this.currentElement.onMouseClick(guiLeft + this.xOffset, guiTop + this.yOffset, mouseX, mouseY, mouseButton)) {
            this.currentElement.playPressSound(this.gui.field_146297_k.func_147118_V());
            this.gui.mouseClicked(this.currentElement);
        }
        return false;
    }

    @Override
    public boolean drawToolTipAt(int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.currentElement != null) {
            this.currentElement.drawToolTipAt(mouseX, mouseY, guiLeft + this.xOffset, guiTop + this.yOffset);
        }
        return false;
    }

    public int getTotalIndices() {
        return this.elements != null ? this.elements.size() : 0;
    }

    public int getCurrentIndexNum() {
        return this.currentElementID;
    }
}

