/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.tileentity;

import cubex2.sensorcraft.SensorCraft;
import cubex2.sensorcraft.Util;
import cubex2.sensorcraft.api.ISensorModule;
import cubex2.sensorcraft.block.Sensor;
import cubex2.sensorcraft.inventory.InventorySensor;
import cubex2.sensorcraft.item.Modifier;
import cubex2.sensorcraft.network.PacketUpdatePower;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySensor
extends TileEntity
implements InventorySensor,
ITickable {
    private ItemStack[] stacks = new ItemStack[28];
    private int[] power = new int[6];
    private int scanRate = 1;
    private int scanCounter = 0;

    public int getPower(EnumFacing side) {
        if (side.ordinal() >= this.power.length) {
            return 0;
        }
        return this.power[side.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public void setPower(int side, int value) {
        if (side >= this.power.length) {
            return;
        }
        this.power[side] = value;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    @Override
    public List<ItemStack> getModifiersFor(int module) {
        return Util.getModifiersFor(this, module, 6, 4);
    }

    @Override
    public int getPower(ISensorModule module, ItemStack stack, List<ItemStack> modifiers) {
        return module.getBlockPower(this.func_145831_w(), this.func_174877_v(), stack, modifiers);
    }

    public int getNumModules() {
        return Sensor.byDamage(this.func_145832_p()).getNumModules();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.stacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.stacks.length) continue;
            this.stacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.scanRate = compound.func_74762_e("ScanRate");
        this.scanCounter = compound.func_74762_e("ScanCounter");
        this.power = compound.func_74759_k("Power");
        if (this.power.length != 6) {
            this.power = new int[6];
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stacks.length; ++i) {
            if (this.stacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.stacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
        compound.func_74768_a("ScanRate", this.scanRate);
        compound.func_74768_a("ScanCounter", this.scanCounter);
        compound.func_74783_a("Power", this.power);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.power = nbt.func_74759_k("Power");
        if (this.func_145830_o()) {
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h);
        }
    }

    public int func_70302_i_() {
        return this.stacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.stacks[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.stacks[index] != null) {
            if (this.stacks[index].field_77994_a <= count) {
                ItemStack itemstack1 = this.stacks[index];
                this.stacks[index] = null;
                return itemstack1;
            }
            ItemStack itemstack = this.stacks[index].func_77979_a(count);
            if (this.stacks[index].field_77994_a == 0) {
                this.stacks[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.stacks[index] != null) {
            ItemStack itemstack = this.stacks[index];
            this.stacks[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        Arrays.fill(this.stacks, null);
    }

    public String func_70005_c_() {
        return "container.sensor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.scanCounter-- <= 0) {
            this.scanCounter = this.scanRate;
            int[] prevPower = (int[])this.power.clone();
            this.updatePower();
            boolean changed = false;
            for (int i = 0; i < this.power.length; ++i) {
                if (this.power[i] == prevPower[i]) continue;
                SensorCraft.network.sendToAllAround((IMessage)new PacketUpdatePower(this.field_174879_c, i, this.power[i]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
                changed = true;
            }
            if (changed) {
                this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
            }
        }
    }

    private void updatePower() {
        int i;
        int[] modulePower = new int[4];
        for (i = 0; i < modulePower.length; ++i) {
            modulePower[i] = Util.calculatePower(this, i);
        }
        for (i = 0; i < this.power.length; ++i) {
            EnumFacing side = EnumFacing.values()[i];
            this.power[i] = this.calculatePower(side, modulePower);
        }
    }

    private int calculatePower(EnumFacing side, int[] modulePowers) {
        int power = 0;
        for (int i = 0; i < 4; ++i) {
            int modulePower;
            List<ItemStack> modifiers;
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || !this.isValidSide(side, modifiers = this.getModifiersFor(i)) || (modulePower = modulePowers[i]) <= power) continue;
            power = modulePower;
        }
        return power;
    }

    private boolean isValidSide(EnumFacing side, List<ItemStack> modifiers) {
        for (Modifier mod : Modifier.fromStacks(modifiers)) {
            if (!(mod == Modifier.OUTPUT_TOP ? side == EnumFacing.UP : (mod == Modifier.OUTPUT_BOTTOM ? side == EnumFacing.DOWN : mod == Modifier.OUTPUT_SIDES && side.func_176740_k().func_176722_c()))) continue;
            return false;
        }
        return true;
    }
}

