/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.proxy;

import cubex2.cxlibrary.gui.GuiCX;
import cubex2.cxlibrary.gui.control.Screen;
import cubex2.sensorcraft.SensorCraft;
import cubex2.sensorcraft.Util;
import cubex2.sensorcraft.block.BlockSensor;
import cubex2.sensorcraft.block.Sensor;
import cubex2.sensorcraft.client.ModelLoaderSC;
import cubex2.sensorcraft.gui.GuiBlacklist;
import cubex2.sensorcraft.gui.GuiMobileSensor;
import cubex2.sensorcraft.gui.GuiOutputOffset;
import cubex2.sensorcraft.gui.GuiSensor;
import cubex2.sensorcraft.inventory.ContainerBlockBlackList;
import cubex2.sensorcraft.inventory.ContainerItemBlackList;
import cubex2.sensorcraft.inventory.InventoryBlockBlackList;
import cubex2.sensorcraft.inventory.InventoryItemBlackList;
import cubex2.sensorcraft.inventory.InventoryMobileSensor;
import cubex2.sensorcraft.item.Material;
import cubex2.sensorcraft.item.Modifier;
import cubex2.sensorcraft.item.Module;
import cubex2.sensorcraft.proxy.CommonProxy;
import cubex2.sensorcraft.tileentity.TileEntitySensor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.FMLClientHandler;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                Sensor sensor = (Sensor)((Object)iBlockState.func_177229_b(BlockSensor.VARIANT));
                return new ModelResourceLocation("sensorcraft:sensor", "variant=" + sensor.getUnlocalizedName());
            }
        };
        ModelLoader.setCustomStateMapper((Block)SensorCraft.sensor, (IStateMapper)ignoreState);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderSC());
    }

    @Override
    public void registerRenderInformation() {
        int i;
        Item item = Item.func_150898_a((Block)SensorCraft.sensor);
        for (i = 0; i < Sensor.values().length; ++i) {
            Sensor sensor = Sensor.values()[i];
            this.registerModels(item, "sensor", sensor.getUnlocalizedName(), i);
        }
        item = SensorCraft.module;
        for (i = 0; i < Module.values().length; ++i) {
            Module module = Module.values()[i];
            this.registerModels(item, "module", module.getUnlocalizedName(), i);
        }
        item = SensorCraft.modifier;
        for (i = 0; i < Modifier.values().length; ++i) {
            Modifier modifier = Modifier.values()[i];
            this.registerModels(item, "modifier", modifier.getUnlocalizedName(), i);
        }
        item = SensorCraft.mobileSensor;
        for (i = 0; i < 16; ++i) {
            this.registerModels(item, "mobile_sensor", String.valueOf(i), i);
        }
        item = SensorCraft.material;
        for (Material material : Material.values()) {
            this.registerModels(item, "material", material.getUnlocalizedName(), material.ordinal());
        }
    }

    private void registerModels(Item item, String prefix, String postfix, int meta) {
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        String location = String.format("sensorcraft:%s_%s", prefix, postfix);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(location)});
        ModelResourceLocation l = new ModelResourceLocation(location, "inventory");
        mesher.func_178086_a(item, meta, l);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 0) {
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (te != null && te instanceof TileEntitySensor) {
                TileEntitySensor sensor = (TileEntitySensor)te;
                return new GuiCX((Screen)new GuiSensor(player.field_71071_by, sensor, sensor.getNumModules()));
            }
        } else {
            if (ID == 1) {
                EnumHand hand = x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                ItemStack stack = player.func_184586_b(hand);
                int slot = Util.getSlotFromHand(player, hand);
                return new GuiCX((Screen)new GuiMobileSensor(player.field_71071_by, new InventoryMobileSensor(stack, player, slot)));
            }
            if (ID >= 2 && ID <= 5) {
                EnumHand hand = x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                ItemStack stack = player.func_184586_b(hand);
                int slot = Util.getSlotFromHand(player, hand);
                int num = ID - 2 + 1;
                InventoryBlockBlackList invBlackList = new InventoryBlockBlackList(stack, player, slot, num);
                return new GuiCX((Screen)new GuiBlacklist((Container)new ContainerBlockBlackList(player.field_71071_by, invBlackList), invBlackList));
            }
            if (ID >= 6 && ID <= 9) {
                EnumHand hand = x == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
                ItemStack stack = player.func_184586_b(hand);
                int slot = Util.getSlotFromHand(player, hand);
                int num = ID - 6 + 1;
                InventoryItemBlackList invBlackList = new InventoryItemBlackList(stack, player, slot, num);
                return new GuiCX((Screen)new GuiBlacklist((Container)new ContainerItemBlackList(player.field_71071_by, invBlackList), invBlackList));
            }
        }
        return null;
    }

    @Override
    public void openClientOnlyGui(int ID, ItemStack stack, EntityPlayer player, EnumHand hand) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ID == 0) {
            mc.func_147108_a((GuiScreen)new GuiCX((Screen)new GuiOutputOffset(stack, Util.getSlotFromHand(player, hand))));
        }
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getWorldClient();
    }
}

