/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.module;

import cubex2.sensorcraft.Util;
import cubex2.sensorcraft.api.ISensorModule;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ModuleEntityDetector<T extends Entity>
implements ISensorModule {
    private final Class<T> clazz;

    protected ModuleEntityDetector(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public int getBlockPower(World world, BlockPos pos, ItemStack stack, List<ItemStack> modifiers) {
        return this.getNumEntities(world, pos, modifiers);
    }

    @Override
    public int getMobilePower(World world, EntityPlayer player, ItemStack stack, List<ItemStack> modifiers) {
        return this.getNumEntities(world, player.func_180425_c(), modifiers);
    }

    private int getNumEntities(World world, BlockPos pos, List<ItemStack> modifiers) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        double range = 1 + Util.getTotalRangeUpgrade(modifiers);
        AxisAlignedBB bounds = new AxisAlignedBB((double)x - range, (double)y - range, (double)z - range, (double)(x + 1) + range, (double)(y + 1) + range, (double)(z + 1) + range);
        List entities = world.func_72872_a(this.clazz, bounds);
        for (int i = 0; i < entities.size(); ++i) {
            if (this.isValidEntity((Entity)entities.get(i), modifiers)) continue;
            entities.remove(i--);
        }
        return entities.size();
    }

    protected boolean isValidEntity(T entity, List<ItemStack> modifiers) {
        return true;
    }
}

