/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.module;

import cubex2.sensorcraft.Util;
import cubex2.sensorcraft.api.ISensorModule;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class ModuleBlockBase
implements ISensorModule {
    @Override
    public int getBlockPower(World world, BlockPos pos, ItemStack stack, List<ItemStack> modifiers) {
        return this.getNumBlocks(world, pos, modifiers);
    }

    @Override
    public int getMobilePower(World world, EntityPlayer player, ItemStack stack, List<ItemStack> modifiers) {
        return this.getNumBlocks(world, player.func_180425_c(), modifiers);
    }

    private int getNumBlocks(World world, BlockPos position, List<ItemStack> modifiers) {
        int range = 1 + Util.getTotalRangeUpgrade(modifiers);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int numBlocks = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    pos.func_181079_c(position.func_177958_n() + x, position.func_177956_o() + y, position.func_177952_p() + z);
                    IBlockState state = world.func_180495_p((BlockPos)pos);
                    Block block = world.func_180495_p((BlockPos)pos).func_177230_c();
                    if (block.isAir(state, (IBlockAccess)world, (BlockPos)pos) || !this.isValidBlock(world, pos.func_185334_h(), state, modifiers)) continue;
                    ++numBlocks;
                }
            }
        }
        return numBlocks;
    }

    protected abstract boolean isValidBlock(World var1, BlockPos var2, IBlockState var3, List<ItemStack> var4);
}

