/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.item;

import com.google.common.collect.Lists;
import cubex2.sensorcraft.SensorCraft;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;

public enum Modifier {
    OUTPUT_TOP("output_top"),
    OUTPUT_BOTTOM("output_bottom"),
    OUTPUT_SIDES("output_sides"),
    OUTPUT_INVERT("output_invert"),
    OUTPUT_DIGITAL("output_digital"),
    OUTPUT_OFFSET("output_offset"),
    RANGE1("range1"),
    RANGE2("range2"),
    RANGE4("range4"),
    RANGE8("range8"),
    BLOCK_BLACKLIST1("block_blacklist1"),
    BLOCK_BLACKLIST2("block_blacklist2"),
    BLOCK_BLACKLIST3("block_blacklist3"),
    BLOCK_BLACKLIST4("block_blacklist4"),
    ITEM_BLACKLIST1("item_blacklist1"),
    ITEM_BLACKLIST2("item_blacklist2"),
    ITEM_BLACKLIST3("item_blacklist3"),
    ITEM_BLACKLIST4("item_blacklist4");

    private final String unlocalizedName;

    private Modifier(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
    }

    public static Modifier byDamage(int damage) {
        if (damage < 0 || damage >= Modifier.values().length) {
            damage = 0;
        }
        return Modifier.values()[damage];
    }

    public static boolean isModifier(ItemStack stack, Modifier modifier) {
        return stack != null && stack.func_77973_b() == SensorCraft.modifier && Modifier.byDamage(stack.func_77960_j()) == modifier;
    }

    public static boolean isBlockBlackList(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != SensorCraft.modifier) {
            return false;
        }
        Modifier mod = Modifier.byDamage(stack.func_77960_j());
        return mod == BLOCK_BLACKLIST1 || mod == BLOCK_BLACKLIST2 || mod == BLOCK_BLACKLIST3 || mod == BLOCK_BLACKLIST4;
    }

    public static boolean isItemBlackList(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != SensorCraft.modifier) {
            return false;
        }
        Modifier mod = Modifier.byDamage(stack.func_77960_j());
        return mod == ITEM_BLACKLIST1 || mod == ITEM_BLACKLIST2 || mod == ITEM_BLACKLIST3 || mod == ITEM_BLACKLIST4;
    }

    public static List<Modifier> fromStacks(List<ItemStack> stacks) {
        LinkedList ret = Lists.newLinkedList();
        for (ItemStack stack : stacks) {
            if (stack.func_77973_b() != SensorCraft.modifier) continue;
            ret.add(Modifier.byDamage(stack.func_77960_j()));
        }
        return ret;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }
}

