/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryItemStack
extends InventoryBasic {
    protected final ItemStack stack;
    protected final EntityPlayer player;
    protected final int slot;
    protected final boolean readOnly;

    public InventoryItemStack(ItemStack stack, EntityPlayer player, int slot, String title, int slotCount) {
        this(stack, player, slot, false, title, slotCount);
    }

    public InventoryItemStack(ItemStack stack, EntityPlayer player, int slot, boolean readOnly, String title, int slotCount) {
        super(title, false, slotCount);
        this.stack = stack;
        this.player = player;
        this.slot = slot;
        this.readOnly = readOnly;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Inventory")) {
            this.readFromNBT(stack.func_77978_p().func_74775_l("Inventory"));
        }
    }

    public int getReadOnlySlot() {
        return this.slot;
    }

    public void func_70296_d() {
        if (this.readOnly) {
            return;
        }
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = this.stack.func_77978_p();
        NBTTagCompound invNbt = new NBTTagCompound();
        this.writeToNBT(invNbt);
        nbt.func_74782_a("Inventory", (NBTBase)invNbt);
        this.player.field_71071_by.func_70299_a(this.slot, this.stack);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.func_70302_i_()) continue;
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void func_174886_c(EntityPlayer player) {
        this.func_70296_d();
    }
}

