/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.client;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cubex2.cxlibrary.model.MultiBakedModel;
import cubex2.sensorcraft.block.BlockSensor;
import cubex2.sensorcraft.block.Sensor;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelSensorFactory
implements IModel {
    public static final ResourceLocation IRON_ON = new ResourceLocation("sensorcraft:block/sensor_iron_powered");
    public static final ResourceLocation GOLD_ON = new ResourceLocation("sensorcraft:block/sensor_gold_powered");
    public static final ResourceLocation DIAMOND_ON = new ResourceLocation("sensorcraft:block/sensor_diamond_powered");
    public static final ResourceLocation EMERALD_ON = new ResourceLocation("sensorcraft:block/sensor_emerald_powered");
    public static final ResourceLocation IRON_OFF = new ResourceLocation("sensorcraft:block/sensor_iron");
    public static final ResourceLocation GOLD_OFF = new ResourceLocation("sensorcraft:block/sensor_gold");
    public static final ResourceLocation DIAMOND_OFF = new ResourceLocation("sensorcraft:block/sensor_diamond");
    public static final ResourceLocation EMERALD_OFF = new ResourceLocation("sensorcraft:block/sensor_emerald");
    public static final ResourceLocation[] ON = new ResourceLocation[]{IRON_ON, GOLD_ON, DIAMOND_ON, EMERALD_ON};
    public static final ResourceLocation[] OFF = new ResourceLocation[]{IRON_OFF, GOLD_OFF, DIAMOND_OFF, EMERALD_OFF};
    private final List<ResourceLocation> deps;
    private final ResourceLocation powered;
    private final ResourceLocation notPowered;
    private static final BiPredicate<IBlockState, EnumFacing> PREDICATE_ON = (state, enumFacing) -> (Boolean)state.func_177229_b((IProperty)BlockSensor.getProperty(enumFacing));

    public ModelSensorFactory(Sensor sensor) {
        this.powered = ON[sensor.ordinal()];
        this.notPowered = OFF[sensor.ordinal()];
        this.deps = Lists.newArrayList((Object[])new ResourceLocation[]{this.powered});
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf(this.deps);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            IModel base = ModelLoaderRegistry.getModel((ResourceLocation)this.notPowered);
            IModel powered = ModelLoaderRegistry.getModel((ResourceLocation)this.powered);
            IBakedModel bakedBase = base.bake(state, format, bakedTextureGetter);
            IBakedModel bakedPowered = powered.bake(state, format, bakedTextureGetter);
            return new MultiBakedModel.Builder().putModel(PREDICATE_ON.negate(), bakedBase).putModel(PREDICATE_ON, bakedPowered).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

