/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft.block;

import cubex2.sensorcraft.SensorCraft;
import cubex2.sensorcraft.block.Sensor;
import cubex2.sensorcraft.item.ItemSensor;
import cubex2.sensorcraft.tileentity.TileEntitySensor;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockSensor
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<Sensor> VARIANT = PropertyEnum.func_177709_a((String)"variant", Sensor.class);
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    public static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool[] PROPERTIES = new PropertyBool[]{BOTTOM, TOP, NORTH, SOUTH, WEST, EAST};

    public static PropertyBool getProperty(EnumFacing facing) {
        return PROPERTIES[facing.ordinal()];
    }

    public BlockSensor() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Sensor.IRON)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("sensorcraftsensor");
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(SensorCraft.creativeTab);
    }

    public Block func_149663_c(String name) {
        super.func_149663_c(name);
        this.setRegistryName("sensorcraft", "sensor");
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemSensor(this).setRegistryName(this.getRegistryName()));
        return this;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySensor();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntitySensor)) {
            return true;
        }
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)SensorCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntitySensor)) {
            return 0;
        }
        TileEntitySensor sensor = (TileEntitySensor)te;
        return sensor.getPower(side.func_176734_d());
    }

    public int func_180651_a(IBlockState state) {
        return ((Sensor)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < Sensor.values().length; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySensor) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Sensor.byDamage(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Sensor)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, TOP, BOTTOM, NORTH, SOUTH, EAST, WEST});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean top = false;
        boolean bottom = false;
        boolean north = false;
        boolean south = false;
        boolean east = false;
        boolean west = false;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntitySensor) {
            TileEntitySensor sensor = (TileEntitySensor)te;
            top = sensor.getPower(EnumFacing.UP) > 0;
            bottom = sensor.getPower(EnumFacing.DOWN) > 0;
            north = sensor.getPower(EnumFacing.NORTH) > 0;
            south = sensor.getPower(EnumFacing.SOUTH) > 0;
            east = sensor.getPower(EnumFacing.EAST) > 0;
            west = sensor.getPower(EnumFacing.WEST) > 0;
        }
        return state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(top)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(bottom)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(west));
    }
}

