/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft;

import com.google.common.collect.Lists;
import cubex2.sensorcraft.api.IItemModifier;
import cubex2.sensorcraft.api.IItemModule;
import cubex2.sensorcraft.api.ISensorModule;
import cubex2.sensorcraft.inventory.InventorySensor;
import cubex2.sensorcraft.item.Modifier;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;

public class Util {
    public static int getTotalRangeUpgrade(List<ItemStack> modifiers) {
        int ret = 0;
        for (Modifier modifier : Modifier.fromStacks(modifiers)) {
            if (modifier == Modifier.RANGE1) {
                ++ret;
                continue;
            }
            if (modifier == Modifier.RANGE2) {
                ret += 2;
                continue;
            }
            if (modifier == Modifier.RANGE4) {
                ret += 4;
                continue;
            }
            if (modifier != Modifier.RANGE8) continue;
            ret += 8;
        }
        return ret;
    }

    public static List<ItemStack> readStacksFromStack(ItemStack stack) {
        LinkedList ret = Lists.newLinkedList();
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p().func_74775_l("Inventory");
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0) continue;
                ret.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound));
            }
        }
        return ret;
    }

    public static List<ItemStack> getBlackListedBlocks(List<ItemStack> modifiers) {
        LinkedList ret = Lists.newLinkedList();
        for (ItemStack stack : modifiers) {
            if (!Modifier.isBlockBlackList(stack)) continue;
            ret.addAll(Util.readStacksFromStack(stack));
        }
        return ret;
    }

    public static List<ItemStack> getBlackListedItems(List<ItemStack> modifiers) {
        LinkedList ret = Lists.newLinkedList();
        for (ItemStack stack : modifiers) {
            if (!Modifier.isItemBlackList(stack)) continue;
            ret.addAll(Util.readStacksFromStack(stack));
        }
        return ret;
    }

    public static List<ItemStack> getModifiersFor(InventorySensor inv, int module, int numModifiers, int numMaxModules) {
        LinkedList list = Lists.newLinkedList();
        for (int i = 0; i < numModifiers; ++i) {
            ItemStack stack = inv.func_70301_a(numMaxModules + module * numModifiers + i);
            if (stack == null || !(stack.func_77973_b() instanceof IItemModifier)) continue;
            list.add(stack);
        }
        return list;
    }

    public static int calculatePower(InventorySensor inv, int index) {
        ItemStack stack = inv.func_70301_a(index);
        if (stack == null) {
            return 0;
        }
        List<ItemStack> modifiers = inv.getModifiersFor(index);
        ISensorModule module = ((IItemModule)stack.func_77973_b()).getModule(stack);
        int modulePower = inv.getPower(module, stack, modifiers);
        List<Modifier> mods = Modifier.fromStacks(modifiers);
        for (ItemStack itemStack : modifiers) {
            if (!Modifier.isModifier(itemStack, Modifier.OUTPUT_OFFSET)) continue;
            modulePower += Util.getInt(itemStack, "OutputOffset", 0);
            break;
        }
        if (mods.contains((Object)Modifier.OUTPUT_DIGITAL)) {
            modulePower = modulePower > 0 ? 15 : 0;
        }
        modulePower = MathHelper.func_76125_a((int)modulePower, (int)0, (int)15);
        if (mods.contains((Object)Modifier.OUTPUT_INVERT)) {
            modulePower = 15 - modulePower;
        }
        return modulePower;
    }

    public static int getInt(ItemStack stack, String key, int _default) {
        if (stack == null || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(key)) {
            return _default;
        }
        return stack.func_77978_p().func_74762_e(key);
    }

    public static void setInt(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(key, value);
    }

    public static int getSlotFromHand(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return player.field_71071_by.field_70461_c;
        }
        return player.field_71071_by.func_70302_i_() - 1;
    }
}

