/*
 * Decompiled with CFR 0.152.
 */
package cubex2.sensorcraft;

import cubex2.sensorcraft.APIImpl;
import cubex2.sensorcraft.api.SensorCraftAPI;
import cubex2.sensorcraft.block.BlockSensor;
import cubex2.sensorcraft.item.ItemMaterial;
import cubex2.sensorcraft.item.ItemMobileSensor;
import cubex2.sensorcraft.item.ItemModifier;
import cubex2.sensorcraft.item.ItemSensorModule;
import cubex2.sensorcraft.item.Module;
import cubex2.sensorcraft.network.PacketSetOutputOffset;
import cubex2.sensorcraft.network.PacketUpdatePower;
import cubex2.sensorcraft.proxy.CommonProxy;
import cubex2.sensorcraft.tileentity.TileEntitySensor;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(modid="sensorcraft", version="0.4.0", name="SensorCraft", dependencies="required-after:cxlibrary@[1.2.0,)", acceptedMinecraftVersions="[1.10]")
public class SensorCraft {
    public static final String MODID = "sensorcraft";
    public static final String VERSION = "0.4.0";
    public static final String NAME = "SensorCraft";
    public static final String DEPENENCIES = "required-after:cxlibrary@[1.2.0,)";
    @Mod.Instance(value="sensorcraft")
    public static SensorCraft instance;
    @SidedProxy(clientSide="cubex2.sensorcraft.proxy.ClientProxy", serverSide="cubex2.sensorcraft.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper network;
    public static CreativeTabs creativeTab;
    public static final Block sensor;
    public static final Item module;
    public static final Item modifier;
    public static final Item mobileSensor;
    public static final Item material;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        SensorCraftAPI.instance = new APIImpl();
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        network.registerMessage(PacketUpdatePower.Handler.class, PacketUpdatePower.class, 0, Side.CLIENT);
        network.registerMessage(PacketSetOutputOffset.Handler.class, PacketSetOutputOffset.class, 1, Side.SERVER);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntitySensor.class, (String)"sensorCraftSensorTE");
        module.setRegistryName(MODID, "module");
        GameRegistry.register((IForgeRegistryEntry)module);
        modifier.setRegistryName(MODID, "modifier");
        GameRegistry.register((IForgeRegistryEntry)modifier);
        mobileSensor.setRegistryName(MODID, "mobileSensor");
        GameRegistry.register((IForgeRegistryEntry)mobileSensor);
        material.setRegistryName(MODID, "material");
        GameRegistry.register((IForgeRegistryEntry)material);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        this.addRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private void addRecipes() {
        String[] blocks = new String[]{"blockIron", "blockGold", "blockDiamond", "blockEmerald"};
        for (int i = 0; i < 4; ++i) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(sensor, 1, i), new Object[]{"CRC", "RBR", "CRC", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('R'), Blocks.field_150451_bX, Character.valueOf('B'), blocks[i]}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(mobileSensor, new Object[]{" E ", "ESE", " E ", Character.valueOf('E'), Items.field_151061_bv, Character.valueOf('S'), new ItemStack(sensor, 1, 2)}));
        for (Module mod : Module.values()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(module, 1, mod.ordinal()), new Object[]{"IRI", "RMR", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), mod.getCraftMaterial()}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(material, 1, 0), new Object[]{"IRI", "RPR", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Items.field_151121_aF}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(material, 1, 1), new Object[]{"IRI", "RPR", "IRI", Character.valueOf('I'), "ingotGold", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Items.field_151121_aF}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(material, 1, 2), new Object[]{"IRI", "RPR", "IRI", Character.valueOf('I'), "gemDiamond", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Items.field_151121_aF}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(material, 1, 3), new Object[]{"IRI", "RPR", "IRI", Character.valueOf('I'), "gemEmerald", Character.valueOf('R'), "dustRedstone", Character.valueOf('P'), Items.field_151121_aF}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 0), new Object[]{"R", "M", Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), new ItemStack(material, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 1), new Object[]{"M", "R", Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), new ItemStack(material, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 2), new Object[]{"RMR", Character.valueOf('R'), "dustRedstone", Character.valueOf('M'), new ItemStack(material, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 3), new Object[]{"R", "M", "T", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('M'), new ItemStack(material, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 4), new Object[]{"B", "M", Character.valueOf('B'), Blocks.field_150430_aB, Character.valueOf('M'), new ItemStack(material, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 5), new Object[]{"E", "M", Character.valueOf('E'), Blocks.field_150331_J, Character.valueOf('M'), new ItemStack(material, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 6), new Object[]{"B", "M", Character.valueOf('B'), Items.field_151031_f, Character.valueOf('M'), new ItemStack(material, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 7), new Object[]{"B", "M", Character.valueOf('B'), Items.field_151031_f, Character.valueOf('M'), new ItemStack(material, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 8), new Object[]{"B", "M", Character.valueOf('B'), Items.field_151031_f, Character.valueOf('M'), new ItemStack(material, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 9), new Object[]{"B", "M", Character.valueOf('B'), Items.field_151031_f, Character.valueOf('M'), new ItemStack(material, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 10), new Object[]{"D", "M", "P", Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 11), new Object[]{"D", "M", "P", Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 12), new Object[]{"D", "M", "P", Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 13), new Object[]{"D", "M", "P", Character.valueOf('D'), Blocks.field_150346_d, Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 14), new Object[]{"S", "M", "P", Character.valueOf('S'), "stickWood", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 15), new Object[]{"S", "M", "P", Character.valueOf('S'), "stickWood", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 16), new Object[]{"S", "M", "P", Character.valueOf('S'), "stickWood", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 2)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modifier, 1, 17), new Object[]{"S", "M", "P", Character.valueOf('S'), "stickWood", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('M'), new ItemStack(material, 1, 3)}));
    }

    static {
        creativeTab = new CreativeTabs(MODID){

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return Item.func_150898_a((Block)sensor);
            }

            @SideOnly(value=Side.CLIENT)
            public int func_151243_f() {
                return 3;
            }
        };
        sensor = new BlockSensor();
        module = new ItemSensorModule();
        modifier = new ItemModifier();
        mobileSensor = new ItemMobileSensor();
        material = new ItemMaterial();
    }
}

